/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingClusterStateUpdateRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateAckListener;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettingProvider;
import org.elasticsearch.index.IndexSettingProviders;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.threadpool.ThreadPool;

public class MetadataMappingService {
    public static final Setting<Priority> PUT_MAPPING_PRIORITY_SETTING = Setting.enumSetting(Priority.class, "cluster.service.put_mapping.priority", Priority.HIGH, Setting.Property.NodeScope);
    private static final Logger logger = LogManager.getLogger(MetadataMappingService.class);
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final MasterServiceTaskQueue<PutMappingClusterStateUpdateTask> taskQueue;

    @Inject
    public MetadataMappingService(ClusterService clusterService, IndicesService indicesService, IndexSettingProviders indexSettingProviders) {
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.taskQueue = clusterService.createTaskQueue("put-mapping", PUT_MAPPING_PRIORITY_SETTING.get(clusterService.getSettings()), new PutMappingExecutor(indexSettingProviders));
    }

    public void putMapping(PutMappingClusterStateUpdateRequest request, ActionListener<AcknowledgedResponse> listener) {
        try {
            if (this.isWholeRequestNoop(request)) {
                listener.onResponse(AcknowledgedResponse.TRUE);
                return;
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
            return;
        }
        this.taskQueue.submitTask("put-mapping " + Strings.arrayToCommaDelimitedString(request.indices()), new PutMappingClusterStateUpdateTask(request, listener), request.masterNodeTimeout());
    }

    private boolean isWholeRequestNoop(PutMappingClusterStateUpdateRequest request) throws IOException {
        assert (ThreadPool.assertCurrentThreadPool("management"));
        ClusterState state = this.clusterService.state();
        MapperService.MergeReason reason = request.autoUpdate() ? MapperService.MergeReason.MAPPING_AUTO_UPDATE : MapperService.MergeReason.MAPPING_UPDATE;
        for (Index index : request.indices()) {
            Optional<ProjectMetadata> project = state.metadata().lookupProject(index);
            if (project.isEmpty()) {
                return false;
            }
            IndexMetadata indexMetadata = project.get().index(index);
            if (indexMetadata == null) {
                return false;
            }
            MappingMetadata mappingMetadata = indexMetadata.mapping();
            if (mappingMetadata == null) {
                return false;
            }
            if (request.source().equals(mappingMetadata.source())) continue;
            try (MapperService mapperService = this.indicesService.createIndexMapperServiceForValidation(indexMetadata);){
                mapperService.merge(indexMetadata, MapperService.MergeReason.MAPPING_RECOVERY);
                DocumentMapper mergedMapper = mapperService.merge("_doc", request.source(), reason);
                CompressedXContent updatedSource = mergedMapper.mappingSource();
                if (updatedSource.equals(mappingMetadata.source())) continue;
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    class PutMappingExecutor
    implements ClusterStateTaskExecutor<PutMappingClusterStateUpdateTask> {
        private final IndexSettingProviders indexSettingProviders;

        PutMappingExecutor() {
            this(IndexSettingProviders.EMPTY);
        }

        PutMappingExecutor(IndexSettingProviders indexSettingProviders) {
            this.indexSettingProviders = indexSettingProviders;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ClusterState execute(ClusterStateTaskExecutor.BatchExecutionContext<PutMappingClusterStateUpdateTask> batchExecutionContext) throws Exception {
            HashMap<Index, MapperService> indexMapperServices = new HashMap<Index, MapperService>();
            try {
                ClusterState currentState = batchExecutionContext.initialState();
                for (ClusterStateTaskExecutor.TaskContext<PutMappingClusterStateUpdateTask> taskContext : batchExecutionContext.taskContexts()) {
                    PutMappingClusterStateUpdateTask task = taskContext.getTask();
                    PutMappingClusterStateUpdateRequest request = task.request;
                    try {
                        Releasable ignored = taskContext.captureResponseHeaders();
                        try {
                            for (Index index : request.indices()) {
                                IndexMetadata indexMetadata = currentState.metadata().indexMetadata(index);
                                if (indexMapperServices.containsKey(indexMetadata.getIndex())) continue;
                                MapperService mapperService = MetadataMappingService.this.indicesService.createIndexMapperServiceForValidation(indexMetadata);
                                indexMapperServices.put(index, mapperService);
                                mapperService.merge(indexMetadata, MapperService.MergeReason.MAPPING_RECOVERY);
                            }
                            currentState = this.applyRequest(currentState, request, indexMapperServices);
                            taskContext.success(task);
                        }
                        finally {
                            if (ignored == null) continue;
                            ignored.close();
                        }
                    }
                    catch (Exception e) {
                        taskContext.onFailure(e);
                    }
                }
                ClusterState clusterState = currentState;
                return clusterState;
            }
            finally {
                IOUtils.close(indexMapperServices.values());
            }
        }

        private ClusterState applyRequest(ClusterState currentState, PutMappingClusterStateUpdateRequest request, Map<Index, MapperService> indexMapperServices) {
            MapperService.MergeReason reason = request.autoUpdate() ? MapperService.MergeReason.MAPPING_AUTO_UPDATE : MapperService.MergeReason.MAPPING_UPDATE;
            Metadata.Builder builder = Metadata.builder(currentState.metadata());
            boolean updated = false;
            for (Index index : request.indices()) {
                ProjectMetadata projectMetadata = currentState.metadata().projectFor(index);
                IndexMetadata indexMetadata = projectMetadata.index(index);
                MapperService mapperService = indexMapperServices.get(index);
                CompressedXContent existingSource = mapperService.documentMapper() != null ? mapperService.documentMapper().mappingSource() : null;
                DocumentMapper mergedMapper = mapperService.merge("_doc", request.source(), reason);
                CompressedXContent updatedSource = mergedMapper.mappingSource();
                if (updatedSource.equals(existingSource)) continue;
                this.logMappingResult(index, existingSource, updatedSource, mergedMapper.type());
                IndexMetadata.Builder indexMetadataBuilder = IndexMetadata.builder(indexMetadata);
                DocumentMapper docMapper = mapperService.documentMapper();
                if (docMapper != null) {
                    indexMetadataBuilder.putMapping(new MappingMetadata(docMapper));
                    indexMetadataBuilder.putInferenceFields(docMapper.mappers().inferenceFields());
                }
                boolean updatedSettings = false;
                Settings.Builder additionalIndexSettings = Settings.builder();
                indexMetadataBuilder.mappingVersion(1L + indexMetadataBuilder.mappingVersion()).mappingsUpdatedVersion(IndexVersion.current());
                for (IndexSettingProvider provider : this.indexSettingProviders.getIndexSettingProviders()) {
                    Settings.Builder newAdditionalSettingsBuilder = Settings.builder();
                    provider.onUpdateMappings(indexMetadata, docMapper, newAdditionalSettingsBuilder);
                    if (newAdditionalSettingsBuilder.keys().isEmpty()) continue;
                    Settings newAdditionalSettings = newAdditionalSettingsBuilder.build();
                    MetadataCreateIndexService.validateAdditionalSettings(provider, newAdditionalSettings, additionalIndexSettings);
                    additionalIndexSettings.put(newAdditionalSettings);
                    updatedSettings = true;
                }
                if (updatedSettings) {
                    Settings.Builder indexSettingsBuilder = Settings.builder();
                    indexSettingsBuilder.put(indexMetadata.getSettings());
                    indexSettingsBuilder.put(additionalIndexSettings.build());
                    indexMetadataBuilder.settings(indexSettingsBuilder.build());
                    indexMetadataBuilder.settingsVersion(1L + indexMetadata.getSettingsVersion());
                }
                builder.getProject(projectMetadata.id()).put(indexMetadataBuilder);
                updated = true;
            }
            if (updated) {
                return ClusterState.builder(currentState).metadata(builder).build();
            }
            return currentState;
        }

        private void logMappingResult(Index index, CompressedXContent existingSource, CompressedXContent updatedSource, String type) {
            if (existingSource != null) {
                if (!existingSource.equals(updatedSource)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("{} update_mapping [{}] with source [{}]", (Object)index, (Object)type, (Object)updatedSource);
                    } else if (logger.isInfoEnabled()) {
                        logger.info("{} update_mapping [{}]", (Object)index, (Object)type);
                    }
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug("{} create_mapping with source [{}]", (Object)index, (Object)updatedSource);
            } else if (logger.isInfoEnabled()) {
                logger.info("{} create_mapping", (Object)index);
            }
        }
    }

    record PutMappingClusterStateUpdateTask(PutMappingClusterStateUpdateRequest request, ActionListener<AcknowledgedResponse> listener) implements ClusterStateTaskListener,
    ClusterStateAckListener
    {
        @Override
        public void onFailure(Exception e) {
            this.listener.onFailure(e);
        }

        @Override
        public boolean mustAck(DiscoveryNode discoveryNode) {
            return true;
        }

        @Override
        public void onAllNodesAcked() {
            this.listener.onResponse(AcknowledgedResponse.of(true));
        }

        @Override
        public void onAckFailure(Exception e) {
            this.listener.onResponse(AcknowledgedResponse.of(false));
        }

        @Override
        public void onAckTimeout() {
            this.listener.onResponse(AcknowledgedResponse.FALSE);
        }

        @Override
        public TimeValue ackTimeout() {
            return this.request.ackTimeout();
        }
    }
}

