/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.admin.indices.rollover.RolloverConfiguration;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.cluster.metadata.Template;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class ComponentTemplate
implements SimpleDiffable<ComponentTemplate>,
ToXContentObject {
    private static final ParseField TEMPLATE = new ParseField("template", new String[0]);
    private static final ParseField VERSION = new ParseField("version", new String[0]);
    private static final ParseField METADATA = new ParseField("_meta", new String[0]);
    private static final ParseField DEPRECATED = new ParseField("deprecated", new String[0]);
    private static final ParseField CREATED_DATE = new ParseField("created_date", new String[0]);
    private static final ParseField CREATED_DATE_MILLIS = new ParseField("created_date_millis", new String[0]);
    private static final ParseField MODIFIED_DATE = new ParseField("modified_date", new String[0]);
    private static final ParseField MODIFIED_DATE_MILLIS = new ParseField("modified_date_millis", new String[0]);
    public static final ConstructingObjectParser<ComponentTemplate, Void> PARSER = new ConstructingObjectParser("component_template", false, a -> new ComponentTemplate((Template)a[0], (Long)a[1], (Map)a[2], (Boolean)a[3], (Long)a[4], (Long)a[5]));
    private static final TransportVersion COMPONENT_TEMPLATE_TRACKING_INFO;
    private final Template template;
    @Nullable
    private final Long version;
    @Nullable
    private final Map<String, Object> metadata;
    @Nullable
    private final Boolean deprecated;
    @Nullable
    private final Long createdDateMillis;
    @Nullable
    private final Long modifiedDateMillis;

    static Diff<ComponentTemplate> readComponentTemplateDiffFrom(StreamInput in) throws IOException {
        return SimpleDiffable.readDiffFrom(ComponentTemplate::new, in);
    }

    public static ComponentTemplate parse(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public ComponentTemplate(Template template, @Nullable Long version, @Nullable Map<String, Object> metadata) {
        this(template, version, metadata, null, null, null);
    }

    public ComponentTemplate(Template template, @Nullable Long version, @Nullable Map<String, Object> metadata, @Nullable Boolean deprecated, @Nullable Long createdDateMillis, @Nullable Long modifiedDateMillis) {
        this.template = template;
        this.version = version;
        this.metadata = metadata;
        this.deprecated = deprecated;
        this.createdDateMillis = createdDateMillis;
        this.modifiedDateMillis = modifiedDateMillis;
    }

    public ComponentTemplate(StreamInput in) throws IOException {
        this.template = new Template(in);
        this.version = in.readOptionalVLong();
        this.metadata = in.readBoolean() ? in.readGenericMap() : null;
        this.deprecated = in.readOptionalBoolean();
        if (in.getTransportVersion().supports(COMPONENT_TEMPLATE_TRACKING_INFO)) {
            this.createdDateMillis = in.readOptionalLong();
            this.modifiedDateMillis = in.readOptionalLong();
        } else {
            this.createdDateMillis = null;
            this.modifiedDateMillis = null;
        }
    }

    public Template template() {
        return this.template;
    }

    @Nullable
    public Long version() {
        return this.version;
    }

    @Nullable
    public Map<String, Object> metadata() {
        return this.metadata;
    }

    public Boolean deprecated() {
        return this.deprecated;
    }

    public boolean isDeprecated() {
        return Boolean.TRUE.equals(this.deprecated);
    }

    public Optional<Long> createdDateMillis() {
        return Optional.ofNullable(this.createdDateMillis);
    }

    public Optional<Long> modifiedDateMillis() {
        return Optional.ofNullable(this.modifiedDateMillis);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.template.writeTo(out);
        out.writeOptionalVLong(this.version);
        if (this.metadata == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeGenericMap(this.metadata);
        }
        out.writeOptionalBoolean(this.deprecated);
        if (out.getTransportVersion().supports(COMPONENT_TEMPLATE_TRACKING_INFO)) {
            out.writeOptionalLong(this.createdDateMillis);
            out.writeOptionalLong(this.modifiedDateMillis);
        }
    }

    public int hashCode() {
        return Objects.hash(this.template, this.version, this.metadata, this.deprecated, this.createdDateMillis, this.modifiedDateMillis);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ComponentTemplate other = (ComponentTemplate)obj;
        return this.contentEquals(other) && Objects.equals(this.createdDateMillis, other.createdDateMillis) && Objects.equals(this.modifiedDateMillis, other.modifiedDateMillis);
    }

    public boolean contentEquals(ComponentTemplate other) {
        if (other == null) {
            return false;
        }
        return Objects.equals(this.template, other.template) && Objects.equals(this.version, other.version) && Objects.equals(this.metadata, other.metadata) && Objects.equals(this.deprecated, other.deprecated);
    }

    public String toString() {
        return Strings.toString(this);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.toXContent(builder, params, null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params, @Nullable RolloverConfiguration rolloverConfiguration) throws IOException {
        builder.startObject();
        builder.field(TEMPLATE.getPreferredName());
        this.template.toXContent(builder, params, rolloverConfiguration);
        if (this.version != null) {
            builder.field(VERSION.getPreferredName(), this.version);
        }
        if (this.metadata != null) {
            builder.field(METADATA.getPreferredName(), this.metadata);
        }
        if (this.deprecated != null) {
            builder.field(DEPRECATED.getPreferredName(), this.deprecated);
        }
        if (this.createdDateMillis != null) {
            builder.timestampFieldsFromUnixEpochMillis(CREATED_DATE_MILLIS.getPreferredName(), CREATED_DATE.getPreferredName(), this.createdDateMillis);
        }
        if (this.modifiedDateMillis != null) {
            builder.timestampFieldsFromUnixEpochMillis(MODIFIED_DATE_MILLIS.getPreferredName(), MODIFIED_DATE.getPreferredName(), this.modifiedDateMillis);
        }
        builder.endObject();
        return builder;
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), Template.PARSER, TEMPLATE);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), VERSION);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), METADATA);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), DEPRECATED);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), CREATED_DATE_MILLIS);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), MODIFIED_DATE_MILLIS);
        COMPONENT_TEMPLATE_TRACKING_INFO = TransportVersion.fromName("component_template_tracking_info");
    }
}

