/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.repositories.RepositoryOperation;
import org.elasticsearch.xcontent.ToXContent;

public final class RepositoryCleanupInProgress
extends AbstractNamedDiffable<ClusterState.Custom>
implements ClusterState.Custom {
    public static final RepositoryCleanupInProgress EMPTY = new RepositoryCleanupInProgress(List.of());
    public static final String TYPE = "repository_cleanup";
    private static final TransportVersion PROJECT_ID_IN_SNAPSHOTS_DELETIONS_AND_REPO_CLEANUP = TransportVersion.fromName("project_id_in_snapshots_deletions_and_repo_cleanup");
    private final List<Entry> entries;

    public static RepositoryCleanupInProgress get(ClusterState state) {
        return state.custom(TYPE, EMPTY);
    }

    public RepositoryCleanupInProgress(List<Entry> entries) {
        this.entries = entries;
    }

    RepositoryCleanupInProgress(StreamInput in) throws IOException {
        this.entries = in.readCollectionAsList(Entry::readFrom);
    }

    public static NamedDiff<ClusterState.Custom> readDiffFrom(StreamInput in) throws IOException {
        return RepositoryCleanupInProgress.readDiffFrom(ClusterState.Custom.class, TYPE, in);
    }

    public static Entry startedEntry(ProjectId projectId, String repository, long repositoryStateId) {
        return new Entry(projectId, repository, repositoryStateId);
    }

    public boolean hasCleanupInProgress() {
        return !this.entries.isEmpty();
    }

    public List<Entry> entries() {
        return List.copyOf(this.entries);
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.entries);
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params ignored) {
        return Iterators.concat(Iterators.single((builder, params) -> builder.startArray(TYPE)), Iterators.map(this.entries.iterator(), entry -> (builder, params) -> {
            builder.startObject();
            builder.field("repository", entry.repository);
            builder.endObject();
            return builder;
        }), Iterators.single((builder, params) -> builder.endArray()));
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoryCleanupInProgress that = (RepositoryCleanupInProgress)o;
        return Objects.equals(this.entries, that.entries);
    }

    public int hashCode() {
        return Objects.hashCode(this.entries);
    }

    public String toString() {
        return Strings.toString(this);
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.zero();
    }

    public record Entry(ProjectId projectId, String repository, long repositoryStateId) implements Writeable,
    RepositoryOperation
    {
        public static Entry readFrom(StreamInput in) throws IOException {
            ProjectId projectId = in.getTransportVersion().supports(PROJECT_ID_IN_SNAPSHOTS_DELETIONS_AND_REPO_CLEANUP) ? ProjectId.readFrom(in) : ProjectId.DEFAULT;
            return new Entry(projectId, in.readString(), in.readLong());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (out.getTransportVersion().supports(PROJECT_ID_IN_SNAPSHOTS_DELETIONS_AND_REPO_CLEANUP)) {
                this.projectId.writeTo(out);
            } else if (!ProjectId.DEFAULT.equals(this.projectId)) {
                String message = "Cannot write repository cleanup entry with non-default project id " + String.valueOf(this.projectId) + " to version before " + String.valueOf(PROJECT_ID_IN_SNAPSHOTS_DELETIONS_AND_REPO_CLEANUP);
                assert (false) : message;
                throw new IllegalStateException(message);
            }
            out.writeString(this.repository);
            out.writeLong(this.repositoryStateId);
        }
    }
}

