/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterFeatures;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.Diffable;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.IncompatibleClusterStateVersionException;
import org.elasticsearch.cluster.NamedDiffable;
import org.elasticsearch.cluster.NamedDiffableValueSerializer;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.coordination.CoordinationMetadata;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.GlobalRoutingTable;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.version.CompatibilityVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.VersionedNamedWriteable;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.xcontent.ToXContent;

public class ClusterState
implements ChunkedToXContent,
Diffable<ClusterState> {
    public static final ClusterState EMPTY_STATE = ClusterState.builder(ClusterName.DEFAULT).build();
    private static final NamedDiffableValueSerializer<Custom> CUSTOM_VALUE_SERIALIZER = new NamedDiffableValueSerializer<Custom>(Custom.class);
    private static final DiffableUtils.ValueSerializer<String, CompatibilityVersions> COMPATIBILITY_VERSIONS_VALUE_SERIALIZER = new DiffableUtils.NonDiffableValueSerializer<String, CompatibilityVersions>(){

        @Override
        public void write(CompatibilityVersions value, StreamOutput out) throws IOException {
            value.writeTo(out);
        }

        @Override
        public CompatibilityVersions read(StreamInput in, String key) throws IOException {
            return CompatibilityVersions.readVersion(in);
        }
    };
    public static final String UNKNOWN_UUID = "_na_";
    public static final long UNKNOWN_VERSION = -1L;
    private static final TransportVersion MULTI_PROJECT = TransportVersion.fromName("multi_project");
    private final long version;
    private final String stateUUID;
    private final GlobalRoutingTable routingTable;
    private final DiscoveryNodes nodes;
    private final Map<String, CompatibilityVersions> compatibilityVersions;
    private final CompatibilityVersions minVersions;
    private final ClusterFeatures clusterFeatures;
    private final Metadata metadata;
    private final ClusterBlocks blocks;
    private final Map<String, Custom> customs;
    private final ClusterName clusterName;
    private final boolean wasReadFromDiff;
    private volatile RoutingNodes routingNodes;
    public static final Version VERSION_INTRODUCING_TRANSPORT_VERSIONS = Version.V_8_8_0;

    public ClusterState(long version, String stateUUID, ClusterState state) {
        this(state.clusterName, version, stateUUID, state.metadata(), state.routingTable, state.nodes(), state.compatibilityVersions, state.clusterFeatures(), state.blocks(), state.customs(), false, state.routingNodes);
    }

    public ClusterState(ClusterName clusterName, long version, String stateUUID, Metadata metadata, GlobalRoutingTable routingTable, DiscoveryNodes nodes, Map<String, CompatibilityVersions> compatibilityVersions, ClusterFeatures clusterFeatures, ClusterBlocks blocks, Map<String, Custom> customs, boolean wasReadFromDiff, @Nullable RoutingNodes routingNodes) {
        this.version = version;
        this.stateUUID = stateUUID;
        this.clusterName = clusterName;
        this.metadata = metadata;
        this.routingTable = routingTable;
        this.nodes = nodes;
        this.compatibilityVersions = Map.copyOf(compatibilityVersions);
        this.clusterFeatures = clusterFeatures;
        this.blocks = blocks;
        this.customs = customs;
        this.wasReadFromDiff = wasReadFromDiff;
        this.routingNodes = routingNodes;
        assert (ClusterState.assertConsistentRoutingNodes(routingTable, nodes, routingNodes));
        assert (ClusterState.assertConsistentProjectState(routingTable, metadata));
        this.minVersions = blocks.hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK) ? new CompatibilityVersions(TransportVersion.minimumCompatible(), Map.of()) : CompatibilityVersions.minimumVersions(compatibilityVersions.values());
    }

    private static boolean assertConsistentRoutingNodes(GlobalRoutingTable routingTable, DiscoveryNodes nodes, @Nullable RoutingNodes routingNodes) {
        if (routingNodes == null) {
            return true;
        }
        RoutingNodes expected = RoutingNodes.immutable(routingTable, nodes);
        assert (routingNodes.equals(expected)) : "RoutingNodes [" + String.valueOf(routingNodes) + "] are not consistent with this cluster state [" + String.valueOf(expected) + "]";
        return true;
    }

    private static boolean assertConsistentProjectState(GlobalRoutingTable routingTable, Metadata metadata) {
        if (metadata == null) {
            return true;
        }
        Set<ProjectId> metadataProjects = metadata.projects().keySet();
        for (ProjectId projectId : metadataProjects) {
            assert (routingTable.routingTables().containsKey(projectId)) : "Project [" + String.valueOf(projectId) + "] does not exist in routing table";
        }
        if (metadataProjects.size() != routingTable.size()) {
            for (ProjectId projectId : routingTable.routingTables().keySet()) {
                assert (metadataProjects.contains(projectId)) : "Project [" + String.valueOf(projectId) + "] exists in routing table, but not in metadata (" + String.valueOf(metadataProjects) + ")";
            }
        }
        return true;
    }

    public long term() {
        return this.coordinationMetadata().term();
    }

    public long version() {
        return this.version;
    }

    public long getVersion() {
        return this.version();
    }

    public String stateUUID() {
        return this.stateUUID;
    }

    public DiscoveryNodes nodes() {
        return this.nodes;
    }

    public DiscoveryNodes getNodes() {
        return this.nodes();
    }

    public DiscoveryNodes nodesIfRecovered() {
        return this.blocks.hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK) ? DiscoveryNodes.EMPTY_NODES : this.nodes;
    }

    public boolean clusterRecovered() {
        return !this.blocks.hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK);
    }

    public Map<String, CompatibilityVersions> compatibilityVersions() {
        return this.compatibilityVersions;
    }

    public boolean hasMixedSystemIndexVersions() {
        return this.compatibilityVersions.values().stream().anyMatch(e -> !e.systemIndexMappingsVersion().equals(this.minVersions.systemIndexMappingsVersion()));
    }

    public TransportVersion getMinTransportVersion() {
        return this.minVersions.transportVersion();
    }

    public Map<String, SystemIndexDescriptor.MappingsVersion> getMinSystemIndexMappingVersions() {
        return this.minVersions.systemIndexMappingsVersion();
    }

    public ClusterFeatures clusterFeatures() {
        return this.clusterFeatures;
    }

    public Metadata metadata() {
        return this.metadata;
    }

    public Metadata getMetadata() {
        return this.metadata();
    }

    public CoordinationMetadata coordinationMetadata() {
        return this.metadata.coordinationMetadata();
    }

    public GlobalRoutingTable globalRoutingTable() {
        return this.routingTable;
    }

    public RoutingTable routingTable(ProjectId projectId) {
        return this.routingTable.routingTable(projectId);
    }

    @Deprecated(forRemoval=true)
    public RoutingTable routingTable() {
        return this.routingTable.getRoutingTable();
    }

    @Deprecated(forRemoval=true)
    public RoutingTable getRoutingTable() {
        return this.routingTable();
    }

    public ClusterBlocks blocks() {
        return this.blocks;
    }

    public ClusterBlocks getBlocks() {
        return this.blocks;
    }

    public Map<String, Custom> customs() {
        return this.customs;
    }

    public Map<String, Custom> getCustoms() {
        return this.customs;
    }

    public <T extends Custom> T custom(String type) {
        return (T)this.customs.get(type);
    }

    public <T extends Custom> T custom(String type, T defaultValue) {
        return (T)this.customs.getOrDefault(type, defaultValue);
    }

    public ClusterName getClusterName() {
        return this.clusterName;
    }

    public CoordinationMetadata.VotingConfiguration getLastAcceptedConfiguration() {
        return this.coordinationMetadata().getLastAcceptedConfiguration();
    }

    public CoordinationMetadata.VotingConfiguration getLastCommittedConfiguration() {
        return this.coordinationMetadata().getLastCommittedConfiguration();
    }

    public Set<CoordinationMetadata.VotingConfigExclusion> getVotingConfigExclusions() {
        return this.coordinationMetadata().getVotingConfigExclusions();
    }

    public RoutingNodes getRoutingNodes() {
        RoutingNodes r = this.routingNodes;
        if (r != null) {
            return r;
        }
        r = this.buildRoutingNodes();
        return r;
    }

    private synchronized RoutingNodes buildRoutingNodes() {
        RoutingNodes r = this.routingNodes;
        if (r != null) {
            return r;
        }
        this.routingNodes = r = RoutingNodes.immutable(this.routingTable, this.nodes);
        return r;
    }

    public RoutingNodes mutableRoutingNodes() {
        RoutingNodes nodes = this.routingNodes;
        if (nodes != null) {
            return nodes.mutableCopy();
        }
        return RoutingNodes.mutable(this.routingTable, this.nodes);
    }

    public void initializeAsync(Executor executor) {
        boolean anyProjectRequiresInitialization;
        if (this.routingNodes == null) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    ClusterState.this.getRoutingNodes();
                }

                public String toString() {
                    return "async initialization of routing nodes for cluster state " + ClusterState.this.version();
                }
            });
        }
        boolean bl = anyProjectRequiresInitialization = !this.metadata.projects().values().stream().allMatch(ProjectMetadata::indicesLookupInitialized);
        if (anyProjectRequiresInitialization) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    for (ProjectMetadata project : ClusterState.this.metadata.projects().values()) {
                        if (project.indicesLookupInitialized()) continue;
                        project.getIndicesLookup();
                    }
                }

                public String toString() {
                    return "async initialization of indices lookup for cluster state " + ClusterState.this.version();
                }
            });
        }
    }

    @Deprecated(forRemoval=true)
    public ProjectState projectState() {
        this.metadata.getProject();
        return new ProjectState(this, Metadata.DEFAULT_PROJECT_ID);
    }

    public ProjectState projectState(ProjectId projectId) {
        if (!this.metadata().hasProject(projectId)) {
            throw new IllegalArgumentException("project [" + String.valueOf(projectId) + "] not found");
        }
        return new ProjectState(this, projectId);
    }

    public <E extends Exception> void forEachProject(CheckedConsumer<ProjectState, E> action) throws E {
        for (ProjectId projectId : this.metadata().projects().keySet()) {
            action.accept(this.projectState(projectId));
        }
    }

    public String toString() {
        Object type;
        StringBuilder sb = new StringBuilder();
        String TAB = "   ";
        sb.append("cluster uuid: ").append(this.metadata.clusterUUID()).append(" [committed: ").append(this.metadata.clusterUUIDCommitted()).append("]").append("\n");
        sb.append("version: ").append(this.version).append("\n");
        sb.append("state uuid: ").append(this.stateUUID).append("\n");
        sb.append("from_diff: ").append(this.wasReadFromDiff).append("\n");
        sb.append("meta data version: ").append(this.metadata.version()).append("\n");
        sb.append("   ").append("coordination_metadata:\n");
        sb.append("   ").append("   ").append("term: ").append(this.coordinationMetadata().term()).append("\n");
        sb.append("   ").append("   ").append("last_committed_config: ").append(this.coordinationMetadata().getLastCommittedConfiguration()).append("\n");
        sb.append("   ").append("   ").append("last_accepted_config: ").append(this.coordinationMetadata().getLastAcceptedConfiguration()).append("\n");
        sb.append("   ").append("   ").append("voting tombstones: ").append(this.coordinationMetadata().getVotingConfigExclusions()).append("\n");
        for (Map.Entry<ProjectId, ProjectMetadata> entry : this.metadata.projects().entrySet()) {
            sb.append("   ").append("project[").append(entry.getKey()).append("]:");
            if (entry.getValue().size() == 0) {
                sb.append(" -\n");
                continue;
            }
            sb.append("\n");
            for (IndexMetadata indexMetadata : entry.getValue()) {
                sb.append("   ").append("   ").append(indexMetadata.getIndex());
                sb.append(": v[").append(indexMetadata.getVersion()).append("], mv[").append(indexMetadata.getMappingVersion()).append("], sv[").append(indexMetadata.getSettingsVersion()).append("], av[").append(indexMetadata.getAliasesVersion()).append("]\n");
                for (int shard = 0; shard < indexMetadata.getNumberOfShards(); ++shard) {
                    sb.append("   ").append("   ").append(shard).append(": ");
                    sb.append("p_term [").append(indexMetadata.primaryTerm(shard)).append("], ");
                    sb.append("isa_ids ").append(indexMetadata.inSyncAllocationIds(shard)).append("\n");
                }
            }
        }
        if (!this.metadata.customs().isEmpty()) {
            sb.append("metadata customs (cluster):\n");
            for (Map.Entry<Object, Diffable<ProjectMetadata>> entry : this.metadata.customs().entrySet()) {
                type = (String)entry.getKey();
                Metadata.ClusterCustom clusterCustom = (Metadata.ClusterCustom)entry.getValue();
                sb.append("   ").append((String)type).append(": ").append(clusterCustom).append('\n');
            }
        }
        if (this.metadata.projects().values().stream().anyMatch(p -> !p.customs().isEmpty())) {
            sb.append("metadata customs (project):\n");
            for (Map.Entry<Object, Diffable<ProjectMetadata>> entry : this.metadata.projects().entrySet()) {
                sb.append("   ").append("project[").append(entry.getKey()).append("]:\n");
                for (Map.Entry entry2 : ((ProjectMetadata)entry.getValue()).customs().entrySet()) {
                    String type2 = (String)entry2.getKey();
                    Metadata.ProjectCustom custom2 = (Metadata.ProjectCustom)entry2.getValue();
                    sb.append("   ").append("   ").append(type2).append(": ").append(custom2).append('\n');
                }
            }
        }
        sb.append(this.blocks());
        sb.append(this.nodes());
        if (!this.compatibilityVersions.isEmpty()) {
            sb.append("node versions:\n");
            for (Map.Entry<Object, Object> entry : this.compatibilityVersions.entrySet()) {
                sb.append("   ").append((String)entry.getKey()).append(": ").append(entry.getValue()).append("\n");
            }
        }
        sb.append("cluster features:\n");
        for (Map.Entry<Object, Object> entry : ClusterState.getNodeFeatures(this.clusterFeatures).entrySet()) {
            sb.append("   ").append((String)entry.getKey()).append(": ").append(new TreeSet((Collection)entry.getValue())).append("\n");
        }
        sb.append(this.routingTable);
        sb.append(this.getRoutingNodes());
        if (!this.customs.isEmpty()) {
            sb.append("customs:\n");
            for (Map.Entry<Object, Object> entry : this.customs.entrySet()) {
                type = (String)entry.getKey();
                Custom custom = (Custom)entry.getValue();
                sb.append("   ").append((String)type).append(": ").append(custom);
            }
        }
        return sb.toString();
    }

    public boolean supersedes(ClusterState other) {
        return this.nodes().getMasterNodeId() != null && this.nodes().getMasterNodeId().equals(other.nodes().getMasterNodeId()) && this.version() > other.version();
    }

    private static <T> Iterator<ToXContent> chunkedSection(boolean condition, ToXContent before, Iterator<T> items, Function<T, Iterator<ToXContent>> fn, ToXContent after) {
        Iterator<ToXContent> iterator;
        if (condition) {
            Iterator[] iteratorArray = new Iterator[3];
            iteratorArray[0] = Iterators.single(before);
            iteratorArray[1] = Iterators.flatMap(items, fn::apply);
            iteratorArray[2] = Iterators.single(after);
            iterator = Iterators.concat(iteratorArray);
        } else {
            iterator = Collections.emptyIterator();
        }
        return iterator;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params outerParams) {
        ProjectId singleProjectId;
        EnumSet<Metric> metrics = Metric.parseString(outerParams.param("metric", "_all"), true);
        boolean multiProject = outerParams.paramAsBoolean("multi-project", false);
        if (!multiProject) {
            if (this.metadata.projects().size() != 1) throw new Metadata.MultiProjectPendingException("There are multiple projects " + String.valueOf(this.metadata.projects().keySet()));
            singleProjectId = this.metadata.projects().keySet().iterator().next();
            return Iterators.concat(Iterators.single((builder, params) -> {
                builder.field("cluster_uuid", this.metadata().clusterUUID());
                if (metrics.contains((Object)Metric.VERSION)) {
                    builder.field("version", this.version);
                    builder.field("state_uuid", this.stateUUID);
                }
                if (metrics.contains((Object)Metric.MASTER_NODE)) {
                    builder.field("master_node", this.nodes().getMasterNodeId());
                }
                return builder;
            }), metrics.contains((Object)Metric.BLOCKS) ? this.blocksXContent(multiProject, singleProjectId) : Collections.emptyIterator(), ClusterState.chunkedSection(metrics.contains((Object)Metric.NODES), (builder, params) -> builder.startObject("nodes"), this.nodes.iterator(), Iterators::single, (builder, params) -> builder.endObject()), ClusterState.chunkedSection(metrics.contains((Object)Metric.NODES), (builder, params) -> builder.startArray("nodes_versions"), this.compatibilityVersions.entrySet().iterator(), e -> Iterators.single((builder, params) -> {
                builder.startObject().field("node_id", (String)e.getKey());
                ((CompatibilityVersions)e.getValue()).toXContent(builder, params);
                return builder.endObject();
            }), (builder, params) -> builder.endArray()), metrics.contains((Object)Metric.NODES) ? Iterators.concat(Iterators.single((b, p) -> b.field("nodes_features")), this.clusterFeatures.toXContentChunked(outerParams)) : Collections.emptyIterator(), metrics.contains((Object)Metric.METADATA) ? this.metadata.toXContentChunked(outerParams) : Collections.emptyIterator(), multiProject ? ClusterState.chunkedSection(metrics.contains((Object)Metric.ROUTING_TABLE), (builder, params) -> builder.startObject("routing_table").startArray("projects"), this.globalRoutingTable().routingTables().entrySet().iterator(), entry -> ClusterState.chunkedSection(true, (builder, params) -> builder.startObject().field("id", (ToXContent)entry.getKey()).startObject("indices"), ((RoutingTable)entry.getValue()).iterator(), ClusterState::indexRoutingTableXContent, (builder, params) -> builder.endObject().endObject()), (builder, params) -> builder.endArray().endObject()) : ClusterState.chunkedSection(metrics.contains((Object)Metric.ROUTING_TABLE), (builder, params) -> builder.startObject("routing_table").startObject("indices"), this.routingTable().iterator(), ClusterState::indexRoutingTableXContent, (builder, params) -> builder.endObject().endObject()), ClusterState.chunkedSection(metrics.contains((Object)Metric.ROUTING_NODES), (builder, params) -> builder.startObject("routing_nodes").startArray("unassigned"), this.getRoutingNodes().unassigned().iterator(), Iterators::single, (builder, params) -> builder.endArray()), ClusterState.chunkedSection(metrics.contains((Object)Metric.ROUTING_NODES), (builder, params) -> builder.startObject("nodes"), this.getRoutingNodes().iterator(), routingNode -> ChunkedToXContentHelper.array(routingNode.nodeId() == null ? "null" : routingNode.nodeId(), routingNode.iterator()), (builder, params) -> builder.endObject().endObject()), metrics.contains((Object)Metric.CUSTOMS) ? Iterators.flatMap(this.customs.entrySet().iterator(), e -> ChunkedToXContentHelper.object((String)e.getKey(), ((Custom)e.getValue()).toXContentChunked(outerParams))) : Collections.emptyIterator());
        } else {
            singleProjectId = null;
        }
        return Iterators.concat(Iterators.single((builder, params) -> {
            builder.field("cluster_uuid", this.metadata().clusterUUID());
            if (metrics.contains((Object)Metric.VERSION)) {
                builder.field("version", this.version);
                builder.field("state_uuid", this.stateUUID);
            }
            if (metrics.contains((Object)Metric.MASTER_NODE)) {
                builder.field("master_node", this.nodes().getMasterNodeId());
            }
            return builder;
        }), metrics.contains((Object)Metric.BLOCKS) ? this.blocksXContent(multiProject, singleProjectId) : Collections.emptyIterator(), ClusterState.chunkedSection(metrics.contains((Object)Metric.NODES), (builder, params) -> builder.startObject("nodes"), this.nodes.iterator(), Iterators::single, (builder, params) -> builder.endObject()), ClusterState.chunkedSection(metrics.contains((Object)Metric.NODES), (builder, params) -> builder.startArray("nodes_versions"), this.compatibilityVersions.entrySet().iterator(), e -> Iterators.single((builder, params) -> {
            builder.startObject().field("node_id", (String)e.getKey());
            ((CompatibilityVersions)e.getValue()).toXContent(builder, params);
            return builder.endObject();
        }), (builder, params) -> builder.endArray()), metrics.contains((Object)Metric.NODES) ? Iterators.concat(Iterators.single((b, p) -> b.field("nodes_features")), this.clusterFeatures.toXContentChunked(outerParams)) : Collections.emptyIterator(), metrics.contains((Object)Metric.METADATA) ? this.metadata.toXContentChunked(outerParams) : Collections.emptyIterator(), multiProject ? ClusterState.chunkedSection(metrics.contains((Object)Metric.ROUTING_TABLE), (builder, params) -> builder.startObject("routing_table").startArray("projects"), this.globalRoutingTable().routingTables().entrySet().iterator(), entry -> ClusterState.chunkedSection(true, (builder, params) -> builder.startObject().field("id", (ToXContent)entry.getKey()).startObject("indices"), ((RoutingTable)entry.getValue()).iterator(), ClusterState::indexRoutingTableXContent, (builder, params) -> builder.endObject().endObject()), (builder, params) -> builder.endArray().endObject()) : ClusterState.chunkedSection(metrics.contains((Object)Metric.ROUTING_TABLE), (builder, params) -> builder.startObject("routing_table").startObject("indices"), this.routingTable().iterator(), ClusterState::indexRoutingTableXContent, (builder, params) -> builder.endObject().endObject()), ClusterState.chunkedSection(metrics.contains((Object)Metric.ROUTING_NODES), (builder, params) -> builder.startObject("routing_nodes").startArray("unassigned"), this.getRoutingNodes().unassigned().iterator(), Iterators::single, (builder, params) -> builder.endArray()), ClusterState.chunkedSection(metrics.contains((Object)Metric.ROUTING_NODES), (builder, params) -> builder.startObject("nodes"), this.getRoutingNodes().iterator(), routingNode -> ChunkedToXContentHelper.array(routingNode.nodeId() == null ? "null" : routingNode.nodeId(), routingNode.iterator()), (builder, params) -> builder.endObject().endObject()), metrics.contains((Object)Metric.CUSTOMS) ? Iterators.flatMap(this.customs.entrySet().iterator(), e -> ChunkedToXContentHelper.object((String)e.getKey(), ((Custom)e.getValue()).toXContentChunked(outerParams))) : Collections.emptyIterator());
    }

    private Iterator<ToXContent> blocksXContent(boolean multiProject, ProjectId singleProjectId) {
        if (multiProject) {
            assert (singleProjectId == null) : "expect null project-id, but got " + String.valueOf(singleProjectId);
            return this.blocksXContentMultiProjects();
        }
        assert (singleProjectId != null);
        return this.blocksXContentSingleProject(singleProjectId);
    }

    private Iterator<ToXContent> blocksXContentMultiProjects() {
        ToXContent before = (builder, params) -> {
            builder.startObject("blocks");
            if (!this.blocks().global().isEmpty()) {
                builder.startObject("global");
                for (ClusterBlock block : this.blocks().global()) {
                    block.toXContent(builder, params);
                }
                builder.endObject();
            }
            if (!this.blocks().noProjectHasAProjectBlock()) {
                builder.startArray("projects");
            }
            return builder;
        };
        ToXContent after = (builder, params) -> {
            if (!this.blocks().noProjectHasAProjectBlock()) {
                builder.endArray();
            }
            return builder.endObject();
        };
        return ClusterState.chunkedSection(true, before, Iterators.map(this.metadata().projects().keySet().iterator(), projectId -> new Tuple<ProjectId, ClusterBlocks.ProjectBlocks>((ProjectId)projectId, this.blocks().projectBlocks((ProjectId)projectId))), ClusterState::projectBlocksXContent, after);
    }

    private Iterator<ToXContent> blocksXContentSingleProject(ProjectId singleProjectId) {
        ToXContent before = (builder, params) -> {
            builder.startObject("blocks");
            if (!this.blocks().global().isEmpty()) {
                builder.startObject("global");
                for (ClusterBlock block : this.blocks().global()) {
                    block.toXContent(builder, params);
                }
                builder.endObject();
            }
            if (!this.blocks().indices(singleProjectId).isEmpty()) {
                builder.startObject("indices");
            }
            return builder;
        };
        ToXContent after = (builder, params) -> {
            if (!this.blocks().indices(singleProjectId).isEmpty()) {
                builder.endObject();
            }
            return builder.endObject();
        };
        return ClusterState.chunkedSection(true, before, this.blocks().indices(singleProjectId).entrySet().iterator(), entry -> Iterators.single((builder, params) -> {
            builder.startObject((String)entry.getKey());
            for (ClusterBlock block : (Set)entry.getValue()) {
                block.toXContent(builder, params);
            }
            return builder.endObject();
        }), after);
    }

    private static Iterator<ToXContent> projectBlocksXContent(Tuple<ProjectId, ClusterBlocks.ProjectBlocks> entry) {
        ProjectId projectId = entry.v1();
        ClusterBlocks.ProjectBlocks projectBlocks = entry.v2();
        if (projectBlocks.isEmpty()) {
            return Collections.emptyIterator();
        }
        return Iterators.concat(Iterators.single((builder, params) -> builder.startObject().field("id", projectId)), projectBlocks.projectGlobals().isEmpty() ? Collections.emptyIterator() : Iterators.single((builder, params) -> {
            builder.startObject("project_globals");
            for (ClusterBlock block : projectBlocks.projectGlobals()) {
                block.toXContent(builder, params);
            }
            return builder.endObject();
        }), projectBlocks.indices().isEmpty() ? Collections.emptyIterator() : Iterators.concat(Iterators.single((builder, params) -> builder.startObject("indices")), Iterators.flatMap(projectBlocks.indices().entrySet().iterator(), indexBlocks -> Iterators.single((builder, params) -> {
            builder.startObject((String)indexBlocks.getKey());
            for (ClusterBlock block : (Set)indexBlocks.getValue()) {
                block.toXContent(builder, params);
            }
            return builder.endObject();
        })), Iterators.single((builder, params) -> builder.endObject())), Iterators.single((builder, params) -> builder.endObject()));
    }

    private static Iterator<ToXContent> indexRoutingTableXContent(IndexRoutingTable indexRoutingTable) {
        Iterator<Iterator> input = Iterators.forRange(0, indexRoutingTable.size(), shardId -> {
            IndexShardRoutingTable indexShardRoutingTable = indexRoutingTable.shard(shardId);
            return Iterators.concat(Iterators.single((builder, params) -> builder.startArray(Integer.toString(indexShardRoutingTable.shardId().id()))), Iterators.forRange(0, indexShardRoutingTable.size(), copy -> (builder, params) -> indexShardRoutingTable.shard(copy).toXContent(builder, params)), Iterators.single((builder, params) -> builder.endArray()));
        });
        return Iterators.concat(Iterators.single((builder, params) -> builder.startObject(indexRoutingTable.getIndex().getName()).startObject("shards")), Iterators.flatMap(input, Function.identity()), Iterators.single((builder, params) -> builder.endObject().endObject()));
    }

    public static Builder builder(ClusterName clusterName) {
        return new Builder(clusterName);
    }

    public static Builder builder(ClusterState state) {
        return new Builder(state);
    }

    public ClusterState copyAndUpdate(Consumer<Builder> updater) {
        Builder builder = ClusterState.builder(this);
        updater.accept(builder);
        return builder.build();
    }

    public ClusterState copyAndUpdateMetadata(Consumer<Metadata.Builder> updater) {
        return this.copyAndUpdate(builder -> builder.metadata(this.metadata().copyAndUpdate(updater)));
    }

    public ClusterState copyAndUpdateProject(ProjectId projectId, Consumer<ProjectMetadata.Builder> updater) {
        return this.copyAndUpdate(builder -> builder.metadata(this.metadata.copyAndUpdateProject(projectId, updater)));
    }

    @SuppressForbidden(reason="directly reading ClusterState#clusterFeatures")
    private static Map<String, Set<String>> getNodeFeatures(ClusterFeatures features) {
        return features.nodeFeatures();
    }

    @Override
    public Diff<ClusterState> diff(ClusterState previousState) {
        return new ClusterStateDiff(previousState, this);
    }

    public static Diff<ClusterState> readDiffFrom(StreamInput in, DiscoveryNode localNode) throws IOException {
        return new ClusterStateDiff(in, localNode);
    }

    public static ClusterState readFrom(StreamInput in, DiscoveryNode localNode) throws IOException {
        ClusterName clusterName = new ClusterName(in);
        Builder builder = new Builder(clusterName);
        builder.version = in.readLong();
        builder.uuid = in.readString();
        builder.metadata = Metadata.readFrom(in);
        if (in.getTransportVersion().supports(MULTI_PROJECT)) {
            builder.routingTable = GlobalRoutingTable.readFrom(in);
        } else {
            RoutingTable rt = RoutingTable.readFrom(in);
            builder.routingTable = new GlobalRoutingTable(ImmutableOpenMap.builder(Map.of(Metadata.DEFAULT_PROJECT_ID, rt)).build());
        }
        builder.nodes = DiscoveryNodes.readFrom(in, localNode);
        builder.nodeIdsToCompatibilityVersions(in.readMap(CompatibilityVersions::readVersion));
        builder.nodeFeatures(ClusterFeatures.readFrom(in));
        builder.blocks = ClusterBlocks.readFrom(in);
        int customSize = in.readVInt();
        for (int i = 0; i < customSize; ++i) {
            Custom customIndexMetadata = in.readNamedWriteable(Custom.class);
            builder.putCustom(customIndexMetadata.getWriteableName(), customIndexMetadata);
        }
        return builder.build();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.clusterName.writeTo(out);
        out.writeLong(this.version);
        out.writeString(this.stateUUID);
        this.metadata.writeTo(out);
        if (out.getTransportVersion().supports(MULTI_PROJECT)) {
            this.routingTable.writeTo(out);
        } else {
            this.routingTable.getRoutingTable().writeTo(out);
        }
        this.nodes.writeTo(out);
        out.writeMap(this.compatibilityVersions, StreamOutput::writeWriteable);
        this.clusterFeatures.writeTo(out);
        this.blocks.writeTo(out);
        VersionedNamedWriteable.writeVersionedWritables(out, this.customs);
    }

    public static interface Custom
    extends NamedDiffable<Custom>,
    ChunkedToXContent {
        default public boolean isPrivate() {
            return false;
        }

        @Override
        public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params var1);
    }

    public static enum Metric {
        VERSION("version"),
        MASTER_NODE("master_node"),
        BLOCKS("blocks"),
        NODES("nodes"),
        METADATA("metadata"),
        ROUTING_TABLE("routing_table"),
        ROUTING_NODES("routing_nodes"),
        CUSTOMS("customs");

        private static final Map<String, Metric> valueToEnum;
        private final String value;

        private Metric(String value) {
            this.value = value;
        }

        public static EnumSet<Metric> parseString(String param, boolean ignoreUnknown) {
            String[] metrics = Strings.splitStringByCommaToArray(param);
            EnumSet<Metric> result = EnumSet.noneOf(Metric.class);
            for (String metric : metrics) {
                if ("_all".equals(metric)) {
                    result = EnumSet.allOf(Metric.class);
                    break;
                }
                Metric m = valueToEnum.get(metric);
                if (m == null) {
                    if (ignoreUnknown) continue;
                    throw new IllegalArgumentException("Unknown metric [" + metric + "]");
                }
                result.add(m);
            }
            return result;
        }

        public String toString() {
            return this.value;
        }

        static {
            valueToEnum = new HashMap<String, Metric>();
            for (Metric metric : Metric.values()) {
                valueToEnum.put(metric.value, metric);
            }
        }
    }

    public static class Builder {
        private ClusterState previous;
        private final ClusterName clusterName;
        private long version = 0L;
        private String uuid = "_na_";
        private Metadata metadata = Metadata.EMPTY_METADATA;
        private GlobalRoutingTable routingTable = null;
        private DiscoveryNodes nodes = DiscoveryNodes.EMPTY_NODES;
        private final Map<String, CompatibilityVersions> compatibilityVersions;
        private final Map<String, Set<String>> nodeFeatures;
        private ClusterBlocks blocks = ClusterBlocks.EMPTY_CLUSTER_BLOCK;
        private final ImmutableOpenMap.Builder<String, Custom> customs;
        private boolean fromDiff;

        public Builder(ClusterState state) {
            this.previous = state;
            this.clusterName = state.clusterName;
            this.version = state.version();
            this.uuid = state.stateUUID();
            this.nodes = state.nodes();
            this.compatibilityVersions = new HashMap<String, CompatibilityVersions>(state.compatibilityVersions);
            this.nodeFeatures = new HashMap<String, Set<String>>(ClusterState.getNodeFeatures(state.clusterFeatures()));
            this.routingTable = state.routingTable;
            this.metadata = state.metadata();
            this.blocks = state.blocks();
            this.customs = ImmutableOpenMap.builder(state.customs());
            this.fromDiff = false;
        }

        public Builder(ClusterName clusterName) {
            this.compatibilityVersions = new HashMap<String, CompatibilityVersions>();
            this.nodeFeatures = new HashMap<String, Set<String>>();
            this.customs = ImmutableOpenMap.builder();
            this.clusterName = clusterName;
        }

        public Builder putProjectMetadata(ProjectMetadata.Builder projectMetadata) {
            this.metadata = Metadata.builder(this.metadata).put(projectMetadata).build();
            return this;
        }

        public Builder putProjectMetadata(ProjectMetadata projectMetadata) {
            return this.putProjectMetadata(ProjectMetadata.builder(projectMetadata));
        }

        public Builder nodes(DiscoveryNodes.Builder nodesBuilder) {
            return this.nodes(nodesBuilder.build());
        }

        public Builder nodes(DiscoveryNodes nodes) {
            this.nodes = nodes;
            return this;
        }

        public DiscoveryNodes nodes() {
            return this.nodes;
        }

        public Builder putCompatibilityVersions(String nodeId, TransportVersion transportVersion, Map<String, SystemIndexDescriptor.MappingsVersion> systemIndexMappingsVersions) {
            return this.putCompatibilityVersions(nodeId, new CompatibilityVersions(Objects.requireNonNull(transportVersion, nodeId), systemIndexMappingsVersions));
        }

        public Builder putCompatibilityVersions(String nodeId, CompatibilityVersions versions) {
            this.compatibilityVersions.put(nodeId, versions);
            return this;
        }

        public Builder nodeIdsToCompatibilityVersions(Map<String, CompatibilityVersions> versions) {
            versions.forEach((key, value) -> Objects.requireNonNull(value, key));
            this.compatibilityVersions.keySet().retainAll(versions.keySet());
            this.compatibilityVersions.putAll(versions);
            return this;
        }

        public Map<String, CompatibilityVersions> compatibilityVersions() {
            return Collections.unmodifiableMap(this.compatibilityVersions);
        }

        public Builder nodeFeatures(ClusterFeatures features) {
            this.nodeFeatures.clear();
            this.nodeFeatures.putAll(ClusterState.getNodeFeatures(features));
            return this;
        }

        public Builder nodeFeatures(Map<String, Set<String>> nodeFeatures) {
            this.nodeFeatures.clear();
            this.nodeFeatures.putAll(nodeFeatures);
            return this;
        }

        public Map<String, Set<String>> nodeFeatures() {
            return Collections.unmodifiableMap(this.nodeFeatures);
        }

        public Builder putNodeFeatures(String node, Set<String> features) {
            this.nodeFeatures.put(node, features);
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder routingTable(RoutingTable.Builder routingTableBuilder) {
            return this.routingTable(routingTableBuilder.build());
        }

        @Deprecated(forRemoval=true)
        public Builder routingTable(RoutingTable routingTable) {
            return this.routingTable(Metadata.DEFAULT_PROJECT_ID, routingTable);
        }

        @Deprecated(forRemoval=true)
        public Builder routingTable(ProjectId projectId, RoutingTable routingTable) {
            Objects.requireNonNull(projectId, "project-id may not be null");
            Objects.requireNonNull(routingTable, "routing-table may not be null");
            return this.routingTable(new GlobalRoutingTable(ImmutableOpenMap.builder(projectId, routingTable).build()));
        }

        public Builder routingTable(GlobalRoutingTable routingTable) {
            this.routingTable = routingTable;
            return this;
        }

        public Builder putRoutingTable(ProjectId projectId, RoutingTable routingTable) {
            GlobalRoutingTable.Builder globalRoutingTableBuilder = this.routingTable == null ? GlobalRoutingTable.builder() : GlobalRoutingTable.builder(this.routingTable);
            return this.routingTable(globalRoutingTableBuilder.put(projectId, routingTable).build());
        }

        public Builder metadata(Metadata.Builder metadataBuilder) {
            return this.metadata(metadataBuilder.build());
        }

        public Builder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder blocks(ClusterBlocks.Builder blocksBuilder) {
            return this.blocks(blocksBuilder.build());
        }

        public Builder blocks(ClusterBlocks blocks) {
            this.blocks = blocks;
            return this;
        }

        public Builder version(long version) {
            this.version = version;
            return this;
        }

        public Builder incrementVersion() {
            ++this.version;
            this.uuid = ClusterState.UNKNOWN_UUID;
            return this;
        }

        public Builder stateUUID(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder putCustom(String type, Custom custom) {
            this.customs.put(type, Objects.requireNonNull(custom, type));
            return this;
        }

        public Builder removeCustom(String type) {
            this.customs.remove(type);
            return this;
        }

        public Builder customs(Map<String, Custom> customs) {
            customs.forEach((key, value) -> Objects.requireNonNull(value, key));
            this.customs.putAllFromMap(customs);
            return this;
        }

        private Builder fromDiff(ClusterState previous) {
            this.fromDiff = true;
            this.previous = previous;
            return this;
        }

        public ClusterState build() {
            if (ClusterState.UNKNOWN_UUID.equals(this.uuid)) {
                this.uuid = UUIDs.randomBase64UUID();
            }
            RoutingNodes routingNodes = this.previous != null && this.routingTable.hasSameIndexRouting(this.previous.routingTable) && this.nodes == this.previous.nodes ? this.previous.routingNodes : null;
            if (this.nodes != null) {
                for (DiscoveryNode node : this.nodes) {
                    this.nodeFeatures.putIfAbsent(node.getId(), Set.of());
                }
            }
            if (this.metadata == null) {
                if (this.routingTable == null) {
                    this.routingTable = GlobalRoutingTable.EMPTY_ROUTING_TABLE;
                }
            } else if (this.routingTable == null) {
                Map<ProjectId, RoutingTable> projectRouting = Maps.transformValues(this.metadata.projects(), ignore -> RoutingTable.EMPTY_ROUTING_TABLE);
                this.routingTable = new GlobalRoutingTable(ImmutableOpenMap.builder(projectRouting).build());
            } else {
                this.routingTable = this.routingTable.initializeProjects(this.metadata.projects().keySet());
            }
            return new ClusterState(this.clusterName, this.version, this.uuid, this.metadata, this.routingTable, this.nodes, this.compatibilityVersions, this.previous != null && ClusterState.getNodeFeatures(this.previous.clusterFeatures).equals(this.nodeFeatures) ? this.previous.clusterFeatures : new ClusterFeatures(this.nodeFeatures), this.metadata != null ? this.blocks.initializeProjects(this.metadata.projects().keySet()) : this.blocks, this.customs.build(), this.fromDiff, routingNodes);
        }

        public static byte[] toBytes(ClusterState state) throws IOException {
            BytesStreamOutput os = new BytesStreamOutput();
            state.writeTo(os);
            return BytesReference.toBytes(os.bytes());
        }

        public static ClusterState fromBytes(byte[] data, DiscoveryNode localNode, NamedWriteableRegistry registry) throws IOException {
            NamedWriteableAwareStreamInput in = new NamedWriteableAwareStreamInput(StreamInput.wrap(data), registry);
            return ClusterState.readFrom(in, localNode);
        }
    }

    private static class ClusterStateDiff
    implements Diff<ClusterState> {
        private final long toVersion;
        private final String fromUuid;
        private final String toUuid;
        private final ClusterName clusterName;
        private final Diff<GlobalRoutingTable> routingTable;
        private final Diff<DiscoveryNodes> nodes;
        private final Diff<Map<String, CompatibilityVersions>> versions;
        private final Diff<ClusterFeatures> features;
        private final Diff<Metadata> metadata;
        private final Diff<ClusterBlocks> blocks;
        private final Diff<Map<String, Custom>> customs;

        ClusterStateDiff(ClusterState before, ClusterState after) {
            this.fromUuid = before.stateUUID;
            this.toUuid = after.stateUUID;
            this.toVersion = after.version;
            this.clusterName = after.clusterName;
            this.routingTable = after.routingTable.diff(before.routingTable);
            this.nodes = after.nodes.diff(before.nodes);
            this.versions = DiffableUtils.diff(before.compatibilityVersions, after.compatibilityVersions, DiffableUtils.getStringKeySerializer(), COMPATIBILITY_VERSIONS_VALUE_SERIALIZER);
            this.features = after.clusterFeatures.diff(before.clusterFeatures);
            this.metadata = after.metadata.diff(before.metadata);
            this.blocks = after.blocks.diff(before.blocks);
            this.customs = DiffableUtils.diff(before.customs, after.customs, DiffableUtils.getStringKeySerializer(), CUSTOM_VALUE_SERIALIZER);
        }

        ClusterStateDiff(StreamInput in, DiscoveryNode localNode) throws IOException {
            this.clusterName = new ClusterName(in);
            this.fromUuid = in.readString();
            this.toUuid = in.readString();
            this.toVersion = in.readLong();
            this.routingTable = GlobalRoutingTable.readDiffFrom(in);
            this.nodes = DiscoveryNodes.readDiffFrom(in, localNode);
            boolean versionPresent = in.readBoolean();
            if (!versionPresent) {
                throw new IOException("ClusterStateDiff stream must have versions");
            }
            this.versions = DiffableUtils.readJdkMapDiff(in, DiffableUtils.getStringKeySerializer(), COMPATIBILITY_VERSIONS_VALUE_SERIALIZER);
            this.features = ClusterFeatures.readDiffFrom(in);
            this.metadata = Metadata.readDiffFrom(in);
            this.blocks = ClusterBlocks.readDiffFrom(in);
            this.customs = DiffableUtils.readJdkMapDiff(in, DiffableUtils.getStringKeySerializer(), CUSTOM_VALUE_SERIALIZER);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.clusterName.writeTo(out);
            out.writeString(this.fromUuid);
            out.writeString(this.toUuid);
            out.writeLong(this.toVersion);
            this.routingTable.writeTo(out);
            this.nodes.writeTo(out);
            out.writeBoolean(true);
            this.versions.writeTo(out);
            this.features.writeTo(out);
            this.metadata.writeTo(out);
            this.blocks.writeTo(out);
            this.customs.writeTo(out);
        }

        @Override
        public ClusterState apply(ClusterState state) {
            Builder builder = new Builder(this.clusterName);
            if (this.toUuid.equals(state.stateUUID)) {
                return state;
            }
            if (!this.fromUuid.equals(state.stateUUID)) {
                throw new IncompatibleClusterStateVersionException(state.version, state.stateUUID, this.toVersion, this.fromUuid);
            }
            builder.stateUUID(this.toUuid);
            builder.version(this.toVersion);
            builder.routingTable(this.routingTable.apply(state.routingTable));
            builder.nodes(this.nodes.apply(state.nodes));
            builder.nodeIdsToCompatibilityVersions(this.versions.apply(state.compatibilityVersions));
            builder.nodeFeatures(this.features.apply(state.clusterFeatures));
            builder.metadata(this.metadata.apply(state.metadata));
            builder.blocks(this.blocks.apply(state.blocks));
            builder.customs(this.customs.apply(state.customs));
            builder.fromDiff(state);
            return builder.build();
        }
    }
}

