/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.termvectors;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.single.shard.SingleShardRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class EnsureDocsSearchableAction {
    private static final String ACTION_NAME = "internal:index/data/read/eds";
    public static final ActionType<ActionResponse.Empty> TYPE = new ActionType("internal:index/data/read/eds");
    public static final String ENSURE_DOCS_SEARCHABLE_ORIGIN = "ensure_docs_searchable";

    public static final class EnsureDocsSearchableRequest
    extends SingleShardRequest<EnsureDocsSearchableRequest> {
        private int shardId;
        private String[] docIds;

        public EnsureDocsSearchableRequest() {
        }

        public EnsureDocsSearchableRequest(StreamInput in) throws IOException {
            super(in);
            this.docIds = in.readStringArray();
        }

        @Override
        public ActionRequestValidationException validate() {
            return super.validateNonNullIndex();
        }

        public EnsureDocsSearchableRequest(String index, int shardId, String[] docIds) {
            super(index);
            this.shardId = shardId;
            this.docIds = docIds;
        }

        public int shardId() {
            return this.shardId;
        }

        public String[] docIds() {
            return this.docIds;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringArray(this.docIds);
        }
    }
}

