/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.synonyms;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.indices.analyze.ReloadAnalyzersResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.synonyms.SynonymsManagementAPIService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class SynonymUpdateResponse
extends ActionResponse
implements ToXContentObject {
    public static final String RESULT_FIELD = "result";
    public static final String RELOAD_ANALYZERS_DETAILS_FIELD = "reload_analyzers_details";
    static final ReloadAnalyzersResponse EMPTY_RELOAD_ANALYZER_RESPONSE = new ReloadAnalyzersResponse(0, 0, 0, List.of(), Map.of());
    private static final TransportVersion SYNONYMS_REFRESH_PARAM = TransportVersion.fromName("synonyms_refresh_param");
    private final SynonymsManagementAPIService.UpdateSynonymsResultStatus updateStatus;
    private final ReloadAnalyzersResponse reloadAnalyzersResponse;

    public SynonymUpdateResponse(StreamInput in) throws IOException {
        this.updateStatus = in.readEnum(SynonymsManagementAPIService.UpdateSynonymsResultStatus.class);
        this.reloadAnalyzersResponse = in.getTransportVersion().supports(SYNONYMS_REFRESH_PARAM) ? in.readOptionalWriteable(ReloadAnalyzersResponse::new) : new ReloadAnalyzersResponse(in);
    }

    public SynonymUpdateResponse(SynonymsManagementAPIService.SynonymsReloadResult synonymsReloadResult) {
        SynonymsManagementAPIService.UpdateSynonymsResultStatus updateStatus = synonymsReloadResult.synonymsOperationResult();
        Objects.requireNonNull(updateStatus, "Update status must not be null");
        ReloadAnalyzersResponse reloadResponse = synonymsReloadResult.reloadAnalyzersResponse();
        this.updateStatus = updateStatus;
        this.reloadAnalyzersResponse = reloadResponse;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(RESULT_FIELD, this.updateStatus.name().toLowerCase(Locale.ENGLISH));
        if (this.reloadAnalyzersResponse != null) {
            builder.field(RELOAD_ANALYZERS_DETAILS_FIELD);
            this.reloadAnalyzersResponse.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum(this.updateStatus);
        if (out.getTransportVersion().supports(SYNONYMS_REFRESH_PARAM)) {
            out.writeOptionalWriteable(this.reloadAnalyzersResponse);
        } else if (this.reloadAnalyzersResponse == null) {
            EMPTY_RELOAD_ANALYZER_RESPONSE.writeTo(out);
        } else {
            this.reloadAnalyzersResponse.writeTo(out);
        }
    }

    public RestStatus status() {
        return switch (this.updateStatus) {
            case SynonymsManagementAPIService.UpdateSynonymsResultStatus.CREATED -> RestStatus.CREATED;
            default -> RestStatus.OK;
        };
    }

    SynonymsManagementAPIService.UpdateSynonymsResultStatus updateStatus() {
        return this.updateStatus;
    }

    ReloadAnalyzersResponse reloadAnalyzersResponse() {
        return this.reloadAnalyzersResponse;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SynonymUpdateResponse response = (SynonymUpdateResponse)o;
        return this.updateStatus == response.updateStatus && Objects.equals(this.reloadAnalyzersResponse, response.reloadAnalyzersResponse);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.updateStatus, this.reloadAnalyzersResponse});
    }
}

