/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.synonyms;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.synonyms.SynonymUpdateResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.synonyms.SynonymRule;
import org.elasticsearch.synonyms.SynonymsManagementAPIService;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public class PutSynonymRuleAction
extends ActionType<SynonymUpdateResponse> {
    public static final PutSynonymRuleAction INSTANCE = new PutSynonymRuleAction();
    public static final String NAME = "cluster:admin/synonym_rules/put";

    public PutSynonymRuleAction() {
        super(NAME);
    }

    public static class Request
    extends LegacyActionRequest {
        private static final TransportVersion SYNONYMS_REFRESH_PARAM = TransportVersion.fromName("synonyms_refresh_param");
        private final String synonymsSetId;
        private final SynonymRule synonymRule;
        private final boolean refresh;
        public static final ParseField SYNONYMS_FIELD = new ParseField(SynonymsManagementAPIService.SYNONYMS_FIELD, new String[0]);
        private static final ConstructingObjectParser<SynonymRule, String> PARSER = new ConstructingObjectParser<SynonymRule, String>("synonyms", false, (params, synonymRuleId) -> new SynonymRule((String)synonymRuleId, (String)params[0]));

        public Request(StreamInput in) throws IOException {
            super(in);
            this.synonymsSetId = in.readString();
            this.synonymRule = new SynonymRule(in);
            this.refresh = in.getTransportVersion().supports(SYNONYMS_REFRESH_PARAM) ? in.readBoolean() : true;
        }

        public Request(String synonymsSetId, String synonymRuleId, boolean refresh, BytesReference content, XContentType contentType) throws IOException {
            this.synonymsSetId = synonymsSetId;
            try (XContentParser parser = XContentHelper.createParser(XContentParserConfiguration.EMPTY, content, contentType);){
                this.synonymRule = PARSER.apply(parser, synonymRuleId);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to parse: " + content.utf8ToString(), e);
            }
            this.refresh = refresh;
        }

        Request(String synonymsSetId, SynonymRule synonymRule, boolean refresh) {
            this.synonymsSetId = synonymsSetId;
            this.synonymRule = synonymRule;
            this.refresh = refresh;
        }

        @Override
        public ActionRequestValidationException validate() {
            String error;
            ActionRequestValidationException validationException = null;
            if (Strings.isNullOrEmpty(this.synonymsSetId)) {
                validationException = ValidateActions.addValidationError("synonyms set must be specified", validationException);
            }
            if (Strings.isNullOrEmpty(this.synonymRule.id())) {
                validationException = ValidateActions.addValidationError("synonym rule id must be specified", validationException);
            }
            if ((error = this.synonymRule.validate()) != null) {
                validationException = ValidateActions.addValidationError(error, validationException);
            }
            return validationException;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.synonymsSetId);
            this.synonymRule.writeTo(out);
            if (out.getTransportVersion().supports(SYNONYMS_REFRESH_PARAM)) {
                out.writeBoolean(this.refresh);
            }
        }

        public String synonymsSetId() {
            return this.synonymsSetId;
        }

        public SynonymRule synonymRule() {
            return this.synonymRule;
        }

        public boolean refresh() {
            return this.refresh;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Objects.equals(this.refresh, request.refresh) && Objects.equals(this.synonymsSetId, request.synonymsSetId) && Objects.equals(this.synonymRule, request.synonymRule);
        }

        public int hashCode() {
            return Objects.hash(this.synonymsSetId, this.synonymRule, this.refresh);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), SYNONYMS_FIELD);
        }
    }
}

