/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.replication;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.elasticsearch.action.support.replication.ReplicationRequest;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.routing.SplitShardCountSummary;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.shard.ShardId;

public final class ReplicationRequestSplitHelper {
    private ReplicationRequestSplitHelper() {
    }

    public static <T extends ReplicationRequest<T>> Map<ShardId, T> splitRequest(T request, ProjectMetadata project, BiFunction<ShardId, SplitShardCountSummary, T> targetRequestFactory) {
        ShardId sourceShard = request.shardId();
        IndexMetadata indexMetadata = project.getIndexSafe(sourceShard.getIndex());
        SplitShardCountSummary shardCountSummary = SplitShardCountSummary.forIndexing(indexMetadata, sourceShard.getId());
        HashMap<ShardId, ReplicationRequest> requestsByShard = new HashMap<ShardId, ReplicationRequest>();
        requestsByShard.put(sourceShard, request);
        int targetShardId = indexMetadata.getReshardingMetadata().getSplit().targetShard(sourceShard.id());
        ShardId targetShard = new ShardId(sourceShard.getIndex(), targetShardId);
        requestsByShard.put(targetShard, (ReplicationRequest)targetRequestFactory.apply(targetShard, shardCountSummary));
        return requestsByShard;
    }

    public static <T extends ReplicationRequest<T>> Tuple<ReplicationResponse, Exception> combineSplitResponses(T originalRequest, Map<ShardId, T> splitRequests, Map<ShardId, Tuple<ReplicationResponse, Exception>> responses) {
        int failed = 0;
        int successful = 0;
        int total = 0;
        ArrayList failures = new ArrayList();
        for (Map.Entry<ShardId, Tuple<ReplicationResponse, Exception>> entry : responses.entrySet()) {
            Tuple<ReplicationResponse, Exception> value = entry.getValue();
            Exception exception = value.v2();
            if (exception != null) {
                return new Tuple<Object, Exception>(null, exception);
            }
            ReplicationResponse response = value.v1();
            failed += response.getShardInfo().getFailed();
            successful += response.getShardInfo().getSuccessful();
            total += response.getShardInfo().getTotal();
            Collections.addAll(failures, response.getShardInfo().getFailures());
        }
        ReplicationResponse.ShardInfo.Failure[] failureArray = failures.toArray(new ReplicationResponse.ShardInfo.Failure[0]);
        assert (failureArray.length == failed);
        ReplicationResponse.ShardInfo shardInfo = ReplicationResponse.ShardInfo.of(total, successful, failureArray);
        ReplicationResponse response = new ReplicationResponse();
        response.setShardInfo(shardInfo);
        return new Tuple<ReplicationResponse, Object>(response, null);
    }
}

