/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.ResolvedIndexExpression;
import org.elasticsearch.action.ResolvedIndexExpressions;
import org.elasticsearch.action.admin.indices.resolve.ResolveIndexAction;
import org.elasticsearch.action.search.AbstractSearchAsyncAction;
import org.elasticsearch.action.search.ArraySearchPhaseResults;
import org.elasticsearch.action.search.CanMatchPreFilterSearchPhase;
import org.elasticsearch.action.search.OpenPointInTimeRequest;
import org.elasticsearch.action.search.OpenPointInTimeResponse;
import org.elasticsearch.action.search.SearchActionListener;
import org.elasticsearch.action.search.SearchContextId;
import org.elasticsearch.action.search.SearchPhase;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchResponseSections;
import org.elasticsearch.action.search.SearchShardIterator;
import org.elasticsearch.action.search.SearchTask;
import org.elasticsearch.action.search.SearchTransportService;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.search.TransportSearchAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.rest.action.search.SearchResponseMetrics;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.crossproject.CrossProjectIndexResolutionValidator;
import org.elasticsearch.search.crossproject.CrossProjectModeDecider;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.search.internal.ShardSearchContextId;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.AbstractTransportRequest;
import org.elasticsearch.transport.RemoteClusterAware;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportActionProxy;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public class TransportOpenPointInTimeAction
extends HandledTransportAction<OpenPointInTimeRequest, OpenPointInTimeResponse> {
    private static final Logger logger = LogManager.getLogger(TransportOpenPointInTimeAction.class);
    public static final String OPEN_SHARD_READER_CONTEXT_NAME = "indices:data/read/open_reader_context";
    public static final ActionType<OpenPointInTimeResponse> TYPE = new ActionType("indices:data/read/open_point_in_time");
    private final TransportSearchAction transportSearchAction;
    private final SearchTransportService searchTransportService;
    private final NamedWriteableRegistry namedWriteableRegistry;
    private final TransportService transportService;
    private final SearchService searchService;
    private final ClusterService clusterService;
    private final SearchResponseMetrics searchResponseMetrics;
    private final CrossProjectModeDecider crossProjectModeDecider;
    private final TimeValue forceConnectTimeoutSecs;

    @Inject
    public TransportOpenPointInTimeAction(TransportService transportService, SearchService searchService, ActionFilters actionFilters, TransportSearchAction transportSearchAction, SearchTransportService searchTransportService, NamedWriteableRegistry namedWriteableRegistry, ClusterService clusterService, SearchResponseMetrics searchResponseMetrics) {
        super(TYPE.name(), transportService, actionFilters, OpenPointInTimeRequest::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.transportService = transportService;
        this.transportSearchAction = transportSearchAction;
        this.searchService = searchService;
        this.searchTransportService = searchTransportService;
        this.namedWriteableRegistry = namedWriteableRegistry;
        this.clusterService = clusterService;
        this.searchResponseMetrics = searchResponseMetrics;
        this.crossProjectModeDecider = new CrossProjectModeDecider(clusterService.getSettings());
        this.forceConnectTimeoutSecs = clusterService.getSettings().getAsTime("search.ccs.force_connect_timeout", TimeValue.timeValueSeconds(3L));
        transportService.registerRequestHandler(OPEN_SHARD_READER_CONTEXT_NAME, EsExecutors.DIRECT_EXECUTOR_SERVICE, ShardOpenReaderRequest::new, new ShardOpenReaderRequestHandler());
        TransportActionProxy.registerProxyAction(transportService, OPEN_SHARD_READER_CONTEXT_NAME, false, ShardOpenReaderResponse::new, namedWriteableRegistry);
    }

    @Override
    protected void doExecute(Task task, OpenPointInTimeRequest request, ActionListener<OpenPointInTimeResponse> listener) {
        boolean resolveCrossProject = this.crossProjectModeDecider.resolvesCrossProject(request);
        if (resolveCrossProject) {
            this.executeOpenPitCrossProject((SearchTask)task, request, listener);
        } else {
            this.executeOpenPit((SearchTask)task, request, listener);
        }
    }

    private void executeOpenPitCrossProject(SearchTask task, OpenPointInTimeRequest request, ActionListener<OpenPointInTimeResponse> listener) {
        String[] indices = request.indices();
        IndicesOptions originalIndicesOptions = request.indicesOptions();
        if (originalIndicesOptions.ignoreUnavailable() && originalIndicesOptions.allowNoIndices()) {
            this.executeOpenPit(task, request, listener);
            return;
        }
        ResolvedIndexExpressions localResolvedIndexExpressions = request.getResolvedIndexExpressions();
        RemoteClusterService remoteClusterService = this.searchTransportService.getRemoteClusterService();
        Map<String, OriginalIndices> indicesPerCluster = remoteClusterService.groupIndices(CrossProjectIndexResolutionValidator.indicesOptionsForCrossProjectFanout(originalIndicesOptions), indices);
        indicesPerCluster.remove("");
        if (indicesPerCluster.isEmpty()) {
            ElasticsearchException ex = CrossProjectIndexResolutionValidator.validate(originalIndicesOptions, request.getProjectRouting(), localResolvedIndexExpressions, Map.of());
            if (ex != null) {
                listener.onFailure(ex);
                return;
            }
            this.executeOpenPit(task, request, listener);
            return;
        }
        int linkedProjectsToQuery = indicesPerCluster.size();
        ActionListener responsesListener = listener.delegateFailureAndWrap((l, responses) -> {
            Map<String, ResolvedIndexExpressions> resolvedRemoteExpressions = responses.stream().filter(e -> ((ResolveIndexAction.Response)e.getValue()).getResolvedIndexExpressions() != null).collect(Collectors.toMap(Map.Entry::getKey, e -> ((ResolveIndexAction.Response)e.getValue()).getResolvedIndexExpressions()));
            ElasticsearchException ex = CrossProjectIndexResolutionValidator.validate(originalIndicesOptions, request.getProjectRouting(), localResolvedIndexExpressions, resolvedRemoteExpressions);
            if (ex != null) {
                listener.onFailure(ex);
                return;
            }
            HashSet<String> collectedIndices = new HashSet<String>(indices.length);
            for (Map.Entry<String, ResolvedIndexExpressions> resolvedRemoteExpressionEntry : resolvedRemoteExpressions.entrySet()) {
                String remoteAlias = resolvedRemoteExpressionEntry.getKey();
                for (ResolvedIndexExpression expression : resolvedRemoteExpressionEntry.getValue().expressions()) {
                    ResolvedIndexExpression.LocalExpressions oneRemoteExpression = expression.localExpressions();
                    if (oneRemoteExpression.indices().isEmpty() || oneRemoteExpression.localIndexResolutionResult() != ResolvedIndexExpression.LocalIndexResolutionResult.SUCCESS) continue;
                    collectedIndices.addAll(oneRemoteExpression.indices().stream().map(i -> RemoteClusterAware.buildRemoteIndexName(remoteAlias, i)).collect(Collectors.toSet()));
                }
            }
            if (localResolvedIndexExpressions != null) {
                collectedIndices.addAll(localResolvedIndexExpressions.getLocalIndicesList());
            }
            request.indices((String[])collectedIndices.toArray(String[]::new));
            this.executeOpenPit(task, request, listener);
        });
        GroupedActionListener groupedListener = new GroupedActionListener(linkedProjectsToQuery, responsesListener);
        for (Map.Entry<String, OriginalIndices> remoteClusterIndices : indicesPerCluster.entrySet()) {
            String clusterAlias = remoteClusterIndices.getKey();
            OriginalIndices originalIndices = remoteClusterIndices.getValue();
            IndicesOptions relaxedFanoutIdxOptions = originalIndices.indicesOptions();
            ResolveIndexAction.Request remoteRequest = new ResolveIndexAction.Request(originalIndices.indices(), relaxedFanoutIdxOptions);
            SubscribableListener<Transport.Connection> connectionListener = new SubscribableListener<Transport.Connection>();
            connectionListener.addTimeout(this.forceConnectTimeoutSecs, this.transportService.getThreadPool(), EsExecutors.DIRECT_EXECUTOR_SERVICE);
            connectionListener.addListener(groupedListener.delegateResponse((l, failure) -> {
                logger.info("failed to resolve indices on remote cluster [" + clusterAlias + "]", (Throwable)failure);
                l.onFailure((Exception)failure);
            }).delegateFailure((ignored, connection) -> this.transportService.sendRequest((Transport.Connection)connection, ResolveIndexAction.REMOTE_TYPE.name(), (TransportRequest)remoteRequest, TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<ResolveIndexAction.Response>(groupedListener.delegateResponse((l, failure) -> {
                logger.info("Error occurred on remote cluster [" + clusterAlias + "]", (Throwable)failure);
                l.onFailure((Exception)failure);
            }).map(resolveIndexResponse -> Map.entry(clusterAlias, resolveIndexResponse)), ResolveIndexAction.Response::new, EsExecutors.DIRECT_EXECUTOR_SERVICE))));
            remoteClusterService.maybeEnsureConnectedAndGetConnection(clusterAlias, true, connectionListener);
        }
    }

    private void executeOpenPit(SearchTask task, OpenPointInTimeRequest request, ActionListener<OpenPointInTimeResponse> listener) {
        SearchRequest searchRequest = new SearchRequest().indices(request.indices()).indicesOptions(request.indicesOptions()).preference(request.preference()).routing(request.routing()).allowPartialSearchResults(request.allowPartialSearchResults()).source(new SearchSourceBuilder().query(request.indexFilter()));
        searchRequest.setMaxConcurrentShardRequests(request.maxConcurrentShardRequests());
        searchRequest.setCcsMinimizeRoundtrips(false);
        this.transportSearchAction.executeOpenPit(task, searchRequest, listener.map(r -> {
            assert (r.pointInTimeId() != null) : r;
            return new OpenPointInTimeResponse(r.pointInTimeId(), r.getTotalShards(), r.getSuccessfulShards(), r.getFailedShards(), r.getSkippedShards());
        }), searchListener -> new OpenPointInTimePhase(request, (ActionListener<SearchResponse>)searchListener));
    }

    private class ShardOpenReaderRequestHandler
    implements TransportRequestHandler<ShardOpenReaderRequest> {
        private ShardOpenReaderRequestHandler() {
        }

        @Override
        public void messageReceived(ShardOpenReaderRequest request, TransportChannel channel, Task task) {
            TransportOpenPointInTimeAction.this.searchService.openReaderContext(request.getShardId(), request.keepAlive, new ChannelActionListener<TransportResponse>(channel).map(ShardOpenReaderResponse::new));
        }
    }

    private final class OpenPointInTimePhase
    implements TransportSearchAction.SearchPhaseProvider {
        private final OpenPointInTimeRequest pitRequest;
        private final ActionListener<SearchResponse> listener;

        OpenPointInTimePhase(OpenPointInTimeRequest pitRequest, ActionListener<SearchResponse> listener) {
            this.pitRequest = pitRequest;
            this.listener = listener;
        }

        @Override
        public void runNewSearchPhase(SearchTask task, SearchRequest searchRequest, Executor executor, List<SearchShardIterator> shardIterators, TransportSearchAction.SearchTimeProvider timeProvider, BiFunction<String, String, Transport.Connection> connectionLookup, ClusterState clusterState, Map<String, AliasFilter> aliasFilter, Map<String, Float> concreteIndexBoosts, boolean preFilter, ThreadPool threadPool, SearchResponse.Clusters clusters, Map<String, Object> searchRequestAttributes) {
            if (SearchService.canRewriteToMatchNone(searchRequest.source())) {
                CanMatchPreFilterSearchPhase.execute(logger, TransportOpenPointInTimeAction.this.searchTransportService, connectionLookup, aliasFilter, concreteIndexBoosts, threadPool.executor("search_coordination"), searchRequest, shardIterators, timeProvider, task, false, TransportOpenPointInTimeAction.this.searchService.getCoordinatorRewriteContextProvider(timeProvider::absoluteStartMillis), TransportOpenPointInTimeAction.this.searchResponseMetrics, searchRequestAttributes).addListener(this.listener.delegateFailureAndWrap((searchResponseActionListener, searchShardIterators) -> this.runOpenPointInTimePhase(task, searchRequest, executor, (List<SearchShardIterator>)searchShardIterators, timeProvider, connectionLookup, clusterState, aliasFilter, concreteIndexBoosts, clusters, searchRequestAttributes)));
            } else {
                this.runOpenPointInTimePhase(task, searchRequest, executor, shardIterators, timeProvider, connectionLookup, clusterState, aliasFilter, concreteIndexBoosts, clusters, searchRequestAttributes);
            }
        }

        void runOpenPointInTimePhase(SearchTask task, SearchRequest searchRequest, Executor executor, List<SearchShardIterator> shardIterators, TransportSearchAction.SearchTimeProvider timeProvider, BiFunction<String, String, Transport.Connection> connectionLookup, ClusterState clusterState, Map<String, AliasFilter> aliasFilter, Map<String, Float> concreteIndexBoosts, SearchResponse.Clusters clusters, Map<String, Object> searchRequestAttributes) {
            assert (searchRequest.getMaxConcurrentShardRequests() == this.pitRequest.maxConcurrentShardRequests()) : searchRequest.getMaxConcurrentShardRequests() + " != " + this.pitRequest.maxConcurrentShardRequests();
            final TransportVersion minTransportVersion = clusterState.getMinTransportVersion();
            new AbstractSearchAsyncAction<SearchPhaseResult>("open_pit", logger, TransportOpenPointInTimeAction.this.namedWriteableRegistry, TransportOpenPointInTimeAction.this.searchTransportService, connectionLookup, aliasFilter, concreteIndexBoosts, executor, searchRequest, this.listener, shardIterators, timeProvider, clusterState, task, new ArraySearchPhaseResults(shardIterators.size()), searchRequest.getMaxConcurrentShardRequests(), clusters, TransportOpenPointInTimeAction.this.searchResponseMetrics, searchRequestAttributes){

                @Override
                protected void executePhaseOnShard(SearchShardIterator shardIt, Transport.Connection connection, SearchActionListener<SearchPhaseResult> phaseListener) {
                    TransportOpenPointInTimeAction.this.transportService.sendChildRequest(connection, TransportOpenPointInTimeAction.OPEN_SHARD_READER_CONTEXT_NAME, new ShardOpenReaderRequest(shardIt.shardId(), shardIt.getOriginalIndices(), OpenPointInTimePhase.this.pitRequest.keepAlive()), this.task, new ActionListenerResponseHandler<ShardOpenReaderResponse>(phaseListener, ShardOpenReaderResponse::new, TransportResponseHandler.TRANSPORT_WORKER));
                }

                @Override
                protected SearchPhase getNextPhase() {
                    return new SearchPhase(this.getName()){

                        @Override
                        protected void run() {
                            this.sendSearchResponse(SearchResponseSections.EMPTY_WITH_TOTAL_HITS, results.getAtomicArray());
                        }
                    };
                }

                @Override
                protected BytesReference buildSearchContextId(ShardSearchFailure[] failures) {
                    return SearchContextId.encode(this.results.getAtomicArray().asList(), (Map<String, AliasFilter>)this.aliasFilter, minTransportVersion, failures);
                }
            }.start();
        }
    }

    private static final class ShardOpenReaderResponse
    extends SearchPhaseResult {
        ShardOpenReaderResponse(ShardSearchContextId contextId) {
            this.contextId = contextId;
        }

        ShardOpenReaderResponse(StreamInput in) throws IOException {
            this.contextId = new ShardSearchContextId(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.contextId.writeTo(out);
        }
    }

    private static final class ShardOpenReaderRequest
    extends AbstractTransportRequest
    implements IndicesRequest {
        final ShardId shardId;
        final OriginalIndices originalIndices;
        final TimeValue keepAlive;

        ShardOpenReaderRequest(ShardId shardId, OriginalIndices originalIndices, TimeValue keepAlive) {
            this.shardId = shardId;
            this.originalIndices = originalIndices;
            this.keepAlive = keepAlive;
        }

        ShardOpenReaderRequest(StreamInput in) throws IOException {
            super(in);
            this.shardId = new ShardId(in);
            this.originalIndices = OriginalIndices.readOriginalIndices(in);
            this.keepAlive = in.readTimeValue();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
            OriginalIndices.writeOriginalIndices(this.originalIndices, out);
            out.writeTimeValue(this.keepAlive);
        }

        public ShardId getShardId() {
            return this.shardId;
        }

        @Override
        public String[] indices() {
            return this.originalIndices.indices();
        }

        @Override
        public IndicesOptions indicesOptions() {
            return this.originalIndices.indicesOptions();
        }
    }
}

