/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.admin.cluster.shards.ClusterSearchShardsGroup;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.SplitShardCountSummary;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.IndexReshardService;
import org.elasticsearch.index.shard.ShardId;

public class SearchShardsGroup
implements Writeable {
    private final ShardId shardId;
    private final List<String> allocatedNodes;
    private final boolean skipped;
    private final SplitShardCountSummary reshardSplitShardCountSummary;
    private final transient boolean preFiltered;

    public SearchShardsGroup(ShardId shardId, List<String> allocatedNodes, boolean skipped, SplitShardCountSummary reshardSplitShardCountSummary) {
        this.shardId = shardId;
        this.allocatedNodes = allocatedNodes;
        this.skipped = skipped;
        this.reshardSplitShardCountSummary = reshardSplitShardCountSummary;
        this.preFiltered = true;
    }

    SearchShardsGroup(ClusterSearchShardsGroup oldGroup) {
        this.shardId = oldGroup.getShardId();
        this.allocatedNodes = Arrays.stream(oldGroup.getShards()).map(ShardRouting::currentNodeId).toList();
        this.skipped = false;
        this.reshardSplitShardCountSummary = SplitShardCountSummary.UNSET;
        this.preFiltered = false;
    }

    public SearchShardsGroup(StreamInput in) throws IOException {
        this.shardId = new ShardId(in);
        this.allocatedNodes = in.readStringCollectionAsList();
        this.skipped = in.readBoolean();
        this.reshardSplitShardCountSummary = in.getTransportVersion().supports(IndexReshardService.RESHARDING_SHARD_SUMMARY_IN_ESQL) ? SplitShardCountSummary.fromInt(in.readVInt()) : SplitShardCountSummary.UNSET;
        this.preFiltered = true;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (!this.preFiltered) {
            assert (false) : "Serializing a response created from a legacy response is not allowed";
            throw new IllegalStateException("Serializing a response created from a legacy response is not allowed");
        }
        this.shardId.writeTo(out);
        out.writeStringCollection(this.allocatedNodes);
        out.writeBoolean(this.skipped);
        if (out.getTransportVersion().supports(IndexReshardService.RESHARDING_SHARD_SUMMARY_IN_ESQL)) {
            this.reshardSplitShardCountSummary.writeTo(out);
        }
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public boolean skipped() {
        return this.skipped;
    }

    boolean preFiltered() {
        return this.preFiltered;
    }

    public List<String> allocatedNodes() {
        return this.allocatedNodes;
    }

    public SplitShardCountSummary reshardSplitShardCountSummary() {
        return this.reshardSplitShardCountSummary;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchShardsGroup that = (SearchShardsGroup)o;
        return this.skipped == that.skipped && this.preFiltered == that.preFiltered && Objects.equals(this.shardId, that.shardId) && Objects.equals(this.allocatedNodes, that.allocatedNodes) && Objects.equals(this.reshardSplitShardCountSummary, that.reshardSplitShardCountSummary);
    }

    public int hashCode() {
        return Objects.hash(this.shardId, this.allocatedNodes, this.skipped, this.reshardSplitShardCountSummary, this.preFiltered);
    }

    public String toString() {
        return "SearchShardsGroup{shardId=" + String.valueOf(this.shardId) + ", allocatedNodes=" + String.valueOf(this.allocatedNodes) + ", skipped=" + this.skipped + ", preFiltered=" + this.preFiltered + "}";
    }
}

