/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.ResolvedIndexExpressions;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.search.SearchTask;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.search.builder.PointInTimeBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ToXContent;

public class SearchRequest
extends LegacyActionRequest
implements IndicesRequest.Replaceable,
Rewriteable<SearchRequest> {
    public static final ToXContent.Params FORMAT_PARAMS = new ToXContent.MapParams(Collections.singletonMap("pretty", "false"));
    public static final int DEFAULT_PRE_FILTER_SHARD_SIZE = 128;
    public static final int DEFAULT_BATCHED_REDUCE_SIZE = 512;
    private static final long DEFAULT_ABSOLUTE_START_MILLIS = -1L;
    private static final TransportVersion RE_REMOVE_MIN_COMPATIBLE_SHARD_NODE = TransportVersion.fromName("re_remove_min_compatible_shard_node");
    private final String localClusterAlias;
    private final long absoluteStartMillis;
    private final boolean finalReduce;
    private SearchType searchType = SearchType.DEFAULT;
    private String[] indices = Strings.EMPTY_ARRAY;
    @Nullable
    private ResolvedIndexExpressions resolvedIndexExpressions = null;
    @Nullable
    private String routing;
    @Nullable
    private String preference;
    private SearchSourceBuilder source;
    private Boolean requestCache;
    private Boolean allowPartialSearchResults;
    private TimeValue scrollKeepAlive;
    private int batchedReduceSize = 512;
    private int maxConcurrentShardRequests = 0;
    public static final int DEFAULT_MAX_CONCURRENT_SHARD_REQUESTS = 5;
    private Integer preFilterShardSize;
    private boolean ccsMinimizeRoundtrips;
    public static final IndicesOptions DEFAULT_INDICES_OPTIONS = IndicesOptions.strictExpandOpenAndForbidClosedIgnoreThrottled();
    public static final IndicesOptions DEFAULT_CPS_INDICES_OPTIONS = IndicesOptions.cpsStrictExpandOpenAndForbidClosedIgnoreThrottled();
    private IndicesOptions indicesOptions = DEFAULT_INDICES_OPTIONS;
    private Map<String, long[]> waitForCheckpoints = Collections.emptyMap();
    private TimeValue waitForCheckpointsTimeout = TimeValue.timeValueSeconds(30L);
    private boolean forceSyntheticSource = false;
    @Nullable
    private String projectRouting;
    private static final TransportVersion SEARCH_PROJECT_ROUTING = TransportVersion.fromName("search_project_routing");

    public SearchRequest() {
        this.localClusterAlias = null;
        this.absoluteStartMillis = -1L;
        this.finalReduce = true;
        this.ccsMinimizeRoundtrips = true;
    }

    public SearchRequest(SearchRequest searchRequest) {
        this(searchRequest, searchRequest.indices, searchRequest.localClusterAlias, searchRequest.absoluteStartMillis, searchRequest.finalReduce);
    }

    public SearchRequest(String ... indices) {
        this(indices, new SearchSourceBuilder());
    }

    public SearchRequest(String[] indices, SearchSourceBuilder source) {
        this();
        if (source == null) {
            throw new IllegalArgumentException("source must not be null");
        }
        this.indices(indices);
        this.source = source;
    }

    @Override
    public boolean allowsRemoteIndices() {
        return true;
    }

    @Override
    public boolean allowsCrossProject() {
        return true;
    }

    @Override
    public String getProjectRouting() {
        return this.projectRouting;
    }

    public void setProjectRouting(@Nullable String projectRouting) {
        if (this.projectRouting != null) {
            throw new IllegalArgumentException("project_routing is already set to [" + this.projectRouting + "]");
        }
        this.projectRouting = projectRouting;
    }

    static SearchRequest subSearchRequest(TaskId parentTaskId, SearchRequest originalSearchRequest, String[] indices, IndicesOptions indicesOptions, String clusterAlias, long absoluteStartMillis, boolean finalReduce) {
        Objects.requireNonNull(parentTaskId, "parentTaskId must be specified");
        Objects.requireNonNull(originalSearchRequest, "search request must not be null");
        SearchRequest.validateIndices(indices);
        Objects.requireNonNull(clusterAlias, "cluster alias must not be null");
        if (absoluteStartMillis < 0L) {
            throw new IllegalArgumentException("absoluteStartMillis must not be negative but was [" + absoluteStartMillis + "]");
        }
        SearchRequest request = new SearchRequest(originalSearchRequest, indices, clusterAlias, absoluteStartMillis, finalReduce);
        request.setParentTask(parentTaskId);
        request.indicesOptions(indicesOptions);
        return request;
    }

    private SearchRequest(SearchRequest searchRequest, String[] indices, String localClusterAlias, long absoluteStartMillis, boolean finalReduce) {
        this.allowPartialSearchResults = searchRequest.allowPartialSearchResults;
        this.batchedReduceSize = searchRequest.batchedReduceSize;
        this.ccsMinimizeRoundtrips = searchRequest.ccsMinimizeRoundtrips;
        this.indices = indices;
        this.indicesOptions = searchRequest.indicesOptions;
        this.maxConcurrentShardRequests = searchRequest.maxConcurrentShardRequests;
        this.preference = searchRequest.preference;
        this.preFilterShardSize = searchRequest.preFilterShardSize;
        this.requestCache = searchRequest.requestCache;
        this.routing = searchRequest.routing;
        this.scrollKeepAlive = searchRequest.scrollKeepAlive;
        this.searchType = searchRequest.searchType;
        this.source = searchRequest.source;
        this.localClusterAlias = localClusterAlias;
        this.absoluteStartMillis = absoluteStartMillis;
        this.finalReduce = finalReduce;
        this.waitForCheckpoints = searchRequest.waitForCheckpoints;
        this.waitForCheckpointsTimeout = searchRequest.waitForCheckpointsTimeout;
        this.forceSyntheticSource = searchRequest.forceSyntheticSource;
        this.projectRouting = searchRequest.projectRouting;
    }

    public SearchRequest(StreamInput in) throws IOException {
        super(in);
        this.searchType = SearchType.fromId(in.readByte());
        this.indices = in.readStringArray();
        this.routing = in.readOptionalString();
        this.preference = in.readOptionalString();
        this.scrollKeepAlive = in.readOptionalTimeValue();
        this.source = in.readOptionalWriteable(SearchSourceBuilder::new);
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        this.requestCache = in.readOptionalBoolean();
        this.batchedReduceSize = in.readVInt();
        this.maxConcurrentShardRequests = in.readVInt();
        this.preFilterShardSize = in.readOptionalVInt();
        this.allowPartialSearchResults = in.readOptionalBoolean();
        this.localClusterAlias = in.readOptionalString();
        if (this.localClusterAlias != null) {
            this.absoluteStartMillis = in.readVLong();
            this.finalReduce = in.readBoolean();
        } else {
            this.absoluteStartMillis = -1L;
            this.finalReduce = true;
        }
        this.ccsMinimizeRoundtrips = in.readBoolean();
        if (!in.getTransportVersion().supports(RE_REMOVE_MIN_COMPATIBLE_SHARD_NODE) && in.readBoolean()) {
            Version.readVersion(in);
        }
        this.waitForCheckpoints = in.readMap(StreamInput::readLongArray);
        this.waitForCheckpointsTimeout = in.readTimeValue();
        this.forceSyntheticSource = in.readBoolean();
        this.projectRouting = in.getTransportVersion().supports(SEARCH_PROJECT_ROUTING) ? in.readOptionalString() : null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.writeTo(out, false);
    }

    public void writeTo(StreamOutput out, boolean skipIndices) throws IOException {
        String[] stringArray;
        super.writeTo(out);
        out.writeByte(this.searchType.id());
        if (skipIndices) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "*";
            stringArray = stringArray2;
            stringArray2[1] = "-*";
        } else {
            stringArray = this.indices;
        }
        out.writeStringArray(stringArray);
        out.writeOptionalString(this.routing);
        out.writeOptionalString(this.preference);
        out.writeOptionalTimeValue(this.scrollKeepAlive);
        out.writeOptionalWriteable(this.source);
        this.indicesOptions.writeIndicesOptions(out);
        out.writeOptionalBoolean(this.requestCache);
        out.writeVInt(this.batchedReduceSize);
        out.writeVInt(this.maxConcurrentShardRequests);
        out.writeOptionalVInt(this.preFilterShardSize);
        out.writeOptionalBoolean(this.allowPartialSearchResults);
        out.writeOptionalString(this.localClusterAlias);
        if (this.localClusterAlias != null) {
            out.writeVLong(this.absoluteStartMillis);
            out.writeBoolean(this.finalReduce);
        }
        out.writeBoolean(this.ccsMinimizeRoundtrips);
        if (!out.getTransportVersion().supports(RE_REMOVE_MIN_COMPATIBLE_SHARD_NODE)) {
            out.writeBoolean(false);
        }
        out.writeMap(this.waitForCheckpoints, StreamOutput::writeLongArray);
        out.writeTimeValue(this.waitForCheckpointsTimeout);
        out.writeBoolean(this.forceSyntheticSource);
        if (out.getTransportVersion().supports(SEARCH_PROJECT_ROUTING)) {
            out.writeOptionalString(this.projectRouting);
        }
    }

    @Override
    public ActionRequestValidationException validate() {
        boolean allowPartialSearchResults;
        ActionRequestValidationException validationException = null;
        boolean scroll = this.scroll() != null;
        boolean bl = allowPartialSearchResults = this.allowPartialSearchResults() == null ? true : this.allowPartialSearchResults();
        if (this.source != null) {
            validationException = this.source.validate(validationException, scroll, allowPartialSearchResults);
        }
        if (scroll && this.requestCache != null && this.requestCache.booleanValue()) {
            validationException = ValidateActions.addValidationError("[request_cache] cannot be used in a scroll context", validationException);
        }
        if (this.pointInTimeBuilder() != null) {
            if (scroll) {
                validationException = ValidateActions.addValidationError("using [point in time] is not allowed in a scroll context", validationException);
            }
            if (this.indices().length > 0) {
                validationException = ValidateActions.addValidationError("[indices] cannot be used with point in time. Do not specify any index with point in time.", validationException);
            }
            if (!this.indicesOptions().equals(DEFAULT_INDICES_OPTIONS) && !this.indicesOptions().equals(DEFAULT_CPS_INDICES_OPTIONS)) {
                validationException = ValidateActions.addValidationError("[indicesOptions] cannot be used with point in time", validationException);
            }
            if (this.getProjectRouting() != null) {
                validationException = ValidateActions.addValidationError("[projectRouting] cannot be used with point in time", validationException);
            }
            if (this.routing() != null) {
                validationException = ValidateActions.addValidationError("[routing] cannot be used with point in time", validationException);
            }
            if (this.preference() != null) {
                validationException = ValidateActions.addValidationError("[preference] cannot be used with point in time", validationException);
            }
        }
        if (this.pointInTimeBuilder() != null && !this.waitForCheckpoints.isEmpty()) {
            validationException = ValidateActions.addValidationError("using [point in time] is not allowed with wait_for_checkpoints", validationException);
        }
        return validationException;
    }

    @Nullable
    String getLocalClusterAlias() {
        return this.localClusterAlias;
    }

    boolean isFinalReduce() {
        return this.finalReduce;
    }

    long getOrCreateAbsoluteStartMillis() {
        return this.absoluteStartMillis == -1L ? System.currentTimeMillis() : this.absoluteStartMillis;
    }

    long getAbsoluteStartMillis() {
        return this.absoluteStartMillis;
    }

    @Override
    public SearchRequest indices(String ... indices) {
        SearchRequest.validateIndices(indices);
        this.indices = indices;
        return this;
    }

    @Override
    public void setResolvedIndexExpressions(ResolvedIndexExpressions expressions) {
        this.resolvedIndexExpressions = expressions;
    }

    @Override
    @Nullable
    public ResolvedIndexExpressions getResolvedIndexExpressions() {
        return this.resolvedIndexExpressions;
    }

    private static void validateIndices(String ... indices) {
        Objects.requireNonNull(indices, "indices must not be null");
        for (String index : indices) {
            Objects.requireNonNull(index, "index must not be null");
        }
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public SearchRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = Objects.requireNonNull(indicesOptions, "indicesOptions must not be null");
        return this;
    }

    @Override
    public boolean includeDataStreams() {
        return true;
    }

    public boolean isCcsMinimizeRoundtrips() {
        return this.ccsMinimizeRoundtrips;
    }

    public void setCcsMinimizeRoundtrips(boolean ccsMinimizeRoundtrips) {
        this.ccsMinimizeRoundtrips = ccsMinimizeRoundtrips;
    }

    public String routing() {
        return this.routing;
    }

    public SearchRequest routing(String routing) {
        this.routing = routing;
        return this;
    }

    public SearchRequest routing(String ... routings) {
        this.routing = Strings.arrayToCommaDelimitedString(routings);
        return this;
    }

    public SearchRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    public String preference() {
        return this.preference;
    }

    public SearchRequest searchType(SearchType searchType) {
        this.searchType = Objects.requireNonNull(searchType, "searchType must not be null");
        return this;
    }

    public SearchRequest searchType(String searchType) {
        return this.searchType(SearchType.fromString(searchType));
    }

    public SearchRequest source(SearchSourceBuilder sourceBuilder) {
        this.source = Objects.requireNonNull(sourceBuilder, "source must not be null");
        return this;
    }

    public SearchSourceBuilder source() {
        return this.source;
    }

    public PointInTimeBuilder pointInTimeBuilder() {
        if (this.source != null) {
            return this.source.pointInTimeBuilder();
        }
        return null;
    }

    public SearchType searchType() {
        return this.searchType;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    public TimeValue scroll() {
        return this.scrollKeepAlive;
    }

    public SearchRequest scroll(TimeValue keepAlive) {
        this.scrollKeepAlive = keepAlive;
        return this;
    }

    public SearchRequest requestCache(Boolean requestCache) {
        this.requestCache = requestCache;
        return this;
    }

    public Boolean requestCache() {
        return this.requestCache;
    }

    public SearchRequest allowPartialSearchResults(boolean allowPartialSearchResults) {
        this.allowPartialSearchResults = allowPartialSearchResults;
        return this;
    }

    public Boolean allowPartialSearchResults() {
        return this.allowPartialSearchResults;
    }

    public void setBatchedReduceSize(int batchedReduceSize) {
        if (batchedReduceSize <= 1) {
            throw new IllegalArgumentException("batchedReduceSize must be >= 2");
        }
        this.batchedReduceSize = batchedReduceSize;
    }

    public int getBatchedReduceSize() {
        return this.batchedReduceSize;
    }

    public int getMaxConcurrentShardRequests() {
        return this.maxConcurrentShardRequests == 0 ? 5 : this.maxConcurrentShardRequests;
    }

    public void setMaxConcurrentShardRequests(int maxConcurrentShardRequests) {
        if (maxConcurrentShardRequests < 1) {
            throw new IllegalArgumentException("maxConcurrentShardRequests must be >= 1");
        }
        this.maxConcurrentShardRequests = maxConcurrentShardRequests;
    }

    public Map<String, long[]> getWaitForCheckpoints() {
        return this.waitForCheckpoints;
    }

    public void setWaitForCheckpoints(Map<String, long[]> afterCheckpointsRefreshed) {
        this.waitForCheckpoints = afterCheckpointsRefreshed;
    }

    public TimeValue getWaitForCheckpointsTimeout() {
        return this.waitForCheckpointsTimeout;
    }

    public void setWaitForCheckpointsTimeout(TimeValue waitForCheckpointsTimeout) {
        this.waitForCheckpointsTimeout = waitForCheckpointsTimeout;
    }

    public void setPreFilterShardSize(int preFilterShardSize) {
        if (preFilterShardSize < 1) {
            throw new IllegalArgumentException("preFilterShardSize must be >= 1");
        }
        this.preFilterShardSize = preFilterShardSize;
    }

    @Nullable
    public Integer getPreFilterShardSize() {
        return this.preFilterShardSize;
    }

    public boolean isSuggestOnly() {
        return this.source != null && this.source.isSuggestOnly();
    }

    public boolean hasKnnSearch() {
        return this.source != null && !this.source.knnSearch().isEmpty();
    }

    public int resolveTrackTotalHitsUpTo() {
        return SearchRequest.resolveTrackTotalHitsUpTo(this.scrollKeepAlive, this.source);
    }

    public boolean isForceSyntheticSource() {
        return this.forceSyntheticSource;
    }

    public void setForceSyntheticSource(boolean forceSyntheticSource) {
        this.forceSyntheticSource = forceSyntheticSource;
    }

    @Override
    public SearchRequest rewrite(QueryRewriteContext ctx) throws IOException {
        SortBuilder<?> lastSort;
        if (this.source == null) {
            return this;
        }
        SearchSourceBuilder source = this.source.rewrite(ctx);
        boolean hasChanged = source != this.source;
        Object[] searchAfter = source.searchAfter();
        if (!(source.pointInTimeBuilder() == null || source.sorts() == null || source.sorts().isEmpty() || searchAfter != null && searchAfter.length != source.sorts().size() + 1 || (lastSort = source.sorts().get(source.sorts().size() - 1)) instanceof FieldSortBuilder && "_shard_doc".equals(((FieldSortBuilder)lastSort).getFieldName()))) {
            ArrayList newSorts = new ArrayList(source.sorts());
            newSorts.add(SortBuilders.pitTiebreaker().unmappedType("long"));
            source = source.shallowCopy().sort(newSorts);
            hasChanged = true;
        }
        return hasChanged ? new SearchRequest(this).source(source) : this;
    }

    public static int resolveTrackTotalHitsUpTo(TimeValue scroll, SearchSourceBuilder source) {
        if (scroll != null) {
            return Integer.MAX_VALUE;
        }
        return source == null ? 10000 : (source.trackTotalHitsUpTo() == null ? 10000 : source.trackTotalHitsUpTo());
    }

    @Override
    public SearchTask createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new SearchTask(id, type, action, this::buildDescription, parentTaskId, headers);
    }

    public final String buildDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("indices[");
        Strings.arrayToDelimitedString(this.indices, ",", sb);
        sb.append("]");
        sb.append(", search_type[").append((Object)this.searchType).append("]");
        if (this.scrollKeepAlive != null) {
            sb.append(", scroll[").append(this.scrollKeepAlive).append("]");
        }
        if (this.source != null) {
            sb.append(", source[").append(this.source.toString(FORMAT_PARAMS)).append("]");
        } else {
            sb.append(", source[]");
        }
        if (this.routing != null) {
            sb.append(", routing[").append(this.routing).append("]");
        }
        if (this.preference != null) {
            sb.append(", preference[").append(this.preference).append("]");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchRequest that = (SearchRequest)o;
        return this.searchType == that.searchType && Arrays.equals(this.indices, that.indices) && Objects.equals(this.routing, that.routing) && Objects.equals(this.preference, that.preference) && Objects.equals(this.source, that.source) && Objects.equals(this.requestCache, that.requestCache) && Objects.equals(this.scrollKeepAlive, that.scrollKeepAlive) && Objects.equals(this.batchedReduceSize, that.batchedReduceSize) && Objects.equals(this.maxConcurrentShardRequests, that.maxConcurrentShardRequests) && Objects.equals(this.preFilterShardSize, that.preFilterShardSize) && Objects.equals(this.indicesOptions, that.indicesOptions) && Objects.equals(this.allowPartialSearchResults, that.allowPartialSearchResults) && Objects.equals(this.localClusterAlias, that.localClusterAlias) && this.absoluteStartMillis == that.absoluteStartMillis && this.ccsMinimizeRoundtrips == that.ccsMinimizeRoundtrips && this.forceSyntheticSource == that.forceSyntheticSource;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.searchType, Arrays.hashCode(this.indices), this.routing, this.preference, this.source, this.requestCache, this.scrollKeepAlive, this.indicesOptions, this.batchedReduceSize, this.maxConcurrentShardRequests, this.preFilterShardSize, this.allowPartialSearchResults, this.localClusterAlias, this.absoluteStartMillis, this.ccsMinimizeRoundtrips, this.forceSyntheticSource});
    }

    @Override
    public String toString() {
        return "SearchRequest{searchType=" + String.valueOf((Object)this.searchType) + ", indices=" + Arrays.toString(this.indices) + ", indicesOptions=" + String.valueOf(this.indicesOptions) + ", routing='" + this.routing + "', preference='" + this.preference + "', requestCache=" + this.requestCache + ", scroll=" + String.valueOf(this.scrollKeepAlive) + ", maxConcurrentShardRequests=" + this.maxConcurrentShardRequests + ", batchedReduceSize=" + this.batchedReduceSize + ", preFilterShardSize=" + this.preFilterShardSize + ", allowPartialSearchResults=" + this.allowPartialSearchResults + ", localClusterAlias=" + this.localClusterAlias + ", getOrCreateAbsoluteStartMillis=" + this.absoluteStartMillis + ", ccsMinimizeRoundtrips=" + this.ccsMinimizeRoundtrips + ", source=" + String.valueOf(this.source) + "}";
    }
}

