/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Stream;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.action.search.SearchPhaseController;
import org.elasticsearch.action.search.SearchPhaseResults;
import org.elasticsearch.action.search.SearchProgressListener;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.search.SearchPhaseResult;

class CountOnlyQueryPhaseResultConsumer
extends SearchPhaseResults<SearchPhaseResult> {
    final AtomicReference<TotalHits.Relation> relationAtomicReference = new AtomicReference<TotalHits.Relation>(TotalHits.Relation.EQUAL_TO);
    final LongAdder totalHits = new LongAdder();
    private final AtomicBoolean terminatedEarly = new AtomicBoolean(false);
    private final AtomicBoolean timedOut = new AtomicBoolean(false);
    private final Set<Integer> results;
    private final SearchProgressListener progressListener;

    CountOnlyQueryPhaseResultConsumer(SearchProgressListener progressListener, int numShards) {
        super(numShards);
        this.progressListener = progressListener;
        this.results = Collections.newSetFromMap(Maps.newConcurrentHashMapWithExpectedSize(numShards));
    }

    @Override
    Stream<SearchPhaseResult> getSuccessfulResults() {
        return Stream.empty();
    }

    @Override
    public void consumeResult(SearchPhaseResult result, Runnable next) {
        assert (!this.results.contains(result.getShardIndex())) : "shardIndex: " + result.getShardIndex() + " is already set";
        this.results.add(result.getShardIndex());
        this.progressListener.notifyQueryResult(result.getShardIndex(), result.queryResult());
        if (result.queryResult().isNull()) {
            next.run();
            return;
        }
        this.relationAtomicReference.compareAndSet(TotalHits.Relation.EQUAL_TO, result.queryResult().getTotalHits().relation());
        this.totalHits.add(result.queryResult().getTotalHits().value());
        this.terminatedEarly.compareAndSet(false, result.queryResult().terminatedEarly() != null && result.queryResult().terminatedEarly() != false);
        this.timedOut.compareAndSet(false, result.queryResult().searchTimedOut());
        next.run();
    }

    @Override
    boolean hasResult(int shardIndex) {
        return this.results.contains(shardIndex);
    }

    @Override
    public SearchPhaseController.ReducedQueryPhase reduce() throws Exception {
        SearchPhaseController.ReducedQueryPhase reducePhase = new SearchPhaseController.ReducedQueryPhase(new TotalHits(this.totalHits.sum(), this.relationAtomicReference.get()), 0L, Float.NaN, this.timedOut.get(), this.terminatedEarly.get(), null, null, null, SearchPhaseController.SortedTopDocs.EMPTY, null, null, 1, 0, 0, this.results.isEmpty(), null);
        if (this.progressListener != SearchProgressListener.NOOP) {
            this.progressListener.notifyFinalReduce(List.of(), reducePhase.totalHits(), reducePhase.aggregations(), reducePhase.numReducePhases());
        }
        return reducePhase;
    }

    @Override
    AtomicArray<SearchPhaseResult> getAtomicArray() {
        return new AtomicArray<SearchPhaseResult>(0);
    }

    @Override
    public void close() {
    }
}

