/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public enum IndexDocFailureStoreStatus implements ToXContentFragment,
Writeable
{
    NOT_APPLICABLE_OR_UNKNOWN(0),
    USED(1),
    NOT_ENABLED(2),
    FAILED(3);

    private final byte id;
    private final String label;

    private IndexDocFailureStoreStatus(int id) {
        this.id = (byte)id;
        this.label = this.toString().toLowerCase(Locale.ROOT);
    }

    public static IndexDocFailureStoreStatus read(StreamInput in) throws IOException {
        return IndexDocFailureStoreStatus.fromId(in.readByte());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeByte(this.id);
    }

    public byte getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public static IndexDocFailureStoreStatus fromId(byte id) {
        return switch (id) {
            case 0 -> NOT_APPLICABLE_OR_UNKNOWN;
            case 1 -> USED;
            case 2 -> NOT_ENABLED;
            case 3 -> FAILED;
            default -> throw new IllegalArgumentException("Unknown failure store status: [" + id + "]");
        };
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (!this.equals(NOT_APPLICABLE_OR_UNKNOWN)) {
            builder.field("failure_store", this.label);
        }
        return builder;
    }

    public static class ExceptionWithFailureStoreStatus
    extends ElasticsearchException {
        private final IndexDocFailureStoreStatus failureStoreStatus;

        public ExceptionWithFailureStoreStatus(BulkItemResponse.Failure failure) {
            super(failure.getCause());
            this.failureStoreStatus = failure.getFailureStoreStatus();
        }

        public ExceptionWithFailureStoreStatus(StreamInput in) throws IOException {
            super(in);
            this.failureStoreStatus = IndexDocFailureStoreStatus.fromId(in.readByte());
        }

        @Override
        protected void writeTo(StreamOutput out, Writeable.Writer<Throwable> nestedExceptionsWriter) throws IOException {
            super.writeTo(out, nestedExceptionsWriter);
            out.writeByte(this.failureStoreStatus.getId());
        }

        @Override
        protected XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params, int nestedLevel) throws IOException {
            ExceptionWithFailureStoreStatus.generateThrowableXContent(builder, params, this.getCause(), nestedLevel);
            this.failureStoreStatus.toXContent(builder, params);
            return builder;
        }

        @Override
        public RestStatus status() {
            return ExceptionsHelper.status(this.getCause());
        }
    }
}

