/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.sampling;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.admin.indices.sampling.GetSampleAction;
import org.elasticsearch.action.admin.indices.sampling.SamplingConfiguration;
import org.elasticsearch.action.admin.indices.sampling.SamplingMetadata;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.ingest.SamplingService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetSampleAction
extends TransportNodesAction<GetSampleAction.Request, GetSampleAction.Response, GetSampleAction.NodeRequest, GetSampleAction.NodeResponse, Void> {
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final SamplingService samplingService;
    private final ProjectResolver projectResolver;

    @Inject
    public TransportGetSampleAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, SamplingService samplingService, ProjectResolver projectResolver) {
        super("indices:admin/sample", clusterService, transportService, actionFilters, GetSampleAction.NodeRequest::new, threadPool.executor("management"));
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.samplingService = samplingService;
        this.projectResolver = projectResolver;
    }

    @Override
    protected Void createActionContext(Task task, GetSampleAction.Request request) {
        String indexName = request.indices()[0];
        SamplingConfiguration samplingConfiguration = this.samplingService.getSamplingConfiguration(this.projectResolver.getProjectMetadata(this.clusterService.state()), request.indices()[0]);
        if (samplingConfiguration == null) {
            throw new ResourceNotFoundException("No sampling configuration found for [" + indexName + "]", new Object[0]);
        }
        return null;
    }

    @Override
    protected GetSampleAction.Response newResponse(GetSampleAction.Request request, List<GetSampleAction.NodeResponse> nodeResponses, List<FailedNodeException> failures) {
        SamplingConfiguration samplingConfiguration;
        SamplingService.throwIndexNotFoundExceptionIfNotDataStreamOrIndex(this.indexNameExpressionResolver, this.projectResolver, this.clusterService.state(), request);
        SamplingMetadata samplingMetadata = (SamplingMetadata)this.projectResolver.getProjectMetadata(this.clusterService.state()).custom("sampling");
        int maxSamples = samplingMetadata == null ? 0 : ((samplingConfiguration = samplingMetadata.getIndexToSamplingConfigMap().get(request.indices()[0])) == null ? 0 : samplingConfiguration.maxSamples());
        return new GetSampleAction.Response(this.clusterService.getClusterName(), nodeResponses, failures, maxSamples);
    }

    @Override
    protected GetSampleAction.NodeRequest newNodeRequest(GetSampleAction.Request request) {
        return new GetSampleAction.NodeRequest(request.indices()[0]);
    }

    @Override
    protected GetSampleAction.NodeResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new GetSampleAction.NodeResponse(in);
    }

    @Override
    protected GetSampleAction.NodeResponse nodeOperation(GetSampleAction.NodeRequest request, Task task) {
        String index = request.indices()[0];
        List<SamplingService.RawDocument> sample = this.samplingService.getLocalSample(this.projectResolver.getProjectId(), index);
        return new GetSampleAction.NodeResponse(this.transportService.getLocalNode(), sample == null ? List.of() : sample);
    }
}

