/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.rollover;

import java.io.IOException;
import org.elasticsearch.action.admin.indices.rollover.Condition;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class MinDocsCondition
extends Condition<Long> {
    public static final String NAME = "min_docs";

    public MinDocsCondition(Long value) {
        super(NAME, Condition.Type.MIN);
        this.value = value;
    }

    public MinDocsCondition(StreamInput in) throws IOException {
        super(NAME, Condition.Type.MIN);
        this.value = in.readLong();
    }

    @Override
    public Condition.Result evaluate(Condition.Stats stats) {
        return new Condition.Result(this, (Long)this.value <= stats.numDocs());
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong((Long)this.value);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.field(NAME, (Long)this.value);
    }

    public static MinDocsCondition fromXContent(XContentParser parser) throws IOException {
        if (parser.nextToken() == XContentParser.Token.VALUE_NUMBER) {
            return new MinDocsCondition(parser.longValue());
        }
        throw new IllegalArgumentException("invalid token when parsing min_docs condition: " + String.valueOf((Object)parser.currentToken()));
    }
}

