/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.mapping.put;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.RequestValidators;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetadataMappingService;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportPutMappingAction
extends AcknowledgedTransportMasterNodeAction<PutMappingRequest> {
    public static final ActionType<AcknowledgedResponse> TYPE = new ActionType("indices:admin/mapping/put");
    private static final Logger logger = LogManager.getLogger(TransportPutMappingAction.class);
    private final MetadataMappingService metadataMappingService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final RequestValidators<PutMappingRequest> requestValidators;
    private final SystemIndices systemIndices;
    private final ProjectResolver projectResolver;

    @Inject
    public TransportPutMappingAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataMappingService metadataMappingService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, RequestValidators<PutMappingRequest> requestValidators, SystemIndices systemIndices, ProjectResolver projectResolver) {
        super(TYPE.name(), transportService, clusterService, threadPool, actionFilters, PutMappingRequest::new, threadPool.executor("management"));
        this.metadataMappingService = metadataMappingService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.requestValidators = Objects.requireNonNull(requestValidators);
        this.systemIndices = systemIndices;
        this.projectResolver = projectResolver;
    }

    @Override
    protected ClusterBlockException checkBlock(PutMappingRequest request, ClusterState state) {
        String[] indices;
        ProjectId projectId = this.projectResolver.getProjectId();
        if (request.getConcreteIndex() == null) {
            ProjectMetadata projectMetadata = state.metadata().getProject(projectId);
            indices = this.indexNameExpressionResolver.concreteIndexNames(projectMetadata, (IndicesRequest)request);
        } else {
            indices = new String[]{request.getConcreteIndex().getName()};
        }
        return state.blocks().indicesBlockedException(projectId, ClusterBlockLevel.METADATA_WRITE, indices);
    }

    @Override
    protected void masterOperation(Task task, PutMappingRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        try {
            ProjectMetadata projectMetadata = this.projectResolver.getProjectMetadata(state);
            Index[] concreteIndices = TransportPutMappingAction.resolveIndices(projectMetadata, request, this.indexNameExpressionResolver);
            Optional<Exception> maybeValidationException = this.requestValidators.validateRequest(request, projectMetadata, concreteIndices);
            if (maybeValidationException.isPresent()) {
                listener.onFailure(maybeValidationException.get());
                return;
            }
            String message = TransportPutMappingAction.checkForFailureStoreViolations(projectMetadata, concreteIndices, request);
            if (message != null) {
                logger.warn(message);
                listener.onFailure(new IllegalStateException(message));
                return;
            }
            message = TransportPutMappingAction.checkForSystemIndexViolations(this.systemIndices, concreteIndices, request);
            if (message != null) {
                logger.warn(message);
                listener.onFailure(new IllegalStateException(message));
                return;
            }
            TransportPutMappingAction.performMappingUpdate(concreteIndices, request, listener, this.metadataMappingService, false);
        }
        catch (IndexNotFoundException ex) {
            logger.debug(() -> "failed to put mappings on indices " + Arrays.toString(request.indices()), (Throwable)ex);
            throw ex;
        }
    }

    static Index[] resolveIndices(ProjectMetadata projectMetadata, PutMappingRequest request, IndexNameExpressionResolver iner) {
        if (request.getConcreteIndex() == null) {
            if (request.writeIndexOnly()) {
                ArrayList<Index> indices = new ArrayList<Index>();
                for (String indexExpression : request.indices()) {
                    indices.add(iner.concreteWriteIndex(projectMetadata, request.indicesOptions(), indexExpression, request.indicesOptions().allowNoIndices(), request.includeDataStreams()));
                }
                return indices.toArray(Index.EMPTY_ARRAY);
            }
            return iner.concreteIndices(projectMetadata, (IndicesRequest)request);
        }
        return new Index[]{request.getConcreteIndex()};
    }

    static void performMappingUpdate(Index[] concreteIndices, PutMappingRequest request, ActionListener<AcknowledgedResponse> listener, MetadataMappingService metadataMappingService, boolean autoUpdate) {
        ActionListener.run(listener.delegateResponse((l, e) -> {
            logger.debug(() -> "failed to put mappings on indices " + Arrays.toString(concreteIndices), (Throwable)e);
            l.onFailure((Exception)e);
        }), wrappedListener -> metadataMappingService.putMapping(new PutMappingClusterStateUpdateRequest(request.masterNodeTimeout(), request.ackTimeout(), request.source(), autoUpdate, concreteIndices), (ActionListener<AcknowledgedResponse>)wrappedListener));
    }

    static String checkForFailureStoreViolations(ProjectMetadata projectMetadata, Index[] concreteIndices, PutMappingRequest request) {
        if (!Strings.isNullOrEmpty(request.origin())) {
            return null;
        }
        ArrayList<String> violations = new ArrayList<String>();
        SortedMap<String, IndexAbstraction> indicesLookup = projectMetadata.getIndicesLookup();
        for (Index index : concreteIndices) {
            DataStream maybeDataStream;
            IndexAbstraction indexAbstraction = (IndexAbstraction)indicesLookup.get(index.getName());
            if (indexAbstraction == null || (maybeDataStream = indexAbstraction.getParentDataStream()) == null || !maybeDataStream.isFailureStoreIndex(index.getName())) continue;
            violations.add(index.getName());
        }
        if (!violations.isEmpty()) {
            return "Cannot update mappings in " + String.valueOf(violations) + ": mappings for indices contained in data stream failure stores cannot be updated";
        }
        return null;
    }

    static String checkForSystemIndexViolations(SystemIndices systemIndices, Index[] concreteIndices, PutMappingRequest request) {
        if (!Strings.isNullOrEmpty(request.origin())) {
            return null;
        }
        ArrayList<String> violations = new ArrayList<String>();
        String requestMappings = request.source();
        for (Index index : concreteIndices) {
            String descriptorMappings;
            SystemIndexDescriptor descriptor = systemIndices.findMatchingDescriptor(index.getName());
            if (descriptor == null || !descriptor.isAutomaticallyManaged() || descriptor.hasDynamicMappings() || (descriptorMappings = descriptor.getMappings()).equals(requestMappings)) continue;
            violations.add(index.getName());
        }
        if (!violations.isEmpty()) {
            return "Cannot update mappings in " + String.valueOf(violations) + ": system indices can only use mappings from their descriptors, but the mappings in the request [" + requestMappings + "] did not match those in the descriptor(s)";
        }
        return null;
    }
}

