/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.stats;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.admin.cluster.stats.ExtendedSearchUsageStats;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public final class SearchUsageStats
implements Writeable,
ToXContentFragment {
    static final TransportVersion EXTENDED_SEARCH_USAGE_TELEMETRY = TransportVersion.fromName("extended_search_usage_telemetry");
    private long totalSearchCount;
    private final Map<String, Long> queries;
    private final Map<String, Long> rescorers;
    private final Map<String, Long> sections;
    private final Map<String, Long> retrievers;
    private final ExtendedSearchUsageStats extendedSearchUsageStats;

    public SearchUsageStats() {
        this.totalSearchCount = 0L;
        this.queries = new HashMap<String, Long>();
        this.sections = new HashMap<String, Long>();
        this.rescorers = new HashMap<String, Long>();
        this.retrievers = new HashMap<String, Long>();
        this.extendedSearchUsageStats = new ExtendedSearchUsageStats();
    }

    public SearchUsageStats(Map<String, Long> queries, Map<String, Long> rescorers, Map<String, Long> sections, Map<String, Long> retrievers, ExtendedSearchUsageStats extendedSearchUsageStats, long totalSearchCount) {
        this.totalSearchCount = totalSearchCount;
        this.queries = queries;
        this.sections = sections;
        this.rescorers = rescorers;
        this.retrievers = retrievers;
        this.extendedSearchUsageStats = extendedSearchUsageStats;
    }

    public SearchUsageStats(StreamInput in) throws IOException {
        this.queries = in.readMap(StreamInput::readLong);
        this.sections = in.readMap(StreamInput::readLong);
        this.totalSearchCount = in.readVLong();
        this.rescorers = in.readMap(StreamInput::readLong);
        this.retrievers = in.readMap(StreamInput::readLong);
        this.extendedSearchUsageStats = in.getTransportVersion().supports(EXTENDED_SEARCH_USAGE_TELEMETRY) ? new ExtendedSearchUsageStats(in) : ExtendedSearchUsageStats.EMPTY;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.queries, StreamOutput::writeLong);
        out.writeMap(this.sections, StreamOutput::writeLong);
        out.writeVLong(this.totalSearchCount);
        out.writeMap(this.rescorers, StreamOutput::writeLong);
        out.writeMap(this.retrievers, StreamOutput::writeLong);
        if (out.getTransportVersion().supports(EXTENDED_SEARCH_USAGE_TELEMETRY)) {
            this.extendedSearchUsageStats.writeTo(out);
        }
    }

    public void add(SearchUsageStats stats) {
        stats.queries.forEach((query, count) -> this.queries.merge((String)query, (Long)count, Long::sum));
        stats.rescorers.forEach((rescorer, count) -> this.rescorers.merge((String)rescorer, (Long)count, Long::sum));
        stats.sections.forEach((query, count) -> this.sections.merge((String)query, (Long)count, Long::sum));
        stats.retrievers.forEach((query, count) -> this.retrievers.merge((String)query, (Long)count, Long::sum));
        this.extendedSearchUsageStats.merge(stats.extendedSearchUsageStats);
        this.totalSearchCount += stats.totalSearchCount;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("search");
        builder.field("total", this.totalSearchCount);
        builder.field("queries");
        builder.map(this.queries);
        builder.field("rescorers");
        builder.map(this.rescorers);
        builder.field("sections");
        builder.map(this.sections);
        builder.field("retrievers");
        builder.map(this.retrievers);
        builder.field("extended");
        this.extendedSearchUsageStats.toXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public Map<String, Long> getQueryUsage() {
        return Collections.unmodifiableMap(this.queries);
    }

    public Map<String, Long> getRescorerUsage() {
        return Collections.unmodifiableMap(this.rescorers);
    }

    public Map<String, Long> getSectionsUsage() {
        return Collections.unmodifiableMap(this.sections);
    }

    public Map<String, Long> getRetrieversUsage() {
        return Collections.unmodifiableMap(this.retrievers);
    }

    public ExtendedSearchUsageStats getExtendedSearchUsage() {
        return this.extendedSearchUsageStats;
    }

    public long getTotalSearchCount() {
        return this.totalSearchCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchUsageStats that = (SearchUsageStats)o;
        return this.totalSearchCount == that.totalSearchCount && this.queries.equals(that.queries) && this.rescorers.equals(that.rescorers) && this.sections.equals(that.sections) && this.retrievers.equals(that.retrievers) && this.extendedSearchUsageStats.equals(that.extendedSearchUsageStats);
    }

    public int hashCode() {
        return Objects.hash(this.totalSearchCount, this.queries, this.rescorers, this.sections, this.retrievers, this.extendedSearchUsageStats);
    }

    public String toString() {
        return Strings.toString(this, true, true);
    }
}

