/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.stats;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.admin.cluster.stats.ExtendedSearchUsageMetric;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class ExtendedSearchUsageStats
implements Writeable,
ToXContent {
    private final Map<String, Map<String, ExtendedSearchUsageMetric<?>>> categorizedExtendedData;
    public static final ExtendedSearchUsageStats EMPTY = new ExtendedSearchUsageStats();

    public ExtendedSearchUsageStats() {
        this.categorizedExtendedData = new HashMap();
    }

    public ExtendedSearchUsageStats(Map<String, Map<String, ExtendedSearchUsageMetric<?>>> categorizedExtendedData) {
        this.categorizedExtendedData = categorizedExtendedData;
    }

    public ExtendedSearchUsageStats(StreamInput in) throws IOException {
        this.categorizedExtendedData = in.readMap(StreamInput::readString, i -> i.readMap(StreamInput::readString, p -> p.readNamedWriteable(ExtendedSearchUsageMetric.class)));
    }

    public Map<String, Map<String, ExtendedSearchUsageMetric<?>>> getCategorizedExtendedData() {
        return Collections.unmodifiableMap(this.categorizedExtendedData);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.categorizedExtendedData, StreamOutput::writeString, (o, v) -> o.writeMap(v, StreamOutput::writeString, (p, q) -> out.writeNamedWriteable((NamedWriteable)q)));
    }

    public void merge(ExtendedSearchUsageStats other) {
        other.categorizedExtendedData.forEach((key, otherMap) -> this.categorizedExtendedData.merge((String)key, (Map<String, ExtendedSearchUsageMetric<?>>)otherMap, (existingMap, newMap) -> {
            HashMap mergedMap = new HashMap(existingMap);
            newMap.forEach((innerKey, innerValue) -> mergedMap.merge(innerKey, innerValue, (existing, incoming) -> existing.merge((ExtendedSearchUsageMetric<?>)incoming)));
            return mergedMap;
        }));
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        for (String category : this.categorizedExtendedData.keySet()) {
            builder.startObject(category);
            Map<String, ExtendedSearchUsageMetric<?>> names = this.categorizedExtendedData.get(category);
            for (String name : names.keySet()) {
                builder.startObject(name);
                names.get(name).toXContent(builder, params);
                builder.endObject();
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtendedSearchUsageStats that = (ExtendedSearchUsageStats)o;
        return Objects.equals(this.categorizedExtendedData, that.categorizedExtendedData);
    }

    public int hashCode() {
        return Objects.hash(this.categorizedExtendedData);
    }

    public String toString() {
        return Strings.toString(this, true, true);
    }
}

