/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.stats;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.admin.indices.stats.CommonStatsFlags;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public class NodesStatsRequestParameters
implements Writeable {
    private CommonStatsFlags indices = new CommonStatsFlags(new CommonStatsFlags.Flag[0]);
    private final EnumSet<Metric> requestedMetrics;
    private boolean includeShardsStats = true;

    public NodesStatsRequestParameters() {
        this.requestedMetrics = EnumSet.noneOf(Metric.class);
    }

    public NodesStatsRequestParameters(StreamInput in) throws IOException {
        this.indices = new CommonStatsFlags(in);
        this.requestedMetrics = in.readEnumSet(Metric.class);
        this.includeShardsStats = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.indices.writeTo(out);
        out.writeEnumSet(this.requestedMetrics);
        out.writeBoolean(this.includeShardsStats);
    }

    public CommonStatsFlags indices() {
        return this.indices;
    }

    public void setIndices(CommonStatsFlags indices) {
        this.indices = indices;
    }

    public EnumSet<Metric> requestedMetrics() {
        return this.requestedMetrics;
    }

    public boolean includeShardsStats() {
        return this.includeShardsStats;
    }

    public void setIncludeShardsStats(boolean includeShardsStats) {
        this.includeShardsStats = includeShardsStats;
    }

    public static final class Metric
    extends Enum<Metric> {
        public static final /* enum */ Metric OS = new Metric("os");
        public static final /* enum */ Metric PROCESS = new Metric("process");
        public static final /* enum */ Metric JVM = new Metric("jvm");
        public static final /* enum */ Metric THREAD_POOL = new Metric("thread_pool");
        public static final /* enum */ Metric FS = new Metric("fs");
        public static final /* enum */ Metric TRANSPORT = new Metric("transport");
        public static final /* enum */ Metric HTTP = new Metric("http");
        public static final /* enum */ Metric BREAKER = new Metric("breaker");
        public static final /* enum */ Metric SCRIPT = new Metric("script");
        public static final /* enum */ Metric DISCOVERY = new Metric("discovery");
        public static final /* enum */ Metric INGEST = new Metric("ingest");
        public static final /* enum */ Metric ADAPTIVE_SELECTION = new Metric("adaptive_selection");
        public static final /* enum */ Metric SCRIPT_CACHE = new Metric("script_cache");
        public static final /* enum */ Metric INDEXING_PRESSURE = new Metric("indexing_pressure");
        public static final /* enum */ Metric REPOSITORIES = new Metric("repositories");
        public static final /* enum */ Metric ALLOCATIONS = new Metric("allocations");
        public static final Set<Metric> ALL;
        public static final Set<String> ALL_NAMES;
        public static final Map<String, Metric> NAMES_MAP;
        private final String metricName;
        private static final /* synthetic */ Metric[] $VALUES;

        public static Metric[] values() {
            return (Metric[])$VALUES.clone();
        }

        public static Metric valueOf(String name) {
            return Enum.valueOf(Metric.class, name);
        }

        private Metric(String metricName) {
            this.metricName = metricName;
        }

        public static boolean isValid(String name) {
            return NAMES_MAP.containsKey(name);
        }

        public static Metric get(String name) {
            Metric metric = NAMES_MAP.get(name);
            assert (metric != null);
            return metric;
        }

        public String metricName() {
            return this.metricName;
        }

        public String toString() {
            return this.metricName;
        }

        private static /* synthetic */ Metric[] $values() {
            return new Metric[]{OS, PROCESS, JVM, THREAD_POOL, FS, TRANSPORT, HTTP, BREAKER, SCRIPT, DISCOVERY, INGEST, ADAPTIVE_SELECTION, SCRIPT_CACHE, INDEXING_PRESSURE, REPOSITORIES, ALLOCATIONS};
        }

        static {
            $VALUES = Metric.$values();
            ALL = Collections.unmodifiableSet(EnumSet.allOf(Metric.class));
            ALL_NAMES = ALL.stream().map(Metric::metricName).collect(Collectors.toUnmodifiableSet());
            NAMES_MAP = ALL.stream().collect(Collectors.toUnmodifiableMap(Metric::metricName, m -> m));
        }
    }
}

