/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.reload;

import java.io.IOException;
import java.util.Arrays;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.core.CharArrays;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.transport.AbstractTransportRequest;
import org.elasticsearch.transport.LeakTracker;

public class NodesReloadSecureSettingsRequest
extends BaseNodesRequest {
    @Nullable
    private SecureString secureSettingsPassword;
    private final RefCounted refs = LeakTracker.wrap(AbstractRefCounted.of(() -> Releasables.close((Releasable)this.secureSettingsPassword)));

    public NodesReloadSecureSettingsRequest(String[] nodeIds) {
        super(nodeIds);
    }

    public void setSecureStorePassword(SecureString secureStorePassword) {
        this.secureSettingsPassword = secureStorePassword;
    }

    boolean hasPassword() {
        return this.secureSettingsPassword != null && this.secureSettingsPassword.length() > 0;
    }

    @Override
    public void incRef() {
        this.refs.incRef();
    }

    @Override
    public boolean tryIncRef() {
        return this.refs.tryIncRef();
    }

    @Override
    public boolean decRef() {
        return this.refs.decRef();
    }

    @Override
    public boolean hasReferences() {
        return this.refs.hasReferences();
    }

    NodeRequest newNodeRequest() {
        this.refs.mustIncRef();
        return new NodeRequest(this.secureSettingsPassword, this.refs);
    }

    public static class NodeRequest
    extends AbstractTransportRequest {
        @Nullable
        private final SecureString secureSettingsPassword;
        private final RefCounted refs;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        NodeRequest(StreamInput in) throws IOException {
            super(in);
            BytesReference bytesRef = in.readOptionalBytesReference();
            if (bytesRef != null) {
                byte[] bytes = BytesReference.toBytes(bytesRef);
                try {
                    this.secureSettingsPassword = new SecureString(CharArrays.utf8BytesToChars(bytes));
                    this.refs = LeakTracker.wrap(AbstractRefCounted.of(() -> Releasables.close((Releasable)this.secureSettingsPassword)));
                }
                finally {
                    Arrays.fill(bytes, (byte)0);
                }
            } else {
                this.secureSettingsPassword = null;
                this.refs = LeakTracker.wrap(AbstractRefCounted.of(() -> {}));
            }
        }

        NodeRequest(@Nullable SecureString secureSettingsPassword, RefCounted refs) {
            assert (secureSettingsPassword == null || secureSettingsPassword.getChars() != null);
            assert (refs.hasReferences());
            this.secureSettingsPassword = secureSettingsPassword;
            this.refs = refs;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            assert (this.hasReferences());
            super.writeTo(out);
            if (this.secureSettingsPassword == null) {
                out.writeOptionalBytesReference(null);
            } else {
                byte[] passwordBytes = CharArrays.toUtf8Bytes(this.secureSettingsPassword.getChars());
                try {
                    out.writeOptionalBytesReference(new BytesArray(passwordBytes));
                }
                finally {
                    Arrays.fill(passwordBytes, (byte)0);
                }
            }
        }

        boolean hasPassword() {
            assert (this.hasReferences());
            return this.secureSettingsPassword != null && this.secureSettingsPassword.length() > 0;
        }

        @Nullable
        public SecureString getSecureSettingsPassword() {
            assert (this.hasReferences());
            return this.secureSettingsPassword;
        }

        @Override
        public void incRef() {
            this.refs.incRef();
        }

        @Override
        public boolean tryIncRef() {
            return this.refs.tryIncRef();
        }

        @Override
        public boolean decRef() {
            return this.refs.decRef();
        }

        @Override
        public boolean hasReferences() {
            return this.refs.hasReferences();
        }
    }
}

