/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security.query_api_keys;

import co.elastic.clients.elasticsearch._types.aggregations.BucketAggregationBase;
import co.elastic.clients.elasticsearch._types.aggregations.Buckets;
import co.elastic.clients.elasticsearch.security.query_api_keys.ApiKeyAggregation;
import co.elastic.clients.elasticsearch.security.query_api_keys.ApiKeyAggregationVariant;
import co.elastic.clients.elasticsearch.security.query_api_keys.ApiKeyQuery;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ApiKeyFiltersAggregation
extends BucketAggregationBase
implements ApiKeyAggregationVariant,
JsonpSerializable {
    @Nullable
    private final Buckets<ApiKeyQuery> filters;
    @Nullable
    private final Boolean otherBucket;
    @Nullable
    private final String otherBucketKey;
    @Nullable
    private final Boolean keyed;
    public static final JsonpDeserializer<ApiKeyFiltersAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ApiKeyFiltersAggregation::setupApiKeyFiltersAggregationDeserializer);

    private ApiKeyFiltersAggregation(Builder builder) {
        this.filters = builder.filters;
        this.otherBucket = builder.otherBucket;
        this.otherBucketKey = builder.otherBucketKey;
        this.keyed = builder.keyed;
    }

    public static ApiKeyFiltersAggregation of(Function<Builder, ObjectBuilder<ApiKeyFiltersAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public ApiKeyAggregation.Kind _apiKeyAggregationKind() {
        return ApiKeyAggregation.Kind.Filters;
    }

    @Nullable
    public final Buckets<ApiKeyQuery> filters() {
        return this.filters;
    }

    @Nullable
    public final Boolean otherBucket() {
        return this.otherBucket;
    }

    @Nullable
    public final String otherBucketKey() {
        return this.otherBucketKey;
    }

    @Nullable
    public final Boolean keyed() {
        return this.keyed;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.filters != null) {
            generator.writeKey("filters");
            this.filters.serialize(generator, mapper);
        }
        if (this.otherBucket != null) {
            generator.writeKey("other_bucket");
            generator.write(this.otherBucket);
        }
        if (this.otherBucketKey != null) {
            generator.writeKey("other_bucket_key");
            generator.write(this.otherBucketKey);
        }
        if (this.keyed != null) {
            generator.writeKey("keyed");
            generator.write(this.keyed);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupApiKeyFiltersAggregationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::filters, Buckets.createBucketsDeserializer(ApiKeyQuery._DESERIALIZER), "filters");
        op.add(Builder::otherBucket, JsonpDeserializer.booleanDeserializer(), "other_bucket");
        op.add(Builder::otherBucketKey, JsonpDeserializer.stringDeserializer(), "other_bucket_key");
        op.add(Builder::keyed, JsonpDeserializer.booleanDeserializer(), "keyed");
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ApiKeyFiltersAggregation> {
        @Nullable
        private Buckets<ApiKeyQuery> filters;
        @Nullable
        private Boolean otherBucket;
        @Nullable
        private String otherBucketKey;
        @Nullable
        private Boolean keyed;

        public final Builder filters(@Nullable Buckets<ApiKeyQuery> value) {
            this.filters = value;
            return this;
        }

        public final Builder filters(Function<Buckets.Builder<ApiKeyQuery>, ObjectBuilder<Buckets<ApiKeyQuery>>> fn) {
            return this.filters(fn.apply(new Buckets.Builder()).build());
        }

        public final Builder otherBucket(@Nullable Boolean value) {
            this.otherBucket = value;
            return this;
        }

        public final Builder otherBucketKey(@Nullable String value) {
            this.otherBucketKey = value;
            return this;
        }

        public final Builder keyed(@Nullable Boolean value) {
            this.keyed = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ApiKeyFiltersAggregation build() {
            this._checkSingleUse();
            return new ApiKeyFiltersAggregation(this);
        }
    }
}

