/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.put_data_stream_settings;

import co.elastic.clients.elasticsearch.indices.put_data_stream_settings.DataStreamSettingsError;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class IndexSettingResults
implements JsonpSerializable {
    private final List<String> appliedToDataStreamOnly;
    private final List<String> appliedToDataStreamAndBackingIndices;
    private final List<DataStreamSettingsError> errors;
    public static final JsonpDeserializer<IndexSettingResults> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexSettingResults::setupIndexSettingResultsDeserializer);

    private IndexSettingResults(Builder builder) {
        this.appliedToDataStreamOnly = ApiTypeHelper.unmodifiableRequired(builder.appliedToDataStreamOnly, (Object)this, "appliedToDataStreamOnly");
        this.appliedToDataStreamAndBackingIndices = ApiTypeHelper.unmodifiableRequired(builder.appliedToDataStreamAndBackingIndices, (Object)this, "appliedToDataStreamAndBackingIndices");
        this.errors = ApiTypeHelper.unmodifiable(builder.errors);
    }

    public static IndexSettingResults of(Function<Builder, ObjectBuilder<IndexSettingResults>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> appliedToDataStreamOnly() {
        return this.appliedToDataStreamOnly;
    }

    public final List<String> appliedToDataStreamAndBackingIndices() {
        return this.appliedToDataStreamAndBackingIndices;
    }

    public final List<DataStreamSettingsError> errors() {
        return this.errors;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.appliedToDataStreamOnly)) {
            generator.writeKey("applied_to_data_stream_only");
            generator.writeStartArray();
            for (String string : this.appliedToDataStreamOnly) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.appliedToDataStreamAndBackingIndices)) {
            generator.writeKey("applied_to_data_stream_and_backing_indices");
            generator.writeStartArray();
            for (String string : this.appliedToDataStreamAndBackingIndices) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.errors)) {
            generator.writeKey("errors");
            generator.writeStartArray();
            for (DataStreamSettingsError dataStreamSettingsError : this.errors) {
                dataStreamSettingsError.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupIndexSettingResultsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::appliedToDataStreamOnly, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "applied_to_data_stream_only");
        op.add(Builder::appliedToDataStreamAndBackingIndices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "applied_to_data_stream_and_backing_indices");
        op.add(Builder::errors, JsonpDeserializer.arrayDeserializer(DataStreamSettingsError._DESERIALIZER), "errors");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<IndexSettingResults> {
        private List<String> appliedToDataStreamOnly;
        private List<String> appliedToDataStreamAndBackingIndices;
        @Nullable
        private List<DataStreamSettingsError> errors;

        public final Builder appliedToDataStreamOnly(List<String> list) {
            this.appliedToDataStreamOnly = Builder._listAddAll(this.appliedToDataStreamOnly, list);
            return this;
        }

        public final Builder appliedToDataStreamOnly(String value, String ... values) {
            this.appliedToDataStreamOnly = Builder._listAdd(this.appliedToDataStreamOnly, value, values);
            return this;
        }

        public final Builder appliedToDataStreamAndBackingIndices(List<String> list) {
            this.appliedToDataStreamAndBackingIndices = Builder._listAddAll(this.appliedToDataStreamAndBackingIndices, list);
            return this;
        }

        public final Builder appliedToDataStreamAndBackingIndices(String value, String ... values) {
            this.appliedToDataStreamAndBackingIndices = Builder._listAdd(this.appliedToDataStreamAndBackingIndices, value, values);
            return this;
        }

        public final Builder errors(List<DataStreamSettingsError> list) {
            this.errors = Builder._listAddAll(this.errors, list);
            return this;
        }

        public final Builder errors(DataStreamSettingsError value, DataStreamSettingsError ... values) {
            this.errors = Builder._listAdd(this.errors, value, values);
            return this;
        }

        public final Builder errors(Function<DataStreamSettingsError.Builder, ObjectBuilder<DataStreamSettingsError>> fn) {
            return this.errors(fn.apply(new DataStreamSettingsError.Builder()).build(), new DataStreamSettingsError[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IndexSettingResults build() {
            this._checkSingleUse();
            return new IndexSettingResults(this);
        }
    }
}

