/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch.indices.FailureStoreLifecycle;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DataStreamFailureStore
implements JsonpSerializable {
    @Nullable
    private final Boolean enabled;
    @Nullable
    private final FailureStoreLifecycle lifecycle;
    public static final JsonpDeserializer<DataStreamFailureStore> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataStreamFailureStore::setupDataStreamFailureStoreDeserializer);

    private DataStreamFailureStore(Builder builder) {
        this.enabled = builder.enabled;
        this.lifecycle = builder.lifecycle;
    }

    public static DataStreamFailureStore of(Function<Builder, ObjectBuilder<DataStreamFailureStore>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean enabled() {
        return this.enabled;
    }

    @Nullable
    public final FailureStoreLifecycle lifecycle() {
        return this.lifecycle;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.enabled != null) {
            generator.writeKey("enabled");
            generator.write(this.enabled);
        }
        if (this.lifecycle != null) {
            generator.writeKey("lifecycle");
            this.lifecycle.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupDataStreamFailureStoreDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::enabled, JsonpDeserializer.booleanDeserializer(), "enabled");
        op.add(Builder::lifecycle, FailureStoreLifecycle._DESERIALIZER, "lifecycle");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DataStreamFailureStore> {
        @Nullable
        private Boolean enabled;
        @Nullable
        private FailureStoreLifecycle lifecycle;

        public final Builder enabled(@Nullable Boolean value) {
            this.enabled = value;
            return this;
        }

        public final Builder lifecycle(@Nullable FailureStoreLifecycle value) {
            this.lifecycle = value;
            return this;
        }

        public final Builder lifecycle(Function<FailureStoreLifecycle.Builder, ObjectBuilder<FailureStoreLifecycle>> fn) {
            return this.lifecycle(fn.apply(new FailureStoreLifecycle.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataStreamFailureStore build() {
            this._checkSingleUse();
            return new DataStreamFailureStore(this);
        }
    }
}

