/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ilm;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ForceMergeAction
implements JsonpSerializable {
    private final int maxNumSegments;
    @Nullable
    private final String indexCodec;
    public static final JsonpDeserializer<ForceMergeAction> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ForceMergeAction::setupForceMergeActionDeserializer);

    private ForceMergeAction(Builder builder) {
        this.maxNumSegments = ApiTypeHelper.requireNonNull(builder.maxNumSegments, (Object)this, "maxNumSegments", 0);
        this.indexCodec = builder.indexCodec;
    }

    public static ForceMergeAction of(Function<Builder, ObjectBuilder<ForceMergeAction>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int maxNumSegments() {
        return this.maxNumSegments;
    }

    @Nullable
    public final String indexCodec() {
        return this.indexCodec;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("max_num_segments");
        generator.write(this.maxNumSegments);
        if (this.indexCodec != null) {
            generator.writeKey("index_codec");
            generator.write(this.indexCodec);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupForceMergeActionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::maxNumSegments, JsonpDeserializer.integerDeserializer(), "max_num_segments");
        op.add(Builder::indexCodec, JsonpDeserializer.stringDeserializer(), "index_codec");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ForceMergeAction> {
        private Integer maxNumSegments;
        @Nullable
        private String indexCodec;

        public final Builder maxNumSegments(int value) {
            this.maxNumSegments = value;
            return this;
        }

        public final Builder indexCodec(@Nullable String value) {
            this.indexCodec = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ForceMergeAction build() {
            this._checkSingleUse();
            return new ForceMergeAction(this);
        }
    }
}

