/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class FieldTypes
implements JsonpSerializable {
    private final String name;
    private final int count;
    private final int indexCount;
    @Nullable
    private final Integer indexedVectorCount;
    @Nullable
    private final Integer indexedVectorDimMax;
    @Nullable
    private final Integer indexedVectorDimMin;
    @Nullable
    private final Integer scriptCount;
    private final Map<String, Integer> vectorIndexTypeCount;
    private final Map<String, Integer> vectorSimilarityTypeCount;
    private final Map<String, Integer> vectorElementTypeCount;
    public static final JsonpDeserializer<FieldTypes> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FieldTypes::setupFieldTypesDeserializer);

    private FieldTypes(Builder builder) {
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.count = ApiTypeHelper.requireNonNull(builder.count, (Object)this, "count", 0);
        this.indexCount = ApiTypeHelper.requireNonNull(builder.indexCount, (Object)this, "indexCount", 0);
        this.indexedVectorCount = builder.indexedVectorCount;
        this.indexedVectorDimMax = builder.indexedVectorDimMax;
        this.indexedVectorDimMin = builder.indexedVectorDimMin;
        this.scriptCount = builder.scriptCount;
        this.vectorIndexTypeCount = ApiTypeHelper.unmodifiable(builder.vectorIndexTypeCount);
        this.vectorSimilarityTypeCount = ApiTypeHelper.unmodifiable(builder.vectorSimilarityTypeCount);
        this.vectorElementTypeCount = ApiTypeHelper.unmodifiable(builder.vectorElementTypeCount);
    }

    public static FieldTypes of(Function<Builder, ObjectBuilder<FieldTypes>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String name() {
        return this.name;
    }

    public final int count() {
        return this.count;
    }

    public final int indexCount() {
        return this.indexCount;
    }

    @Nullable
    public final Integer indexedVectorCount() {
        return this.indexedVectorCount;
    }

    @Nullable
    public final Integer indexedVectorDimMax() {
        return this.indexedVectorDimMax;
    }

    @Nullable
    public final Integer indexedVectorDimMin() {
        return this.indexedVectorDimMin;
    }

    @Nullable
    public final Integer scriptCount() {
        return this.scriptCount;
    }

    public final Map<String, Integer> vectorIndexTypeCount() {
        return this.vectorIndexTypeCount;
    }

    public final Map<String, Integer> vectorSimilarityTypeCount() {
        return this.vectorSimilarityTypeCount;
    }

    public final Map<String, Integer> vectorElementTypeCount() {
        return this.vectorElementTypeCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("index_count");
        generator.write(this.indexCount);
        if (this.indexedVectorCount != null) {
            generator.writeKey("indexed_vector_count");
            generator.write(this.indexedVectorCount);
        }
        if (this.indexedVectorDimMax != null) {
            generator.writeKey("indexed_vector_dim_max");
            generator.write(this.indexedVectorDimMax);
        }
        if (this.indexedVectorDimMin != null) {
            generator.writeKey("indexed_vector_dim_min");
            generator.write(this.indexedVectorDimMin);
        }
        if (this.scriptCount != null) {
            generator.writeKey("script_count");
            generator.write(this.scriptCount);
        }
        if (ApiTypeHelper.isDefined(this.vectorIndexTypeCount)) {
            generator.writeKey("vector_index_type_count");
            generator.writeStartObject();
            for (Map.Entry<String, Integer> item0 : this.vectorIndexTypeCount.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.vectorSimilarityTypeCount)) {
            generator.writeKey("vector_similarity_type_count");
            generator.writeStartObject();
            for (Map.Entry<String, Integer> item0 : this.vectorSimilarityTypeCount.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.vectorElementTypeCount)) {
            generator.writeKey("vector_element_type_count");
            generator.writeStartObject();
            for (Map.Entry<String, Integer> item0 : this.vectorElementTypeCount.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupFieldTypesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::count, JsonpDeserializer.integerDeserializer(), "count");
        op.add(Builder::indexCount, JsonpDeserializer.integerDeserializer(), "index_count");
        op.add(Builder::indexedVectorCount, JsonpDeserializer.integerDeserializer(), "indexed_vector_count");
        op.add(Builder::indexedVectorDimMax, JsonpDeserializer.integerDeserializer(), "indexed_vector_dim_max");
        op.add(Builder::indexedVectorDimMin, JsonpDeserializer.integerDeserializer(), "indexed_vector_dim_min");
        op.add(Builder::scriptCount, JsonpDeserializer.integerDeserializer(), "script_count");
        op.add(Builder::vectorIndexTypeCount, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.integerDeserializer()), "vector_index_type_count");
        op.add(Builder::vectorSimilarityTypeCount, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.integerDeserializer()), "vector_similarity_type_count");
        op.add(Builder::vectorElementTypeCount, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.integerDeserializer()), "vector_element_type_count");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<FieldTypes> {
        private String name;
        private Integer count;
        private Integer indexCount;
        @Nullable
        private Integer indexedVectorCount;
        @Nullable
        private Integer indexedVectorDimMax;
        @Nullable
        private Integer indexedVectorDimMin;
        @Nullable
        private Integer scriptCount;
        @Nullable
        private Map<String, Integer> vectorIndexTypeCount;
        @Nullable
        private Map<String, Integer> vectorSimilarityTypeCount;
        @Nullable
        private Map<String, Integer> vectorElementTypeCount;

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder count(int value) {
            this.count = value;
            return this;
        }

        public final Builder indexCount(int value) {
            this.indexCount = value;
            return this;
        }

        public final Builder indexedVectorCount(@Nullable Integer value) {
            this.indexedVectorCount = value;
            return this;
        }

        public final Builder indexedVectorDimMax(@Nullable Integer value) {
            this.indexedVectorDimMax = value;
            return this;
        }

        public final Builder indexedVectorDimMin(@Nullable Integer value) {
            this.indexedVectorDimMin = value;
            return this;
        }

        public final Builder scriptCount(@Nullable Integer value) {
            this.scriptCount = value;
            return this;
        }

        public final Builder vectorIndexTypeCount(Map<String, Integer> map) {
            this.vectorIndexTypeCount = Builder._mapPutAll(this.vectorIndexTypeCount, map);
            return this;
        }

        public final Builder vectorIndexTypeCount(String key, Integer value) {
            this.vectorIndexTypeCount = Builder._mapPut(this.vectorIndexTypeCount, key, value);
            return this;
        }

        public final Builder vectorSimilarityTypeCount(Map<String, Integer> map) {
            this.vectorSimilarityTypeCount = Builder._mapPutAll(this.vectorSimilarityTypeCount, map);
            return this;
        }

        public final Builder vectorSimilarityTypeCount(String key, Integer value) {
            this.vectorSimilarityTypeCount = Builder._mapPut(this.vectorSimilarityTypeCount, key, value);
            return this;
        }

        public final Builder vectorElementTypeCount(Map<String, Integer> map) {
            this.vectorElementTypeCount = Builder._mapPutAll(this.vectorElementTypeCount, map);
            return this;
        }

        public final Builder vectorElementTypeCount(String key, Integer value) {
            this.vectorElementTypeCount = Builder._mapPut(this.vectorElementTypeCount, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FieldTypes build() {
            this._checkSingleUse();
            return new FieldTypes(this);
        }
    }
}

