/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.BucketAggregationBase;
import co.elastic.clients.elasticsearch._types.aggregations.MinimumInterval;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class AutoDateHistogramAggregation
extends BucketAggregationBase
implements AggregationVariant,
JsonpSerializable {
    @Nullable
    private final Integer buckets;
    @Nullable
    private final String field;
    @Nullable
    private final String format;
    @Nullable
    private final MinimumInterval minimumInterval;
    @Nullable
    private final DateTime missing;
    @Nullable
    private final String offset;
    private final Map<String, JsonData> params;
    @Nullable
    private final Script script;
    @Nullable
    private final String timeZone;
    public static final JsonpDeserializer<AutoDateHistogramAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AutoDateHistogramAggregation::setupAutoDateHistogramAggregationDeserializer);

    private AutoDateHistogramAggregation(Builder builder) {
        this.buckets = builder.buckets;
        this.field = builder.field;
        this.format = builder.format;
        this.minimumInterval = builder.minimumInterval;
        this.missing = builder.missing;
        this.offset = builder.offset;
        this.params = ApiTypeHelper.unmodifiable(builder.params);
        this.script = builder.script;
        this.timeZone = builder.timeZone;
    }

    public static AutoDateHistogramAggregation of(Function<Builder, ObjectBuilder<AutoDateHistogramAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.AutoDateHistogram;
    }

    @Nullable
    public final Integer buckets() {
        return this.buckets;
    }

    @Nullable
    public final String field() {
        return this.field;
    }

    @Nullable
    public final String format() {
        return this.format;
    }

    @Nullable
    public final MinimumInterval minimumInterval() {
        return this.minimumInterval;
    }

    @Nullable
    public final DateTime missing() {
        return this.missing;
    }

    @Nullable
    public final String offset() {
        return this.offset;
    }

    public final Map<String, JsonData> params() {
        return this.params;
    }

    @Nullable
    public final Script script() {
        return this.script;
    }

    @Nullable
    public final String timeZone() {
        return this.timeZone;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.buckets != null) {
            generator.writeKey("buckets");
            generator.write(this.buckets);
        }
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.format != null) {
            generator.writeKey("format");
            generator.write(this.format);
        }
        if (this.minimumInterval != null) {
            generator.writeKey("minimum_interval");
            this.minimumInterval.serialize(generator, mapper);
        }
        if (this.missing != null) {
            generator.writeKey("missing");
            this.missing.serialize(generator, mapper);
        }
        if (this.offset != null) {
            generator.writeKey("offset");
            generator.write(this.offset);
        }
        if (ApiTypeHelper.isDefined(this.params)) {
            generator.writeKey("params");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.params.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
        if (this.timeZone != null) {
            generator.writeKey("time_zone");
            generator.write(this.timeZone);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupAutoDateHistogramAggregationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::buckets, JsonpDeserializer.integerDeserializer(), "buckets");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::format, JsonpDeserializer.stringDeserializer(), "format");
        op.add(Builder::minimumInterval, MinimumInterval._DESERIALIZER, "minimum_interval");
        op.add(Builder::missing, DateTime._DESERIALIZER, "missing");
        op.add(Builder::offset, JsonpDeserializer.stringDeserializer(), "offset");
        op.add(Builder::params, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "params");
        op.add(Builder::script, Script._DESERIALIZER, "script");
        op.add(Builder::timeZone, JsonpDeserializer.stringDeserializer(), "time_zone");
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<AutoDateHistogramAggregation> {
        @Nullable
        private Integer buckets;
        @Nullable
        private String field;
        @Nullable
        private String format;
        @Nullable
        private MinimumInterval minimumInterval;
        @Nullable
        private DateTime missing;
        @Nullable
        private String offset;
        @Nullable
        private Map<String, JsonData> params;
        @Nullable
        private Script script;
        @Nullable
        private String timeZone;

        public final Builder buckets(@Nullable Integer value) {
            this.buckets = value;
            return this;
        }

        public final Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        public final Builder format(@Nullable String value) {
            this.format = value;
            return this;
        }

        public final Builder minimumInterval(@Nullable MinimumInterval value) {
            this.minimumInterval = value;
            return this;
        }

        public final Builder missing(@Nullable DateTime value) {
            this.missing = value;
            return this;
        }

        public final Builder offset(@Nullable String value) {
            this.offset = value;
            return this;
        }

        public final Builder params(Map<String, JsonData> map) {
            this.params = Builder._mapPutAll(this.params, map);
            return this;
        }

        public final Builder params(String key, JsonData value) {
            this.params = Builder._mapPut(this.params, key, value);
            return this;
        }

        public final Builder script(@Nullable Script value) {
            this.script = value;
            return this;
        }

        public final Builder script(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.script(fn.apply(new Script.Builder()).build());
        }

        public final Builder timeZone(@Nullable String value) {
            this.timeZone = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AutoDateHistogramAggregation build() {
            this._checkSingleUse();
            return new AutoDateHistogramAggregation(this);
        }
    }
}

