/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.FormatableHashtable;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecRowBuilder;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.transaction.TransactionControl;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.types.VariableSizeDataValue;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;
import org.apache.derby.impl.sql.execute.UpdatableVTIConstantAction;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;
import org.apache.derby.vti.AwareVTI;
import org.apache.derby.vti.DeferModification;
import org.apache.derby.vti.IFastPath;
import org.apache.derby.vti.IQualifyable;
import org.apache.derby.vti.Pushable;
import org.apache.derby.vti.RestrictedVTI;
import org.apache.derby.vti.Restriction;
import org.apache.derby.vti.VTIContext;
import org.apache.derby.vti.VTIEnvironment;
import org.w3c.dom.Element;

class VTIResultSet
extends NoPutResultSetImpl
implements CursorResultSet,
VTIEnvironment {
    public int rowsReturned;
    public String javaClassName;
    private GeneratedMethod constructor;
    private PreparedStatement userPS;
    private ResultSet userVTI;
    private final ExecRow allocatedRow;
    private FormatableBitSet referencedColumns;
    private boolean version2;
    private boolean reuseablePs;
    private boolean isTarget;
    private final FormatableHashtable compileTimeConstants;
    private boolean pushedProjection;
    private IFastPath fastPath;
    private Qualifier[][] pushedQualifiers;
    private boolean[] runtimeNullableColumn;
    private boolean isDerbyStyleTableFunction;
    private final TypeDescriptor returnType;
    private DataTypeDescriptor[] returnColumnTypes;
    private String[] vtiProjection;
    private Restriction vtiRestriction;
    private String vtiSchema;
    private String vtiName;
    private int scanIsolationLevel = 0;

    VTIResultSet(Activation activation, int row, int resultSetNumber, GeneratedMethod constructor, String javaClassName, Qualifier[][] pushedQualifiers, int erdNumber, boolean version2, boolean reuseablePs, int ctcNumber, boolean isTarget, int scanIsolationLevel, double optimizerEstimatedRowCount, double optimizerEstimatedCost, boolean isDerbyStyleTableFunction, int returnTypeNumber, int vtiProjectionNumber, int vtiRestrictionNumber, String vtiSchema, String vtiName) throws StandardException {
        super(activation, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.constructor = constructor;
        this.javaClassName = javaClassName;
        this.version2 = version2;
        this.reuseablePs = reuseablePs;
        this.isTarget = isTarget;
        this.pushedQualifiers = pushedQualifiers;
        this.scanIsolationLevel = scanIsolationLevel;
        this.isDerbyStyleTableFunction = isDerbyStyleTableFunction;
        this.vtiSchema = vtiSchema;
        this.vtiName = vtiName;
        ExecPreparedStatement ps = activation.getPreparedStatement();
        this.allocatedRow = ((ExecRowBuilder)ps.getSavedObject(row)).build(activation.getExecutionFactory());
        this.returnType = returnTypeNumber == -1 ? null : (TypeDescriptor)activation.getPreparedStatement().getSavedObject(returnTypeNumber);
        this.vtiProjection = vtiProjectionNumber == -1 ? null : (String[])activation.getPreparedStatement().getSavedObject(vtiProjectionNumber);
        Restriction restriction = this.vtiRestriction = vtiRestrictionNumber == -1 ? null : (Restriction)activation.getPreparedStatement().getSavedObject(vtiRestrictionNumber);
        if (erdNumber != -1) {
            this.referencedColumns = (FormatableBitSet)activation.getPreparedStatement().getSavedObject(erdNumber);
        }
        this.compileTimeConstants = (FormatableHashtable)activation.getPreparedStatement().getSavedObject(ctcNumber);
        SanityManager.ASSERT((this.compileTimeConstants != null ? 1 : 0) != 0, (String)"compileTimeConstants is null");
        this.recordConstructorTime();
    }

    @Override
    public void openCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        SanityManager.ASSERT((!this.isOpen ? 1 : 0) != 0, (String)"VTIResultSet already open");
        this.isOpen = true;
        ++this.numOpens;
        try {
            if (this.version2) {
                this.userPS = (PreparedStatement)this.constructor.invoke(this.activation);
                if (this.userPS instanceof Pushable) {
                    Pushable p = (Pushable)((Object)this.userPS);
                    if (this.referencedColumns != null) {
                        this.pushedProjection = p.pushProjection(this, this.getProjectedColList());
                    }
                }
                if (this.userPS instanceof IQualifyable) {
                    IQualifyable q = (IQualifyable)((Object)this.userPS);
                    q.setQualifiers(this, this.pushedQualifiers);
                }
                IFastPath iFastPath = this.fastPath = this.userPS instanceof IFastPath ? (IFastPath)((Object)this.userPS) : null;
                if (this.isTarget && this.userPS instanceof DeferModification && this.activation.getConstantAction() instanceof UpdatableVTIConstantAction) {
                    UpdatableVTIConstantAction constants = (UpdatableVTIConstantAction)this.activation.getConstantAction();
                    ((DeferModification)((Object)this.userPS)).modificationNotify(constants.statementType, constants.deferred);
                }
                if (this.fastPath == null || !this.fastPath.executeAsFastPath()) {
                    this.userVTI = this.userPS.executeQuery();
                }
                if (this.isTarget) {
                    this.activation.setTargetVTI(this.userVTI);
                }
            } else {
                this.userVTI = (ResultSet)this.constructor.invoke(this.activation);
                if (this.userVTI instanceof RestrictedVTI) {
                    RestrictedVTI restrictedVTI = (RestrictedVTI)((Object)this.userVTI);
                    restrictedVTI.initScan(this.vtiProjection, this.cloneRestriction(this.activation));
                }
                if (this.userVTI instanceof AwareVTI) {
                    AwareVTI awareVTI = (AwareVTI)((Object)this.userVTI);
                    awareVTI.setContext(new VTIContext(this.vtiSchema, this.vtiName, this.activation.getLanguageConnectionContext().getStatementContext().getStatementText()));
                }
            }
            this.setNullableColumnList();
        }
        catch (Throwable t) {
            throw StandardException.unexpectedUserException((Throwable)t);
        }
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    private Restriction cloneRestriction(Activation activation) throws StandardException {
        if (this.vtiRestriction == null) {
            return null;
        }
        return this.cloneRestriction(activation, this.vtiRestriction);
    }

    private Restriction cloneRestriction(Activation activation, Restriction original) throws StandardException {
        if (original instanceof Restriction.AND) {
            Restriction.AND and = (Restriction.AND)original;
            return new Restriction.AND(this.cloneRestriction(activation, and.getLeftChild()), this.cloneRestriction(activation, and.getRightChild()));
        }
        if (original instanceof Restriction.OR) {
            Restriction.OR or = (Restriction.OR)original;
            return new Restriction.OR(this.cloneRestriction(activation, or.getLeftChild()), this.cloneRestriction(activation, or.getRightChild()));
        }
        if (original instanceof Restriction.ColumnQualifier) {
            Object newConstant;
            Restriction.ColumnQualifier cq = (Restriction.ColumnQualifier)original;
            Object originalConstant = cq.getConstantOperand();
            if (originalConstant == null) {
                newConstant = null;
            } else if (originalConstant instanceof int[]) {
                int parameterNumber = ((int[])originalConstant)[0];
                ParameterValueSet pvs = activation.getParameterValueSet();
                newConstant = pvs.getParameter(parameterNumber).getObject();
            } else {
                newConstant = originalConstant;
            }
            return new Restriction.ColumnQualifier(cq.getColumnName(), cq.getComparisonOperator(), newConstant);
        }
        throw StandardException.newException((String)"0A000.S", (Object[])new Object[]{original.getClass().getName()});
    }

    private boolean[] setNullableColumnList() throws SQLException, StandardException {
        if (this.runtimeNullableColumn != null) {
            return this.runtimeNullableColumn;
        }
        if (this.isDerbyStyleTableFunction) {
            int count = this.getAllocatedRow().nColumns() + 1;
            this.runtimeNullableColumn = new boolean[count];
            for (int i = 0; i < count; ++i) {
                this.runtimeNullableColumn[i] = true;
            }
            return this.runtimeNullableColumn;
        }
        if (this.userVTI == null) {
            return null;
        }
        ResultSetMetaData rsmd = this.userVTI.getMetaData();
        boolean[] nullableColumn = new boolean[rsmd.getColumnCount() + 1];
        for (int i = 1; i < nullableColumn.length; ++i) {
            nullableColumn[i] = rsmd.isNullable(i) != 0;
        }
        this.runtimeNullableColumn = nullableColumn;
        return nullableColumn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void reopenCore() throws StandardException {
        if (this.reuseablePs) {
            if (this.userVTI == null) return;
            try {
                this.userVTI.close();
                this.userVTI = this.userPS.executeQuery();
                if (!this.isTarget) return;
                this.activation.setTargetVTI(this.userVTI);
                return;
            }
            catch (SQLException se) {
                throw StandardException.unexpectedUserException((Throwable)se);
            }
        } else {
            this.close();
            this.openCore();
        }
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        ExecRow result = null;
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            try {
                int action;
                if (this.userVTI == null && this.fastPath != null && (action = this.fastPath.nextRow((result = this.getAllocatedRow()).getRowArray())) != 0) {
                    if (action == -1) {
                        result = null;
                    } else if (action == 1) {
                        this.userVTI = this.userPS.executeQuery();
                    }
                }
                if (this.userVTI != null) {
                    if (!this.userVTI.next()) {
                        if (null != this.fastPath) {
                            this.fastPath.rowsDone();
                        }
                        result = null;
                    } else {
                        SQLWarning warnings;
                        result = this.getAllocatedRow();
                        this.populateFromResultSet(result);
                        if (this.fastPath != null) {
                            this.fastPath.currentRow(this.userVTI, result.getRowArray());
                        }
                        if ((warnings = this.userVTI.getWarnings()) != null) {
                            this.addWarning(warnings);
                        }
                    }
                }
            }
            catch (Throwable t) {
                throw StandardException.unexpectedUserException((Throwable)t);
            }
        }
        this.setCurrentRow(result);
        if (result != null) {
            ++this.rowsReturned;
            ++this.rowsSeen;
        }
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return result;
    }

    @Override
    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.clearCurrentRow();
            if (this.userVTI != null) {
                try {
                    this.userVTI.close();
                }
                catch (SQLException se) {
                    throw StandardException.unexpectedUserException((Throwable)se);
                }
                finally {
                    this.userVTI = null;
                }
            }
            if (this.userPS != null && !this.reuseablePs) {
                try {
                    this.userPS.close();
                }
                catch (SQLException se) {
                    throw StandardException.unexpectedUserException((Throwable)se);
                }
                finally {
                    this.userPS = null;
                }
            }
            super.close();
        } else {
            SanityManager.DEBUG((String)"CloseRepeatInfo", (String)"Close of VTIResultSet repeated");
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public void finish() throws StandardException {
        if (this.userPS != null && !this.reuseablePs) {
            try {
                this.userPS.close();
                this.userPS = null;
            }
            catch (SQLException se) {
                throw StandardException.unexpectedUserException((Throwable)se);
            }
        }
        this.finishAndRTS();
    }

    @Override
    public long getTimeSpent(int type) {
        long totTime = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        return totTime;
    }

    @Override
    public RowLocation getRowLocation() {
        SanityManager.THROWASSERT((String)"RowResultSet used in positioned update/delete");
        return null;
    }

    @Override
    public ExecRow getCurrentRow() {
        SanityManager.THROWASSERT((String)"RowResultSet used in positioned update/delete");
        return null;
    }

    GeneratedMethod getVTIConstructor() {
        return this.constructor;
    }

    boolean isReuseablePs() {
        return this.reuseablePs;
    }

    private ExecRow getAllocatedRow() throws StandardException {
        return this.allocatedRow;
    }

    private int[] getProjectedColList() {
        FormatableBitSet refs = this.referencedColumns;
        int size = refs.size();
        int arrayLen = 0;
        for (int i = 0; i < size; ++i) {
            if (!refs.isSet(i)) continue;
            ++arrayLen;
        }
        int[] colList = new int[arrayLen];
        int offset = 0;
        for (int i = 0; i < size; ++i) {
            if (!refs.isSet(i)) continue;
            colList[offset++] = i + 1;
        }
        return colList;
    }

    public void populateFromResultSet(ExecRow row) throws StandardException {
        try {
            DataTypeDescriptor[] columnTypes = null;
            if (this.isDerbyStyleTableFunction) {
                columnTypes = this.getReturnColumnTypes();
            }
            boolean[] nullableColumn = this.setNullableColumnList();
            DataValueDescriptor[] columns = row.getRowArray();
            int rsColNumber = 1;
            for (int index = 0; index < columns.length; ++index) {
                if (this.referencedColumns != null && !this.referencedColumns.get(index)) {
                    if (this.pushedProjection) continue;
                    ++rsColNumber;
                    continue;
                }
                columns[index].setValueFromResultSet(this.userVTI, rsColNumber, nullableColumn[rsColNumber]);
                ++rsColNumber;
                if (!this.isDerbyStyleTableFunction) continue;
                DataTypeDescriptor dtd = columnTypes[index];
                DataValueDescriptor dvd = columns[index];
                this.cast(dtd, dvd);
            }
        }
        catch (StandardException se) {
            throw se;
        }
        catch (Throwable t) {
            throw StandardException.unexpectedUserException((Throwable)t);
        }
    }

    @Override
    public final int getScanIsolationLevel() {
        return this.scanIsolationLevel;
    }

    @Override
    public final boolean isCompileTime() {
        return false;
    }

    @Override
    public final String getOriginalSQL() {
        return this.activation.getPreparedStatement().getSource();
    }

    @Override
    public final int getStatementIsolationLevel() {
        return TransactionControl.jdbcIsolationLevel(this.getScanIsolationLevel());
    }

    @Override
    public final void setSharedState(String key, Serializable value) {
        if (key == null) {
            return;
        }
        if (value == null) {
            this.compileTimeConstants.remove(key);
        } else {
            this.compileTimeConstants.put(key, value);
        }
    }

    @Override
    public Object getSharedState(String key) {
        if (key == null || this.compileTimeConstants == null) {
            return null;
        }
        return this.compileTimeConstants.get(key);
    }

    private DataTypeDescriptor[] getReturnColumnTypes() throws StandardException {
        if (this.returnColumnTypes == null) {
            TypeDescriptor[] columnTypes = this.returnType.getRowTypes();
            int count = columnTypes.length;
            this.returnColumnTypes = new DataTypeDescriptor[count];
            for (int i = 0; i < count; ++i) {
                this.returnColumnTypes[i] = DataTypeDescriptor.getType(columnTypes[i]);
            }
        }
        return this.returnColumnTypes;
    }

    private void cast(DataTypeDescriptor dtd, DataValueDescriptor dvd) throws StandardException {
        TypeId typeID = dtd.getTypeId();
        if (!typeID.isBlobTypeId() && !typeID.isClobTypeId()) {
            if (typeID.isLongVarcharTypeId()) {
                this.castLongvarchar(dtd, dvd);
            } else if (typeID.isLongVarbinaryTypeId()) {
                this.castLongvarbinary(dtd, dvd);
            } else if (typeID.isDecimalTypeId()) {
                this.castDecimal(dtd, dvd);
            } else {
                Object o = dvd.getObject();
                dvd.setObjectForCast(o, true, typeID.getCorrespondingJavaTypeName());
                if (typeID.variableLength()) {
                    VariableSizeDataValue vsdv = (VariableSizeDataValue)((Object)dvd);
                    int width = typeID.isNumericTypeId() ? dtd.getPrecision() : dtd.getMaximumWidth();
                    vsdv.setWidth(width, dtd.getScale(), false);
                }
            }
        }
    }

    private void castLongvarchar(DataTypeDescriptor dtd, DataValueDescriptor dvd) throws StandardException {
        if (dvd.getLength() > 32700) {
            dvd.setValue(dvd.getString().substring(0, 32700));
        }
    }

    private void castLongvarbinary(DataTypeDescriptor dtd, DataValueDescriptor dvd) throws StandardException {
        if (dvd.getLength() > 32700) {
            byte[] original = dvd.getBytes();
            byte[] result = new byte[32700];
            System.arraycopy(original, 0, result, 0, 32700);
            dvd.setValue(result);
        }
    }

    private void castDecimal(DataTypeDescriptor dtd, DataValueDescriptor dvd) throws StandardException {
        VariableSizeDataValue vsdv = (VariableSizeDataValue)((Object)dvd);
        vsdv.setWidth(dtd.getPrecision(), dtd.getScale(), false);
    }

    @Override
    public Element toXML(Element parentNode, String tag) throws Exception {
        Element myNode = super.toXML(parentNode, tag);
        myNode.setAttribute("javaClassName", this.javaClassName);
        return myNode;
    }
}

