/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.uaparser;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.logstash.uaparser.OS;

final class OSParser {
    private final List<OSPattern> patterns;

    private OSParser(List<OSPattern> patterns) {
        this.patterns = patterns;
    }

    public static OSParser fromList(List<Map<String, String>> configList) {
        ArrayList<OSPattern> configPatterns = new ArrayList<OSPattern>();
        for (Map<String, String> configMap : configList) {
            configPatterns.add(OSParser.patternFromMap(configMap));
        }
        return new OSParser(configPatterns);
    }

    public OS parse(String agentString) {
        if (agentString == null) {
            return null;
        }
        for (OSPattern p : this.patterns) {
            OS os = p.match(agentString);
            if (os == null) continue;
            return os;
        }
        return new OS("Other", null, null, null, null);
    }

    private static OSPattern patternFromMap(Map<String, String> configMap) {
        String regex = configMap.get("regex");
        if (regex == null) {
            throw new IllegalArgumentException("OS is missing regex");
        }
        return new OSPattern(Pattern.compile(regex), configMap.get("os_replacement"), configMap.get("os_v1_replacement"), configMap.get("os_v2_replacement"), configMap.get("os_v3_replacement"));
    }

    private static final class OSPattern {
        private static final Pattern FIRST_PATTERN = Pattern.compile("(" + Pattern.quote("$1") + ")");
        private final Matcher matcher;
        private final String osReplacement;
        private final String v1Replacement;
        private final String v2Replacement;
        private final String v3Replacement;

        OSPattern(Pattern pattern, String osReplacement, String v1Replacement, String v2Replacement, String v3Replacement) {
            this.matcher = pattern.matcher("");
            this.osReplacement = osReplacement;
            this.v1Replacement = v1Replacement;
            this.v2Replacement = v2Replacement;
            this.v3Replacement = v3Replacement;
        }

        public synchronized OS match(String agentString) {
            this.matcher.reset(agentString);
            if (!this.matcher.find()) {
                return null;
            }
            int groupCount = this.matcher.groupCount();
            String family = null;
            if (this.osReplacement != null) {
                family = groupCount >= 1 ? FIRST_PATTERN.matcher(this.osReplacement).replaceAll(this.matcher.group(1)) : this.osReplacement;
            } else if (groupCount >= 1) {
                family = this.matcher.group(1);
            }
            String v1 = null;
            if (this.v1Replacement != null) {
                v1 = this.getReplacement(this.matcher, this.v1Replacement);
            } else if (groupCount >= 2) {
                v1 = this.matcher.group(2);
            }
            String v2 = null;
            if (this.v2Replacement != null) {
                v2 = this.getReplacement(this.matcher, this.v2Replacement);
            } else if (groupCount >= 3) {
                v2 = this.matcher.group(3);
            }
            String v3 = null;
            if (this.v3Replacement != null) {
                v3 = this.getReplacement(this.matcher, this.v3Replacement);
            } else if (groupCount >= 4) {
                v3 = this.matcher.group(4);
            }
            String v4 = null;
            if (groupCount >= 5) {
                v4 = this.matcher.group(5);
            }
            return family == null ? null : new OS(family, v1, v2, v3, v4);
        }

        private String getReplacement(Matcher matcher, String replacement) {
            if (this.isBackReference(replacement)) {
                int group = this.getGroup(replacement);
                return matcher.group(group);
            }
            return replacement;
        }

        private boolean isBackReference(String replacement) {
            return replacement.startsWith("$");
        }

        private int getGroup(String backReference) {
            return Integer.valueOf(backReference.substring(1));
        }
    }
}

