/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.fielddata;

import org.apache.lucene.geo.GeoUtils;
import org.elasticsearch.lucene.spatial.TriangleTreeVisitor;
import org.elasticsearch.xpack.spatial.index.fielddata.GeoRelation;

class Tile2DVisitor
implements TriangleTreeVisitor {
    private GeoRelation relation;
    private int minX;
    private int maxX;
    private int minY;
    private int maxY;

    Tile2DVisitor() {
    }

    public void reset(int minX, int minY, int maxX, int maxY) {
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        this.relation = GeoRelation.QUERY_DISJOINT;
    }

    public GeoRelation relation() {
        return this.relation;
    }

    @Override
    public void visitPoint(int x, int y) {
        if (this.contains(x, y)) {
            this.relation = GeoRelation.QUERY_CROSSES;
        }
    }

    @Override
    public void visitLine(int aX, int aY, int bX, int bY, byte metadata) {
        if (this.intersectsLine(aX, aY, bX, bY)) {
            this.relation = GeoRelation.QUERY_CROSSES;
        }
    }

    @Override
    public void visitTriangle(int aX, int aY, int bX, int bY, int cX, int cY, byte metadata) {
        boolean ca;
        boolean bc;
        boolean ab = TriangleTreeVisitor.abFromTriangle(metadata);
        GeoRelation geoRelation = this.relateTriangle(aX, aY, ab, bX, bY, bc = TriangleTreeVisitor.bcFromTriangle(metadata), cX, cY, ca = TriangleTreeVisitor.caFromTriangle(metadata));
        if (geoRelation != GeoRelation.QUERY_DISJOINT) {
            this.relation = geoRelation;
        }
    }

    @Override
    public boolean push() {
        return this.relation != GeoRelation.QUERY_CROSSES;
    }

    @Override
    public boolean pushX(int minX) {
        return this.maxX >= minX;
    }

    @Override
    public boolean pushY(int minY) {
        return this.maxY >= minY;
    }

    @Override
    public boolean push(int maxX, int maxY) {
        return this.minY <= maxY && this.minX <= maxX;
    }

    @Override
    public boolean push(int minX, int minY, int maxX, int maxY) {
        if (minX > this.maxX || maxX < this.minX || minY > this.maxY || maxY < this.minY) {
            this.relation = GeoRelation.QUERY_DISJOINT;
            return false;
        }
        if (this.minX <= minX && this.maxX >= maxX && this.minY <= minY && this.maxY >= maxY) {
            this.relation = GeoRelation.QUERY_CONTAINS;
            return false;
        }
        return true;
    }

    public boolean contains(int x, int y) {
        return x >= this.minX && x <= this.maxX && y >= this.minY && y <= this.maxY;
    }

    private boolean intersectsLine(int aX, int aY, int bX, int bY) {
        if (this.contains(aX, aY) || this.contains(bX, bY)) {
            return true;
        }
        int tMinX = StrictMath.min(aX, bX);
        int tMaxX = StrictMath.max(aX, bX);
        int tMinY = StrictMath.min(aY, bY);
        int tMaxY = StrictMath.max(aY, bY);
        if (tMaxX < this.minX || tMinX > this.maxX || tMinY > this.maxY || tMaxY < this.minY) {
            return false;
        }
        return this.edgeIntersectsQuery(aX, aY, bX, bY);
    }

    private GeoRelation relateTriangle(int aX, int aY, boolean ab, int bX, int bY, boolean bc, int cX, int cY, boolean ca) {
        int tMinX = StrictMath.min(StrictMath.min(aX, bX), cX);
        int tMaxX = StrictMath.max(StrictMath.max(aX, bX), cX);
        int tMinY = StrictMath.min(StrictMath.min(aY, bY), cY);
        int tMaxY = StrictMath.max(StrictMath.max(aY, bY), cY);
        if (tMaxX < this.minX || tMinX > this.maxX || tMinY > this.maxY || tMaxY < this.minY) {
            return GeoRelation.QUERY_DISJOINT;
        }
        if (this.contains(aX, aY) || this.contains(bX, bY) || this.contains(cX, cY)) {
            return GeoRelation.QUERY_CROSSES;
        }
        boolean within = false;
        if (this.edgeIntersectsQuery(aX, aY, bX, bY)) {
            if (ab) {
                return GeoRelation.QUERY_CROSSES;
            }
            within = true;
        }
        if (this.edgeIntersectsQuery(bX, bY, cX, cY)) {
            if (bc) {
                return GeoRelation.QUERY_CROSSES;
            }
            within = true;
        }
        if (this.edgeIntersectsQuery(cX, cY, aX, aY)) {
            if (ca) {
                return GeoRelation.QUERY_CROSSES;
            }
            within = true;
        }
        if (within || Tile2DVisitor.pointInTriangle(tMinX, tMaxX, tMinY, tMaxY, this.minX, this.minY, aX, aY, bX, bY, cX, cY)) {
            return GeoRelation.QUERY_INSIDE;
        }
        return GeoRelation.QUERY_DISJOINT;
    }

    private boolean edgeIntersectsQuery(int ax, int ay, int bx, int by) {
        if (Tile2DVisitor.boxesAreDisjoint(Math.min(ax, bx), Math.max(ax, bx), Math.min(ay, by), Math.max(ay, by), this.minX, this.maxX, this.minY, this.maxY)) {
            return false;
        }
        if (GeoUtils.orient(ax, ay, bx, by, this.minX, this.maxY) * GeoUtils.orient(ax, ay, bx, by, this.maxX, this.maxY) <= 0 && GeoUtils.orient(this.minX, this.maxY, this.maxX, this.maxY, ax, ay) * GeoUtils.orient(this.minX, this.maxY, this.maxX, this.maxY, bx, by) <= 0) {
            return true;
        }
        if (GeoUtils.orient(ax, ay, bx, by, this.maxX, this.maxY) * GeoUtils.orient(ax, ay, bx, by, this.maxX, this.minY) <= 0 && GeoUtils.orient(this.maxX, this.maxY, this.maxX, this.minY, ax, ay) * GeoUtils.orient(this.maxX, this.maxY, this.maxX, this.minY, bx, by) <= 0) {
            return true;
        }
        if (GeoUtils.orient(ax, ay, bx, by, this.maxX, this.minY) * GeoUtils.orient(ax, ay, bx, by, this.minX, this.minY) <= 0 && GeoUtils.orient(this.maxX, this.minY, this.minX, this.minY, ax, ay) * GeoUtils.orient(this.maxX, this.minY, this.minX, this.minY, bx, by) <= 0) {
            return true;
        }
        return GeoUtils.orient(ax, ay, bx, by, this.minX, this.minY) * GeoUtils.orient(ax, ay, bx, by, this.minX, this.maxY) <= 0 && GeoUtils.orient(this.minX, this.minY, this.minX, this.maxY, ax, ay) * GeoUtils.orient(this.minX, this.minY, this.minX, this.maxY, bx, by) <= 0;
    }

    private static boolean pointInTriangle(double minX, double maxX, double minY, double maxY, double x, double y, double aX, double aY, double bX, double bY, double cX, double cY) {
        if (x >= minX && x <= maxX && y >= minY && y <= maxY) {
            int a = GeoUtils.orient(x, y, aX, aY, bX, bY);
            int b = GeoUtils.orient(x, y, bX, bY, cX, cY);
            if (a == 0 || b == 0 || a < 0 == b < 0) {
                int c = GeoUtils.orient(x, y, cX, cY, aX, aY);
                return c == 0 || c < 0 == (b < 0 || a < 0);
            }
            return false;
        }
        return false;
    }

    private static boolean boxesAreDisjoint(int aMinX, int aMaxX, int aMinY, int aMaxY, int bMinX, int bMaxX, int bMinY, int bMaxY) {
        return aMaxX < bMinX || aMinX > bMaxX || aMaxY < bMinY || aMinY > bMaxY;
    }
}

