/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.deprecation.LoggingDeprecationAccumulationHandler;

public class XContentObjectTransformer<T extends ToXContentObject> {
    private final NamedXContentRegistry registry;
    private final CheckedFunction<XContentParser, T, IOException> parserFunction;

    public static XContentObjectTransformer<AggregatorFactories.Builder> aggregatorTransformer(NamedXContentRegistry registry) {
        return new XContentObjectTransformer<AggregatorFactories.Builder>(registry, p -> {
            XContentParser.Token token = p.nextToken();
            assert (XContentParser.Token.START_OBJECT.equals((Object)token));
            return AggregatorFactories.parseAggregators(p);
        });
    }

    public static XContentObjectTransformer<QueryBuilder> queryBuilderTransformer(NamedXContentRegistry registry) {
        return new XContentObjectTransformer<QueryBuilder>(registry, AbstractQueryBuilder::parseTopLevelQuery);
    }

    XContentObjectTransformer(NamedXContentRegistry registry, CheckedFunction<XContentParser, T, IOException> parserFunction) {
        this.parserFunction = parserFunction;
        this.registry = registry;
    }

    public T fromMap(Map<String, Object> stringObjectMap) throws IOException {
        return this.fromMap(stringObjectMap, new ArrayList<String>());
    }

    public T fromMap(Map<String, Object> stringObjectMap, List<String> deprecationWarnings) throws IOException {
        if (stringObjectMap == null) {
            return null;
        }
        LoggingDeprecationAccumulationHandler deprecationLogger = new LoggingDeprecationAccumulationHandler();
        try (XContentBuilder xContentBuilder = XContentFactory.jsonBuilder().map(stringObjectMap);){
            ToXContentObject toXContentObject;
            block13: {
                XContentParser parser = XContentHelper.createParserNotCompressed(XContentParserConfiguration.EMPTY.withRegistry(this.registry).withDeprecationHandler(deprecationLogger), BytesReference.bytes(xContentBuilder), XContentType.JSON);
                try {
                    ToXContentObject retVal = (ToXContentObject)this.parserFunction.apply(parser);
                    deprecationWarnings.addAll(deprecationLogger.getDeprecations());
                    toXContentObject = retVal;
                    if (parser == null) break block13;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return (T)toXContentObject;
        }
    }

    public Map<String, Object> toMap(T object) throws IOException {
        if (object == null) {
            return null;
        }
        try (XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();){
            XContentBuilder content = object.toXContent(xContentBuilder, ToXContent.EMPTY_PARAMS);
            Map<String, Object> map = XContentHelper.convertToMap(BytesReference.bytes(content), true, XContentType.JSON).v2();
            return map;
        }
    }
}

