/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.utils;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.utils.NamedXContentObject;

public final class NamedXContentObjectHelper {
    private NamedXContentObjectHelper() {
    }

    public static XContentBuilder writeNamedObjects(XContentBuilder builder, ToXContent.Params params, boolean useExplicitOrder, String namedObjectsName, List<? extends NamedXContentObject> namedObjects) throws IOException {
        if (useExplicitOrder) {
            builder.startArray(namedObjectsName);
        } else {
            builder.startObject(namedObjectsName);
        }
        for (NamedXContentObject namedXContentObject : namedObjects) {
            if (useExplicitOrder) {
                builder.startObject();
            }
            builder.field(namedXContentObject.getName(), namedXContentObject, params);
            if (!useExplicitOrder) continue;
            builder.endObject();
        }
        if (useExplicitOrder) {
            builder.endArray();
        } else {
            builder.endObject();
        }
        return builder;
    }

    public static XContentBuilder writeNamedObject(XContentBuilder builder, ToXContent.Params params, String namedObjectName, NamedXContentObject namedObject) throws IOException {
        builder.startObject(namedObjectName);
        builder.field(namedObject.getName(), namedObject, params);
        builder.endObject();
        return builder;
    }
}

