/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.packageloader.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.ModelPackageConfig;

public class LoadTrainedModelPackageAction
extends ActionType<AcknowledgedResponse> {
    public static final String NAME = "cluster:internal/xpack/ml/trained_models/package_loader/load";
    public static final LoadTrainedModelPackageAction INSTANCE = new LoadTrainedModelPackageAction();

    private LoadTrainedModelPackageAction() {
        super(NAME);
    }

    public static class Request
    extends MasterNodeRequest<Request> {
        private final String modelId;
        private final ModelPackageConfig modelPackageConfig;
        private final boolean waitForCompletion;

        public Request(String modelId, ModelPackageConfig modelPackageConfig, boolean waitForCompletion) {
            super(TRAPPY_IMPLICIT_DEFAULT_MASTER_NODE_TIMEOUT);
            this.modelId = modelId;
            this.modelPackageConfig = modelPackageConfig;
            this.waitForCompletion = waitForCompletion;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.modelId = in.readString();
            this.modelPackageConfig = new ModelPackageConfig(in);
            this.waitForCompletion = in.readBoolean();
        }

        public String getModelId() {
            return this.modelId;
        }

        public ModelPackageConfig getModelPackageConfig() {
            return this.modelPackageConfig;
        }

        public boolean isWaitForCompletion() {
            return this.waitForCompletion;
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.modelId);
            this.modelPackageConfig.writeTo(out);
            out.writeBoolean(this.waitForCompletion);
        }

        public int hashCode() {
            return Objects.hash(this.modelId, this.modelPackageConfig, this.waitForCompletion);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Request other = (Request)obj;
            return Objects.equals(this.modelId, other.modelId) && Objects.equals(this.modelPackageConfig, other.modelPackageConfig) && this.waitForCompletion == other.waitForCompletion;
        }
    }
}

