/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.IndexCommit;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ResultDeduplicator;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.metadata.NodesShutdownMetadata;
import org.elasticsearch.cluster.metadata.SingleNodeShutdownMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.concurrent.ThrottledTaskRunner;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.seqno.SequenceNumbers;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.IndexShardSnapshotFailedException;
import org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryShardId;
import org.elasticsearch.repositories.ShardGeneration;
import org.elasticsearch.repositories.ShardGenerations;
import org.elasticsearch.repositories.ShardSnapshotResult;
import org.elasticsearch.repositories.SnapshotIndexCommit;
import org.elasticsearch.repositories.SnapshotShardContext;
import org.elasticsearch.snapshots.AbortedSnapshotException;
import org.elasticsearch.snapshots.PausedSnapshotException;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotShutdownProgressTracker;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.snapshots.UpdateIndexShardSnapshotStatusRequest;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public final class SnapshotShardsService
extends AbstractLifecycleComponent
implements ClusterStateListener,
IndexEventListener {
    private static final Logger logger = LogManager.getLogger(SnapshotShardsService.class);
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final RepositoriesService repositoriesService;
    private final TransportService transportService;
    private final ThreadPool threadPool;
    private final SnapshotShutdownProgressTracker snapshotShutdownProgressTracker;
    private final Map<Snapshot, Map<ShardId, IndexShardSnapshotStatus>> shardSnapshots = new HashMap<Snapshot, Map<ShardId, IndexShardSnapshotStatus>>();
    private final ResultDeduplicator<UpdateIndexShardSnapshotStatusRequest, Void> remoteFailedRequestDeduplicator;
    private final ThrottledTaskRunner startShardSnapshotTaskRunner;
    private final ThrottledTaskRunner notifyOnAbortTaskRunner;
    private final ShardStatusConsistencyChecker shardStatusConsistencyChecker = new ShardStatusConsistencyChecker();

    public SnapshotShardsService(Settings settings, ClusterService clusterService, RepositoriesService repositoriesService, TransportService transportService, IndicesService indicesService) {
        this.indicesService = indicesService;
        this.repositoriesService = repositoriesService;
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.threadPool = transportService.getThreadPool();
        this.snapshotShutdownProgressTracker = new SnapshotShutdownProgressTracker(() -> clusterService.state().nodes().getLocalNodeId(), callerLogger -> this.logIndexShardSnapshotStatuses((Logger)callerLogger), clusterService.getClusterSettings(), this.threadPool);
        this.remoteFailedRequestDeduplicator = new ResultDeduplicator(this.threadPool.getThreadContext());
        if (DiscoveryNode.canContainData(settings)) {
            clusterService.addListener(this);
        }
        this.notifyOnAbortTaskRunner = new ThrottledTaskRunner("notify-on-abort", this.threadPool.info("snapshot").getMax(), this.threadPool.generic());
        this.startShardSnapshotTaskRunner = new ThrottledTaskRunner("start-shard-snapshots", this.threadPool.info("snapshot").getMax(), this.threadPool.executor("snapshot"));
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doStop() {
    }

    @Override
    protected void doClose() {
        this.clusterService.removeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        try {
            String localNodeId = this.clusterService.localNode().getId();
            NodesShutdownMetadata currentShutdownMetadata = (NodesShutdownMetadata)event.state().metadata().custom("node_shutdown");
            NodesShutdownMetadata previousShutdownMetadata = (NodesShutdownMetadata)event.previousState().metadata().custom("node_shutdown");
            SingleNodeShutdownMetadata currentLocalNodeShutdownMetadata = currentShutdownMetadata != null ? currentShutdownMetadata.get(localNodeId) : null;
            SingleNodeShutdownMetadata previousLocalNodeShutdownMetadata = previousShutdownMetadata != null ? previousShutdownMetadata.get(localNodeId) : null;
            boolean isLocalNodeAddingShutdown = false;
            if (!SnapshotShardsService.isPausingProgressTrackedShutdown(previousLocalNodeShutdownMetadata) && SnapshotShardsService.isPausingProgressTrackedShutdown(currentLocalNodeShutdownMetadata)) {
                this.snapshotShutdownProgressTracker.onClusterStateAddShutdown();
                isLocalNodeAddingShutdown = true;
            } else if (SnapshotShardsService.isPausingProgressTrackedShutdown(previousLocalNodeShutdownMetadata) && !SnapshotShardsService.isPausingProgressTrackedShutdown(currentLocalNodeShutdownMetadata)) {
                this.snapshotShutdownProgressTracker.onClusterStateRemoveShutdown();
            }
            SnapshotsInProgress currentSnapshots = SnapshotsInProgress.get(event.state());
            if (!SnapshotsInProgress.get(event.previousState()).equals(currentSnapshots)) {
                Map<Snapshot, Map<ShardId, IndexShardSnapshotStatus>> map = this.shardSnapshots;
                synchronized (map) {
                    this.cancelRemoved(currentSnapshots);
                    for (List<SnapshotsInProgress.Entry> oneRepoSnapshotsInProgress : currentSnapshots.entriesByRepo()) {
                        for (SnapshotsInProgress.Entry snapshotsInProgressEntry : oneRepoSnapshotsInProgress) {
                            this.handleUpdatedSnapshotsInProgressEntry(localNodeId, currentSnapshots.isNodeIdForRemoval(localNodeId), snapshotsInProgressEntry);
                        }
                    }
                }
            }
            if (isLocalNodeAddingShutdown) {
                this.snapshotShutdownProgressTracker.onClusterStatePausingSetForAllShardSnapshots();
            }
            String previousMasterNodeId = event.previousState().nodes().getMasterNodeId();
            String currentMasterNodeId = event.state().nodes().getMasterNodeId();
            if (currentMasterNodeId != null && !currentMasterNodeId.equals(previousMasterNodeId)) {
                this.remoteFailedRequestDeduplicator.clear();
                for (List<SnapshotsInProgress.Entry> snapshots : currentSnapshots.entriesByRepo()) {
                    this.syncShardStatsOnNewMaster(snapshots);
                }
            }
        }
        catch (Exception e) {
            assert (false) : new AssertionError((Object)e);
            logger.warn("failed to update snapshot state", (Throwable)e);
        }
    }

    private static boolean isPausingProgressTrackedShutdown(@Nullable SingleNodeShutdownMetadata localNodeShutdownMetadata) {
        return localNodeShutdownMetadata != null && localNodeShutdownMetadata.getType() != SingleNodeShutdownMetadata.Type.RESTART;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, Settings indexSettings) {
        Map<Snapshot, Map<ShardId, IndexShardSnapshotStatus>> map = this.shardSnapshots;
        synchronized (map) {
            for (Map.Entry<Snapshot, Map<ShardId, IndexShardSnapshotStatus>> snapshotShards : this.shardSnapshots.entrySet()) {
                IndexShardSnapshotStatus indexShardSnapshotStatus = snapshotShards.getValue().get(shardId);
                if (indexShardSnapshotStatus == null) continue;
                logger.debug("[{}] shard closing, abort snapshotting for snapshot [{}]", (Object)shardId, (Object)snapshotShards.getKey().getSnapshotId());
                indexShardSnapshotStatus.abortIfNotCompleted("shard is closing, aborting", this.notifyOnAbortTaskRunner::enqueueTask);
            }
        }
    }

    private void logIndexShardSnapshotStatuses(Logger callerLogger) {
        for (Map.Entry<Snapshot, Map<ShardId, IndexShardSnapshotStatus>> snapshot : this.shardSnapshots.entrySet()) {
            for (Map.Entry<ShardId, IndexShardSnapshotStatus> shardSnapshot : snapshot.getValue().entrySet()) {
                callerLogger.info(org.elasticsearch.common.Strings.format("SnapshotId %s, ShardId %s, shard snapshot status: %s", snapshot.getKey().getSnapshotId(), shardSnapshot.getKey(), shardSnapshot.getValue()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<ShardId, IndexShardSnapshotStatus.Copy> currentSnapshotShards(Snapshot snapshot) {
        Map<Snapshot, Map<ShardId, IndexShardSnapshotStatus>> map = this.shardSnapshots;
        synchronized (map) {
            Map<ShardId, IndexShardSnapshotStatus> current = this.shardSnapshots.get(snapshot);
            if (current == null) {
                return null;
            }
            Map<ShardId, IndexShardSnapshotStatus.Copy> result = Maps.newMapWithExpectedSize(current.size());
            for (Map.Entry<ShardId, IndexShardSnapshotStatus> entry : current.entrySet()) {
                result.put(entry.getKey(), entry.getValue().asCopy());
            }
            return result;
        }
    }

    private void cancelRemoved(SnapshotsInProgress snapshotsInProgress) {
        Iterator<Map.Entry<Snapshot, Map<ShardId, IndexShardSnapshotStatus>>> it = this.shardSnapshots.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Snapshot, Map<ShardId, IndexShardSnapshotStatus>> entry = it.next();
            Snapshot snapshot = entry.getKey();
            if (snapshotsInProgress.snapshot(snapshot) != null) continue;
            it.remove();
            for (IndexShardSnapshotStatus snapshotStatus : entry.getValue().values()) {
                snapshotStatus.abortIfNotCompleted("snapshot has been removed in cluster state, aborting", this.notifyOnAbortTaskRunner::enqueueTask);
            }
        }
    }

    private void handleUpdatedSnapshotsInProgressEntry(String localNodeId, boolean removingLocalNode, SnapshotsInProgress.Entry entry) {
        if (entry.isClone()) {
            return;
        }
        switch (entry.state()) {
            case STARTED: {
                if (!entry.hasShardsInInitState()) {
                    return;
                }
                if (removingLocalNode) {
                    this.pauseShardSnapshotsForNodeRemoval(localNodeId, entry);
                    break;
                }
                this.startNewShardSnapshots(localNodeId, entry);
                break;
            }
            case ABORTED: {
                Snapshot snapshot = entry.snapshot();
                Map snapshotShards = this.shardSnapshots.getOrDefault(snapshot, Collections.emptyMap());
                for (Map.Entry<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> shard : entry.shardSnapshotStatusByRepoShardId().entrySet()) {
                    ShardId sid = entry.shardId(shard.getKey());
                    IndexShardSnapshotStatus snapshotStatus = (IndexShardSnapshotStatus)snapshotShards.get(sid);
                    if (snapshotStatus == null) {
                        if (shard.getValue().state() != SnapshotsInProgress.ShardState.ABORTED || !localNodeId.equals(shard.getValue().nodeId())) continue;
                        this.notifyUnsuccessfulSnapshotShard(snapshot, sid, SnapshotsInProgress.ShardState.FAILED, shard.getValue().reason(), shard.getValue().generation(), outcomeInfoString -> {});
                        continue;
                    }
                    snapshotStatus.abortIfNotCompleted("snapshot has been aborted", this.notifyOnAbortTaskRunner::enqueueTask);
                }
                break;
            }
        }
    }

    private void startNewShardSnapshots(String localNodeId, SnapshotsInProgress.Entry entry) {
        HashMap<ShardId, ShardGeneration> shardsToStart = null;
        final Snapshot snapshot = entry.snapshot();
        Map runningShardsForSnapshot = this.shardSnapshots.getOrDefault(snapshot, Collections.emptyMap());
        for (Map.Entry<ShardId, SnapshotsInProgress.ShardSnapshotStatus> scheduledShard : entry.shards().entrySet()) {
            IndexShardSnapshotStatus runningShard;
            ShardId shardId = scheduledShard.getKey();
            SnapshotsInProgress.ShardSnapshotStatus shardSnapshotStatus = scheduledShard.getValue();
            if (shardSnapshotStatus.state() != SnapshotsInProgress.ShardState.INIT || !localNodeId.equals(shardSnapshotStatus.nodeId()) || (runningShard = (IndexShardSnapshotStatus)runningShardsForSnapshot.get(shardId)) != null && !runningShard.isPaused()) continue;
            logger.trace("[{}] adding [{}] shard to the queue", (Object)shardId, (Object)(runningShard == null ? "new" : "paused"));
            if (shardsToStart == null) {
                shardsToStart = new HashMap<ShardId, ShardGeneration>();
            }
            shardsToStart.put(shardId, shardSnapshotStatus.generation());
        }
        if (shardsToStart == null) {
            return;
        }
        assert (!shardsToStart.isEmpty());
        Map newSnapshotShards = this.shardSnapshots.computeIfAbsent(snapshot, s -> new HashMap());
        for (Map.Entry shardEntry : shardsToStart.entrySet()) {
            final ShardId shardId = (ShardId)shardEntry.getKey();
            IndexShardSnapshotStatus snapshotStatus = IndexShardSnapshotStatus.newInitializing((ShardGeneration)shardEntry.getValue());
            newSnapshotShards.put(shardId, snapshotStatus);
            IndexId indexId = entry.indices().get(shardId.getIndexName());
            assert (indexId != null);
            assert (SnapshotsService.useShardGenerations(entry.version()) || ShardGenerations.fixShardGeneration(snapshotStatus.generation()) == null) : "Found non-null, non-numeric shard generation [" + String.valueOf(snapshotStatus.generation()) + "] for snapshot with old-format compatibility";
            final Runnable shardSnapshotTask = this.newShardSnapshotTask(shardId, snapshot, indexId, snapshotStatus, entry.version(), entry.startTime());
            snapshotStatus.updateStatusDescription("shard snapshot enqueuing to start");
            this.startShardSnapshotTaskRunner.enqueueTask(new ActionListener<Releasable>(this){

                @Override
                public void onResponse(Releasable releasable) {
                    try (Releasable releasable2 = releasable;){
                        shardSnapshotTask.run();
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    IllegalStateException wrapperException = new IllegalStateException("impossible failure starting shard snapshot for " + String.valueOf(shardId) + " in " + String.valueOf(snapshot), e);
                    logger.error(wrapperException.getMessage(), (Throwable)wrapperException);
                    assert (false) : wrapperException;
                }
            });
        }
        this.startShardSnapshotTaskRunner.runSyncTasksEagerly(this.threadPool.executor("snapshot"));
    }

    private void pauseShardSnapshotsForNodeRemoval(String localNodeId, SnapshotsInProgress.Entry masterEntryCopy) {
        Map localShardSnapshots = this.shardSnapshots.getOrDefault(masterEntryCopy.snapshot(), Map.of());
        for (Map.Entry<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shardEntry : masterEntryCopy.shards().entrySet()) {
            ShardId shardId = shardEntry.getKey();
            SnapshotsInProgress.ShardSnapshotStatus masterShardSnapshotStatusCopy = shardEntry.getValue();
            if (masterShardSnapshotStatusCopy.state() != SnapshotsInProgress.ShardState.INIT || !localNodeId.equals(masterShardSnapshotStatusCopy.nodeId())) continue;
            IndexShardSnapshotStatus localShardSnapshotStatus = (IndexShardSnapshotStatus)localShardSnapshots.get(shardId);
            if (localShardSnapshotStatus == null) {
                this.notifyUnsuccessfulSnapshotShard(masterEntryCopy.snapshot(), shardId, SnapshotsInProgress.ShardState.PAUSED_FOR_NODE_REMOVAL, "paused", masterShardSnapshotStatusCopy.generation(), outcomeInfoString -> {});
                continue;
            }
            localShardSnapshotStatus.pauseIfNotCompleted(this.notifyOnAbortTaskRunner::enqueueTask);
        }
    }

    private Runnable newShardSnapshotTask(final ShardId shardId, final Snapshot snapshot, IndexId indexId, final IndexShardSnapshotStatus snapshotStatus, IndexVersion entryVersion, long entryStartTime) {
        final Consumer<String> postMasterNotificationAction = outcomeInfoString -> snapshotStatus.updateStatusDescription("Data node shard snapshot finished. Remote master update outcome: " + outcomeInfoString);
        ActionListener<ShardSnapshotResult> snapshotResultListener = new ActionListener<ShardSnapshotResult>(){

            @Override
            public void onResponse(ShardSnapshotResult shardSnapshotResult) {
                snapshotStatus.updateStatusDescription("snapshot succeeded: proceeding to notify master of success");
                ShardGeneration newGeneration = shardSnapshotResult.getGeneration();
                assert (newGeneration != null);
                assert (newGeneration.equals(snapshotStatus.generation()));
                if (logger.isTraceEnabled()) {
                    IndexShardSnapshotStatus.Copy lastSnapshotStatus = snapshotStatus.asCopy();
                    logger.trace("[{}][{}] completed snapshot to [{}] with status [{}] at generation [{}]", (Object)shardId, (Object)snapshot, (Object)snapshot.getRepository(), (Object)lastSnapshotStatus, (Object)snapshotStatus.generation());
                }
                SnapshotShardsService.this.notifySuccessfulSnapshotShard(snapshot, shardId, shardSnapshotResult, postMasterNotificationAction);
            }

            @Override
            public void onFailure(Exception e) {
                String failure;
                IndexShardSnapshotStatus.Stage nextStage;
                snapshotStatus.updateStatusDescription("failed with exception '" + String.valueOf(e) + ": proceeding to notify master of failure");
                if (e instanceof AbortedSnapshotException) {
                    nextStage = IndexShardSnapshotStatus.Stage.FAILURE;
                    failure = "aborted";
                    logger.debug(() -> Strings.format("[%s][%s] aborted shard snapshot", shardId, snapshot), (Throwable)e);
                } else if (e instanceof PausedSnapshotException) {
                    nextStage = IndexShardSnapshotStatus.Stage.PAUSED;
                    failure = "paused for removal of node holding primary";
                    logger.debug(() -> Strings.format("[%s][%s] pausing shard snapshot", shardId, snapshot), (Throwable)e);
                } else {
                    nextStage = IndexShardSnapshotStatus.Stage.FAILURE;
                    failure = SnapshotShardsService.summarizeFailure(e);
                    logger.warn(() -> Strings.format("[%s][%s] failed to snapshot shard", shardId, snapshot), (Throwable)e);
                }
                SnapshotsInProgress.ShardState shardState = snapshotStatus.moveToUnsuccessful(nextStage, failure, SnapshotShardsService.this.threadPool.absoluteTimeInMillis());
                SnapshotShardsService.this.notifyUnsuccessfulSnapshotShard(snapshot, shardId, shardState, failure, snapshotStatus.generation(), postMasterNotificationAction);
            }
        };
        this.snapshotShutdownProgressTracker.incNumberOfShardSnapshotsInProgress(shardId, snapshot);
        ActionListener<ShardSnapshotResult> decTrackerRunsBeforeResultListener = ActionListener.runAfter(snapshotResultListener, () -> this.snapshotShutdownProgressTracker.decNumberOfShardSnapshotsInProgress(shardId, snapshot, snapshotStatus));
        return () -> this.snapshot(shardId, snapshot, indexId, snapshotStatus, entryVersion, entryStartTime, decTrackerRunsBeforeResultListener);
    }

    static String summarizeFailure(Throwable t) {
        if (t.getCause() == null) {
            return t.getClass().getSimpleName() + "[" + t.getMessage() + "]";
        }
        StringBuilder sb = new StringBuilder();
        while (t != null) {
            sb.append(t.getClass().getSimpleName());
            if (t.getMessage() != null) {
                sb.append("[");
                sb.append(t.getMessage());
                sb.append("]");
            }
            if ((t = t.getCause()) == null) continue;
            sb.append("; nested: ");
        }
        return sb.toString();
    }

    private void snapshot(ShardId shardId, Snapshot snapshot, IndexId indexId, IndexShardSnapshotStatus snapshotStatus, IndexVersion version, long entryStartTime, ActionListener<ShardSnapshotResult> resultListener) {
        ActionListener.run(resultListener, listener -> {
            snapshotStatus.updateStatusDescription("has started");
            snapshotStatus.ensureNotAborted();
            IndexShard indexShard = this.indicesService.indexServiceSafe(shardId.getIndex()).getShard(shardId.id());
            if (!indexShard.routingEntry().primary()) {
                throw new IndexShardSnapshotFailedException(shardId, "snapshot should be performed only on primary");
            }
            if (indexShard.routingEntry().relocating()) {
                throw new IndexShardSnapshotFailedException(shardId, "cannot snapshot while relocating");
            }
            IndexShardState indexShardState = indexShard.state();
            if (indexShardState == IndexShardState.CREATED || indexShardState == IndexShardState.RECOVERING) {
                throw new IndexShardSnapshotFailedException(shardId, "shard didn't fully recover yet");
            }
            Repository repository = this.repositoriesService.repository(snapshot.getProjectId(), snapshot.getRepository());
            SnapshotIndexCommit snapshotIndexCommit = null;
            try {
                snapshotStatus.updateStatusDescription("acquiring commit reference from IndexShard: triggers a shard flush");
                snapshotIndexCommit = new SnapshotIndexCommit(indexShard.acquireIndexCommitForSnapshot());
                snapshotStatus.updateStatusDescription("commit reference acquired, proceeding with snapshot");
                String shardStateId = SnapshotShardsService.getShardStateId(indexShard, snapshotIndexCommit.indexCommit());
                snapshotStatus.addAbortListener(SnapshotShardsService.makeAbortListener(indexShard.shardId(), snapshot, snapshotIndexCommit));
                snapshotStatus.ensureNotAborted();
                repository.snapshotShard(new SnapshotShardContext(indexShard.store(), indexShard.mapperService(), snapshot.getSnapshotId(), indexId, snapshotIndexCommit, shardStateId, snapshotStatus, version, entryStartTime, (ActionListener<ShardSnapshotResult>)listener));
                snapshotIndexCommit = null;
                if (snapshotIndexCommit != null) {
                    snapshotIndexCommit.closingBefore(new ActionListener<Void>(){
                        final /* synthetic */ IndexShard val$indexShard;
                        final /* synthetic */ Snapshot val$snapshot;
                        {
                            this.val$indexShard = indexShard;
                            this.val$snapshot = snapshot;
                        }

                        @Override
                        public void onResponse(Void unused) {
                        }

                        @Override
                        public void onFailure(Exception e) {
                            logger.warn(org.elasticsearch.common.Strings.format("exception closing commit for [%s] in [%s]", this.val$indexShard.shardId(), this.val$snapshot), (Throwable)e);
                        }
                    }).onResponse(null);
                }
            }
            catch (Throwable throwable) {
                if (snapshotIndexCommit != null) {
                    snapshotIndexCommit.closingBefore(new /* invalid duplicate definition of identical inner class */).onResponse(null);
                }
                throw throwable;
            }
        });
    }

    private static ActionListener<IndexShardSnapshotStatus.AbortStatus> makeAbortListener(final ShardId shardId, final Snapshot snapshot, final SnapshotIndexCommit snapshotIndexCommit) {
        return new ActionListener<IndexShardSnapshotStatus.AbortStatus>(){

            @Override
            public void onResponse(IndexShardSnapshotStatus.AbortStatus abortStatus) {
                if (abortStatus == IndexShardSnapshotStatus.AbortStatus.ABORTED) {
                    assert (ThreadPool.assertCurrentThreadPool("generic", "snapshot"));
                    snapshotIndexCommit.onAbort();
                }
            }

            @Override
            public void onFailure(Exception e) {
                logger.error(() -> org.elasticsearch.common.Strings.format("unexpected failure in %s", this.description()), (Throwable)e);
                assert (false) : e;
            }

            public String toString() {
                return this.description();
            }

            private String description() {
                return org.elasticsearch.common.Strings.format("abort listener for [%s] in [%s]", shardId, snapshot);
            }
        };
    }

    @Nullable
    public static String getShardStateId(IndexShard indexShard, IndexCommit snapshotIndexCommit) throws IOException {
        Map<String, String> userCommitData = snapshotIndexCommit.getUserData();
        SequenceNumbers.CommitInfo seqNumInfo = SequenceNumbers.loadSeqNoInfoFromLuceneCommit(userCommitData.entrySet());
        long maxSeqNo = seqNumInfo.maxSeqNo();
        if (maxSeqNo != seqNumInfo.localCheckpoint() || maxSeqNo != indexShard.getLastSyncedGlobalCheckpoint()) {
            return null;
        }
        return userCommitData.get("history_uuid") + "-" + userCommitData.getOrDefault("force_merge_uuid", "na") + "-" + maxSeqNo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncShardStatsOnNewMaster(List<SnapshotsInProgress.Entry> entries) {
        for (SnapshotsInProgress.Entry snapshot : entries) {
            Map<ShardId, IndexShardSnapshotStatus> localShards;
            if (snapshot.state() != SnapshotsInProgress.State.STARTED && snapshot.state() != SnapshotsInProgress.State.ABORTED) continue;
            Map<Snapshot, Map<ShardId, IndexShardSnapshotStatus>> map = this.shardSnapshots;
            synchronized (map) {
                Map<ShardId, IndexShardSnapshotStatus> currentLocalShards = this.shardSnapshots.get(snapshot.snapshot());
                if (currentLocalShards == null) {
                    continue;
                }
                localShards = Map.copyOf(currentLocalShards);
            }
            Map<ShardId, SnapshotsInProgress.ShardSnapshotStatus> masterShards = snapshot.shards();
            for (Map.Entry<ShardId, IndexShardSnapshotStatus> localShard : localShards.entrySet()) {
                ShardId shardId = localShard.getKey();
                SnapshotsInProgress.ShardSnapshotStatus masterShard = masterShards.get(shardId);
                if (masterShard == null || masterShard.state().completed()) continue;
                IndexShardSnapshotStatus.Copy indexShardSnapshotStatus = localShard.getValue().asCopy();
                IndexShardSnapshotStatus.Stage stage = indexShardSnapshotStatus.getStage();
                String statusDescription = indexShardSnapshotStatus.getStatusDescription();
                int maxStatusAppend = 1000;
                if (stage == IndexShardSnapshotStatus.Stage.DONE) {
                    logger.debug("[{}] new master thinks the shard [{}] is not completed but the shard is done locally, updating status on the master", (Object)snapshot.snapshot(), (Object)shardId);
                    this.notifySuccessfulSnapshotShard(snapshot.snapshot(), shardId, localShard.getValue().getShardSnapshotResult(), outcomeInfoString -> ((IndexShardSnapshotStatus)localShard.getValue()).updateStatusDescription(org.elasticsearch.common.Strings.format("Data node already successfully finished shard snapshot, but a new master needed to be\nnotified. New remote master notification outcome: [%s]. The prior shard snapshot status\ndescription was [%s]\n", outcomeInfoString, statusDescription.length() < 1000 ? statusDescription : statusDescription.substring(0, 1000))));
                    continue;
                }
                if (stage == IndexShardSnapshotStatus.Stage.FAILURE) {
                    logger.debug("[{}] new master thinks the shard [{}] is not completed but the shard failed locally, updating status on master", (Object)snapshot.snapshot(), (Object)shardId);
                    this.notifyUnsuccessfulSnapshotShard(snapshot.snapshot(), shardId, SnapshotsInProgress.ShardState.FAILED, indexShardSnapshotStatus.getFailure(), localShard.getValue().generation(), outcomeInfoString -> ((IndexShardSnapshotStatus)localShard.getValue()).updateStatusDescription(org.elasticsearch.common.Strings.format("Data node already failed shard snapshot, but a new master needed to be notified. New remote\nmaster notification outcome: [%s]. The prior shard snapshot status description was [%s]\n", outcomeInfoString, statusDescription.length() < 1000 ? statusDescription : statusDescription.substring(0, 1000))));
                    continue;
                }
                if (stage != IndexShardSnapshotStatus.Stage.PAUSED) continue;
                logger.debug("new master thinks that shard [{}] snapshot [{}], with shard generation [{}], is still running, but the shard snapshot is paused locally, updating status on master\n", (Object)shardId, (Object)snapshot.snapshot(), (Object)localShard.getValue().generation());
                this.notifyUnsuccessfulSnapshotShard(snapshot.snapshot(), shardId, SnapshotsInProgress.ShardState.PAUSED_FOR_NODE_REMOVAL, indexShardSnapshotStatus.getFailure(), localShard.getValue().generation(), outcomeInfoString -> ((IndexShardSnapshotStatus)localShard.getValue()).updateStatusDescription(org.elasticsearch.common.Strings.format("Data node already paused shard snapshot, but a new master needed to be notified. New remote\nmaster notification outcome: [%s]. The prior shard snapshot status description was [%s]\n", outcomeInfoString, statusDescription.length() < 1000 ? statusDescription : statusDescription.substring(0, 1000))));
            }
        }
    }

    private void notifySuccessfulSnapshotShard(Snapshot snapshot, ShardId shardId, ShardSnapshotResult shardSnapshotResult, Consumer<String> postMasterNotificationAction) {
        assert (shardSnapshotResult != null);
        assert (shardSnapshotResult.getGeneration() != null);
        this.sendSnapshotShardUpdate(snapshot, shardId, SnapshotsInProgress.ShardSnapshotStatus.success(this.clusterService.localNode().getId(), shardSnapshotResult), postMasterNotificationAction);
    }

    private void notifyUnsuccessfulSnapshotShard(Snapshot snapshot, ShardId shardId, SnapshotsInProgress.ShardState shardState, String failure, ShardGeneration generation, Consumer<String> postMasterNotificationAction) {
        assert (shardState == SnapshotsInProgress.ShardState.FAILED || shardState == SnapshotsInProgress.ShardState.PAUSED_FOR_NODE_REMOVAL) : shardState;
        this.sendSnapshotShardUpdate(snapshot, shardId, new SnapshotsInProgress.ShardSnapshotStatus(this.clusterService.localNode().getId(), shardState, generation, failure), postMasterNotificationAction);
        if (shardState == SnapshotsInProgress.ShardState.PAUSED_FOR_NODE_REMOVAL) {
            logger.debug("Pausing shard [{}] snapshot [{}], with shard generation [{}], because this node is marked for removal", (Object)shardId, (Object)snapshot, (Object)generation);
        }
    }

    private void sendSnapshotShardUpdate(final Snapshot snapshot, final ShardId shardId, final SnapshotsInProgress.ShardSnapshotStatus status, final Consumer<String> postMasterNotificationAction) {
        this.snapshotShutdownProgressTracker.trackRequestSentToMaster(snapshot, shardId);
        ActionListener<Void> updateResultListener = new ActionListener<Void>(){

            @Override
            public void onResponse(Void aVoid) {
                SnapshotShardsService.this.snapshotShutdownProgressTracker.releaseRequestSentToMaster(snapshot, shardId);
                postMasterNotificationAction.accept(org.elasticsearch.common.Strings.format("successfully sent shard snapshot state [%s] update to the master node", new Object[]{status.state()}));
                logger.trace("[{}][{}] updated snapshot state to [{}]", (Object)shardId, (Object)snapshot, (Object)status);
                if (status.state().completed()) {
                    SnapshotShardsService.this.shardStatusConsistencyChecker.ensureShardComplete(snapshot, shardId);
                } else assert (status.state() == SnapshotsInProgress.ShardState.PAUSED_FOR_NODE_REMOVAL) : status;
            }

            @Override
            public void onFailure(Exception e) {
                SnapshotShardsService.this.snapshotShutdownProgressTracker.releaseRequestSentToMaster(snapshot, shardId);
                postMasterNotificationAction.accept(org.elasticsearch.common.Strings.format("exception trying to send shard snapshot state [%s] update to the master node [%s]", new Object[]{status.state(), e}));
                logger.warn(() -> Strings.format("[%s][%s] failed to update snapshot state to [%s]", shardId, snapshot, status), (Throwable)e);
            }
        };
        this.remoteFailedRequestDeduplicator.executeOnce(new UpdateIndexShardSnapshotStatusRequest(snapshot, shardId, status), updateResultListener, (req, reqListener) -> this.transportService.sendRequest(this.transportService.getLocalNode(), "internal:cluster/snapshot/update_snapshot_status", (TransportRequest)req, new ActionListenerResponseHandler<ActionResponse.Empty>(reqListener.map(res -> null), in -> ActionResponse.Empty.INSTANCE, TransportResponseHandler.TRANSPORT_WORKER)));
    }

    class ShardStatusConsistencyChecker {
        private static final Logger CONSISTENCY_CHECKER_LOGGER = LogManager.getLogger(ShardStatusConsistencyChecker.class);
        private final AtomicInteger queuedTaskCount = new AtomicInteger(0);
        private final Queue<CheckTask> queue = new ConcurrentLinkedQueue<CheckTask>();

        ShardStatusConsistencyChecker() {
        }

        void ensureShardComplete(Snapshot snapshot, ShardId shardId) {
            if (!CONSISTENCY_CHECKER_LOGGER.isDebugEnabled()) {
                return;
            }
            if (this.queuedTaskCount.get() > 1000) {
                return;
            }
            this.queue.add(new CheckTask(snapshot, shardId));
            if (this.queuedTaskCount.getAndIncrement() == 0) {
                SnapshotShardsService.this.threadPool.generic().execute(this::runCheck);
            }
        }

        private void runCheck() {
            int taskCount;
            do {
                taskCount = this.queuedTaskCount.get();
                SnapshotsInProgress clusterStateSnapshotsInProgress = SnapshotsInProgress.get(SnapshotShardsService.this.clusterService.state());
                HashMap<Snapshot, Set> shardsBySnapshot = new HashMap<Snapshot, Set>();
                for (int i = 0; i < taskCount; ++i) {
                    CheckTask task = this.queue.poll();
                    assert (task != null);
                    shardsBySnapshot.computeIfAbsent(task.snapshot(), ignored -> new HashSet()).add(task.shardId());
                }
                for (Map.Entry snapshotShards : shardsBySnapshot.entrySet()) {
                    Snapshot snapshot = (Snapshot)snapshotShards.getKey();
                    SnapshotsInProgress.Entry clusterStateSnapshotEntry = clusterStateSnapshotsInProgress.snapshot(snapshot);
                    if (clusterStateSnapshotEntry == null) continue;
                    for (ShardId shardId : (Set)snapshotShards.getValue()) {
                        SnapshotsInProgress.ShardSnapshotStatus clusterStateShardStatus = clusterStateSnapshotEntry.shards().get(shardId);
                        if (clusterStateShardStatus == null) {
                            CONSISTENCY_CHECKER_LOGGER.debug("shard [{}] in snapshot [{}] unexpectedly not found (should be impossible)", (Object)shardId, (Object)snapshot);
                            continue;
                        }
                        if (clusterStateShardStatus.state().completed()) continue;
                        CONSISTENCY_CHECKER_LOGGER.debug("shard [{}] in snapshot [{}] unexpectedly still in state [{}] after notifying master", (Object)shardId, (Object)snapshot, (Object)clusterStateShardStatus);
                    }
                }
            } while (this.queuedTaskCount.addAndGet(-taskCount) != 0);
        }

        private record CheckTask(Snapshot snapshot, ShardId shardId) {
        }
    }
}

