/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.lookup;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.search.lookup.FieldLookup;
import org.elasticsearch.search.lookup.LeafFieldLookupProvider;

public class LeafStoredFieldsLookup
implements Map<Object, FieldLookup> {
    private final Function<String, MappedFieldType> fieldTypeLookup;
    private final LeafFieldLookupProvider leafFieldLookupProvider;
    private int docId = -1;
    private final Map<String, FieldLookup> cachedFieldData = new HashMap<String, FieldLookup>();

    LeafStoredFieldsLookup(Function<String, MappedFieldType> fieldTypeLookup, LeafFieldLookupProvider leafFieldLookupProvider) {
        this.fieldTypeLookup = fieldTypeLookup;
        this.leafFieldLookupProvider = leafFieldLookupProvider;
    }

    public void setDocument(int docId) {
        if (this.docId == docId) {
            return;
        }
        this.docId = docId;
        this.clearCache();
    }

    @Override
    public FieldLookup get(Object key) {
        try {
            return this.loadFieldData(key.toString());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to load stored fields for document [" + this.docId + "]", e);
        }
    }

    @Override
    public boolean containsKey(Object key) {
        try {
            this.loadFieldData(key.toString());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public FieldLookup put(Object key, FieldLookup value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FieldLookup remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    private FieldLookup loadFieldData(String name) throws IOException {
        FieldLookup data = this.cachedFieldData.get(name);
        if (data == null) {
            MappedFieldType fieldType = this.fieldTypeLookup.apply(name);
            if (fieldType == null) {
                throw new IllegalArgumentException("No field found for [" + name + "] in mapping");
            }
            data = new FieldLookup(fieldType);
            this.cachedFieldData.put(name, data);
        }
        if (!data.isLoaded()) {
            this.leafFieldLookupProvider.populateFieldLookup(data, this.docId);
        }
        return data;
    }

    private void clearCache() {
        if (this.cachedFieldData.isEmpty()) {
            return;
        }
        for (Map.Entry<String, FieldLookup> entry : this.cachedFieldData.entrySet()) {
            entry.getValue().clear();
        }
    }
}

