/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.VersionedNamedWriteable;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.BaseAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.xcontent.ToXContentFragment;

public abstract class PipelineAggregationBuilder
implements VersionedNamedWriteable,
BaseAggregationBuilder,
ToXContentFragment,
Rewriteable<PipelineAggregationBuilder> {
    protected final String name;
    protected final String[] bucketsPaths;

    protected PipelineAggregationBuilder(String name, String[] bucketsPaths) {
        if (name == null) {
            throw new IllegalArgumentException("[name] must not be null: [" + name + "]");
        }
        if (bucketsPaths == null) {
            throw new IllegalArgumentException("[bucketsPaths] must not be null: [" + name + "]");
        }
        this.name = name;
        this.bucketsPaths = bucketsPaths;
    }

    public String getName() {
        return this.name;
    }

    public final String[] getBucketsPaths() {
        return this.bucketsPaths;
    }

    protected abstract void validate(ValidationContext var1);

    protected abstract PipelineAggregator create();

    @Override
    public abstract PipelineAggregationBuilder setMetadata(Map<String, Object> var1);

    @Override
    public PipelineAggregationBuilder subAggregations(AggregatorFactories.Builder subFactories) {
        throw new IllegalArgumentException("Aggregation [" + this.name + "] cannot define sub-aggregations");
    }

    public String toString() {
        return Strings.toString(this, true, true);
    }

    @Override
    public PipelineAggregationBuilder rewrite(QueryRewriteContext context) throws IOException {
        return this;
    }

    public static abstract class ValidationContext {
        private ActionRequestValidationException e;

        public static ValidationContext forTreeRoot(Collection<AggregationBuilder> siblingAggregations, ActionRequestValidationException validationFailuresSoFar) {
            return new ForTreeRoot(siblingAggregations, validationFailuresSoFar);
        }

        public static ValidationContext forInsideTree(AggregationBuilder parent, ActionRequestValidationException validationFailuresSoFar) {
            return new ForInsideTree(parent, validationFailuresSoFar);
        }

        private ValidationContext(ActionRequestValidationException validationFailuresSoFar) {
            this.e = validationFailuresSoFar;
        }

        public abstract Collection<AggregationBuilder> getSiblingAggregations();

        public void addValidationError(String error) {
            this.e = ValidateActions.addValidationError(error, this.e);
        }

        public void addBucketPathValidationError(String error) {
            this.addValidationError(PipelineAggregator.Parser.BUCKETS_PATH.getPreferredName() + " " + error);
        }

        public abstract void validateHasParent(String var1, String var2);

        public abstract void validateParentAggSequentiallyOrdered(String var1, String var2);

        public abstract void validateParentAggSequentiallyOrderedWithoutSkips(String var1, String var2);

        public ActionRequestValidationException getValidationException() {
            return this.e;
        }

        private static class ForTreeRoot
        extends ValidationContext {
            private final Collection<AggregationBuilder> siblingAggregations;

            ForTreeRoot(Collection<AggregationBuilder> siblingAggregations, ActionRequestValidationException validationFailuresSoFar) {
                super(validationFailuresSoFar);
                this.siblingAggregations = Objects.requireNonNull(siblingAggregations);
            }

            @Override
            public Collection<AggregationBuilder> getSiblingAggregations() {
                return this.siblingAggregations;
            }

            @Override
            public void validateHasParent(String type, String name) {
                this.addValidationError(type + " aggregation [" + name + "] must be declared inside of another aggregation");
            }

            @Override
            public void validateParentAggSequentiallyOrdered(String type, String name) {
                this.noParentCantBeOrdered(type, name);
            }

            @Override
            public void validateParentAggSequentiallyOrderedWithoutSkips(String type, String name) {
                this.noParentCantBeOrdered(type, name);
            }

            private void noParentCantBeOrdered(String type, String name) {
                this.addValidationError(type + " aggregation [" + name + "] must have a histogram, date_histogram or auto_date_histogram as parent but doesn't have a parent");
            }
        }

        private static class ForInsideTree
        extends ValidationContext {
            private final AggregationBuilder parent;

            ForInsideTree(AggregationBuilder parent, ActionRequestValidationException validationFailuresSoFar) {
                super(validationFailuresSoFar);
                this.parent = Objects.requireNonNull(parent);
            }

            @Override
            public Collection<AggregationBuilder> getSiblingAggregations() {
                return this.parent.getSubAggregations();
            }

            @Override
            public void validateHasParent(String type, String name) {
            }

            @Override
            public void validateParentAggSequentiallyOrdered(String type, String name) {
                this.parent.validateSequentiallyOrdered(type, name, this::addValidationError);
            }

            @Override
            public void validateParentAggSequentiallyOrderedWithoutSkips(String type, String name) {
                this.parent.validateSequentiallyOrderedWithoutGaps(type, name, this::addValidationError);
            }
        }
    }
}

