/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.persistent;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.core.Strings;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTasksExecutor;

public class PersistentTasksExecutorRegistry {
    private static final Set<String> CLUSTER_SCOPED_TASKS = ConcurrentCollections.newConcurrentSet();
    private final Map<String, PersistentTasksExecutor<?>> taskExecutors;

    public PersistentTasksExecutorRegistry(Collection<PersistentTasksExecutor<?>> taskExecutors) {
        HashMap map = new HashMap();
        for (PersistentTasksExecutor<?> executor : taskExecutors) {
            PersistentTasksExecutor<?> old = map.put(executor.getTaskName(), executor);
            if (old != null) {
                String message = Strings.format("task [%s] is already registered with [%s], cannot re-register with [%s]", executor.getTaskName(), old, executor);
                assert (false) : message;
                throw new IllegalStateException(message);
            }
            if (executor.scope() != PersistentTasksExecutor.Scope.CLUSTER) continue;
            CLUSTER_SCOPED_TASKS.add(executor.getTaskName());
        }
        this.taskExecutors = Collections.unmodifiableMap(map);
    }

    public <Params extends PersistentTaskParams> PersistentTasksExecutor<Params> getPersistentTaskExecutorSafe(String taskName) {
        PersistentTasksExecutor<?> executor = this.taskExecutors.get(taskName);
        if (executor == null) {
            throw new IllegalStateException("Unknown persistent executor [" + taskName + "]");
        }
        return executor;
    }

    public static boolean isClusterScopedTask(String taskName) {
        return CLUSTER_SCOPED_TASKS.contains(taskName);
    }
}

