/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.license.GetLicenseAction;
import org.elasticsearch.license.GetLicenseResponse;
import org.elasticsearch.protocol.xpack.license.GetLicenseRequest;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

@ServerlessScope(value=Scope.PUBLIC)
public class RestGetLicenseAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestGetLicenseAction.class);

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_license"));
    }

    @Override
    public String getName() {
        return "get_license";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        Map<String, String> overrideParams = Maps.newMapWithExpectedSize(2);
        overrideParams.put("rest_view", "true");
        overrideParams.put("license_version", String.valueOf(5));
        if (request.hasParam("accept_enterprise")) {
            deprecationLogger.warn(DeprecationCategory.API, "get_license_accept_enterprise", "Including [accept_enterprise] in get license requests is deprecated. The parameter will be removed in the next major version", new Object[0]);
            if (!request.paramAsBoolean("accept_enterprise", true)) {
                throw new IllegalArgumentException("The [accept_enterprise] parameters may not be false");
            }
        }
        final ToXContent.DelegatingMapParams params = new ToXContent.DelegatingMapParams(overrideParams, request);
        GetLicenseRequest getLicenseRequest = new GetLicenseRequest(RestUtils.getMasterNodeTimeout(request));
        getLicenseRequest.local(request.paramAsBoolean("local", getLicenseRequest.local()));
        return channel -> client.admin().cluster().execute(GetLicenseAction.INSTANCE, getLicenseRequest, new RestBuilderListener<GetLicenseResponse>(this, channel){

            @Override
            public RestResponse buildResponse(GetLicenseResponse response, XContentBuilder builder) throws Exception {
                if (!request.hasParam("pretty")) {
                    builder.prettyPrint().lfAtEnd();
                }
                boolean hasLicense = response.license() != null;
                builder.startObject();
                if (hasLicense) {
                    builder.startObject("license");
                    response.license().toInnerXContent(builder, params);
                    builder.endObject();
                }
                builder.endObject();
                return new RestResponse(hasLicense ? RestStatus.OK : RestStatus.NOT_FOUND, builder);
            }
        });
    }
}

