/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.elasticsearch.indices.recovery.RecoveryTransportRequest;
import org.elasticsearch.repositories.IndexId;

public class RecoverySnapshotFileRequest
extends RecoveryTransportRequest {
    private final String repository;
    private final IndexId indexId;
    private final BlobStoreIndexShardSnapshot.FileInfo fileInfo;

    public RecoverySnapshotFileRequest(long recoveryId, long requestSeqNo, ShardId shardId, String repository, IndexId indexId, BlobStoreIndexShardSnapshot.FileInfo fileInfo) {
        super(requestSeqNo, recoveryId, shardId);
        this.repository = repository;
        this.indexId = indexId;
        this.fileInfo = fileInfo;
    }

    public RecoverySnapshotFileRequest(StreamInput in) throws IOException {
        super(in);
        this.repository = in.readString();
        this.indexId = new IndexId(in);
        this.fileInfo = new BlobStoreIndexShardSnapshot.FileInfo(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.repository);
        this.indexId.writeTo(out);
        this.fileInfo.writeTo(out);
    }

    public String getRepository() {
        return this.repository;
    }

    public IndexId getIndexId() {
        return this.indexId;
    }

    public BlobStoreIndexShardSnapshot.FileInfo getFileInfo() {
        return this.fileInfo;
    }
}

