/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.BiPredicate;
import org.apache.lucene.misc.store.DirectIODirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FileSwitchDirectory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.NativeFSLockFactory;
import org.apache.lucene.store.ReadAdvice;
import org.apache.lucene.store.SimpleFSLockFactory;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.util.FeatureFlag;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.codec.vectors.es818.DirectIOIndexInputSupplier;
import org.elasticsearch.index.shard.ShardPath;
import org.elasticsearch.index.store.LuceneFilesExtensions;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.plugins.IndexStorePlugin;

public class FsDirectoryFactory
implements IndexStorePlugin.DirectoryFactory {
    private static final Logger Log = LogManager.getLogger(FsDirectoryFactory.class);
    private static final FeatureFlag MADV_RANDOM_FEATURE_FLAG = new FeatureFlag("madv_random");
    public static final Setting<LockFactory> INDEX_LOCK_FACTOR_SETTING = new Setting<LockFactory>("index.store.fs.fs_lock", "native", s -> switch (s) {
        case "native" -> NativeFSLockFactory.INSTANCE;
        case "simple" -> SimpleFSLockFactory.INSTANCE;
        default -> throw new IllegalArgumentException("unrecognized [index.store.fs.fs_lock] \"" + s + "\": must be native or simple");
    }, Setting.Property.IndexScope, Setting.Property.NodeScope);

    @Override
    public Directory newDirectory(IndexSettings indexSettings, ShardPath path) throws IOException {
        Path location = path.resolveIndex();
        LockFactory lockFactory = indexSettings.getValue(INDEX_LOCK_FACTOR_SETTING);
        Files.createDirectories(location, new FileAttribute[0]);
        return this.newFSDirectory(location, lockFactory, indexSettings);
    }

    protected Directory newFSDirectory(Path location, LockFactory lockFactory, IndexSettings indexSettings) throws IOException {
        String storeType = indexSettings.getSettings().get(IndexModule.INDEX_STORE_TYPE_SETTING.getKey(), IndexModule.Type.FS.getSettingsKey());
        IndexModule.Type type = IndexModule.Type.FS.match(storeType) ? IndexModule.defaultStoreType(IndexModule.NODE_STORE_ALLOW_MMAP.get(indexSettings.getNodeSettings())) : IndexModule.Type.fromSettingsKey(storeType);
        HashSet<String> preLoadExtensions = new HashSet<String>((Collection)indexSettings.getValue(IndexModule.INDEX_STORE_PRE_LOAD_SETTING));
        switch (type) {
            case HYBRIDFS: {
                FSDirectory primaryDirectory = FSDirectory.open(location, lockFactory);
                if (primaryDirectory instanceof MMapDirectory) {
                    MMapDirectory mMapDirectory = (MMapDirectory)primaryDirectory;
                    Directory dir = new HybridDirectory(lockFactory, this.setPreload(mMapDirectory, preLoadExtensions));
                    if (!MADV_RANDOM_FEATURE_FLAG.isEnabled()) {
                        dir = FsDirectoryFactory.disableRandomAdvice(dir);
                    }
                    return dir;
                }
                return primaryDirectory;
            }
            case MMAPFS: {
                Directory dir = this.setPreload(new MMapDirectory(location, lockFactory), preLoadExtensions);
                if (!MADV_RANDOM_FEATURE_FLAG.isEnabled()) {
                    dir = FsDirectoryFactory.disableRandomAdvice(dir);
                }
                return dir;
            }
            case SIMPLEFS: 
            case NIOFS: {
                return new NIOFSDirectory(location, lockFactory);
            }
        }
        throw new AssertionError((Object)("unexpected built-in store type [" + String.valueOf((Object)type) + "]"));
    }

    public MMapDirectory setPreload(MMapDirectory mMapDirectory, Set<String> preLoadExtensions) {
        mMapDirectory.setPreload(FsDirectoryFactory.getPreloadFunc(preLoadExtensions));
        return mMapDirectory;
    }

    static BiPredicate<String, IOContext> getPreloadFunc(Set<String> preLoadExtensions) {
        if (!preLoadExtensions.isEmpty()) {
            if (preLoadExtensions.contains("*")) {
                return MMapDirectory.ALL_FILES;
            }
            return (name, context) -> preLoadExtensions.contains(FileSwitchDirectory.getExtension(name));
        }
        return MMapDirectory.NO_FILES;
    }

    static Directory disableRandomAdvice(Directory dir) {
        return new FilterDirectory(dir){

            @Override
            public IndexInput openInput(String name, IOContext context) throws IOException {
                if (context.readAdvice() == ReadAdvice.RANDOM) {
                    context = context.withReadAdvice(ReadAdvice.NORMAL);
                }
                assert (context.readAdvice() != ReadAdvice.RANDOM);
                return super.openInput(name, context);
            }
        };
    }

    public static boolean isHybridFs(Directory directory) {
        Directory unwrap = FilterDirectory.unwrap(directory);
        return unwrap instanceof HybridDirectory;
    }

    static final class HybridDirectory
    extends NIOFSDirectory
    implements DirectIOIndexInputSupplier {
        private final MMapDirectory delegate;
        private final DirectIODirectory directIODelegate;

        HybridDirectory(LockFactory lockFactory, MMapDirectory delegate) throws IOException {
            super(delegate.getDirectory(), lockFactory);
            DirectIODirectory directIO;
            this.delegate = delegate;
            try {
                directIO = new DirectIODirectory(this, delegate, 8192, 0xA00000L){

                    protected boolean useDirectIO(String name, IOContext context, OptionalLong fileLength) {
                        return true;
                    }
                };
            }
            catch (Exception e) {
                Log.warn("Could not initialize DirectIO access", (Throwable)e);
                directIO = null;
            }
            this.directIODelegate = directIO;
        }

        @Override
        public IndexInput openInput(String name, IOContext context) throws IOException {
            if (HybridDirectory.useDelegate(name, context)) {
                this.ensureOpen();
                this.ensureCanRead(name);
                context = context == Store.READONCE_CHECKSUM ? IOContext.READONCE : context;
                return this.delegate.openInput(name, context);
            }
            return super.openInput(name, context);
        }

        @Override
        public IndexInput openInputDirect(String name, IOContext context) throws IOException {
            if (this.directIODelegate == null) {
                return this.openInput(name, context);
            }
            this.ensureOpen();
            this.ensureCanRead(name);
            Log.debug("Opening {} with direct IO", new Object[]{name});
            return this.directIODelegate.openInput(name, context);
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(() -> super.close(), this.delegate);
        }

        private static String getExtension(String name) {
            int lastDotIndex = name.lastIndexOf(46);
            if (lastDotIndex == -1) {
                return "";
            }
            return name.substring(lastDotIndex + 1);
        }

        static boolean useDelegate(String name, IOContext ioContext) {
            if (ioContext == Store.READONCE_CHECKSUM) {
                return false;
            }
            LuceneFilesExtensions extension = LuceneFilesExtensions.fromExtension(HybridDirectory.getExtension(name));
            return extension != null && extension.shouldMmap() && !HybridDirectory.avoidDelegateForFdtTempFiles(name, extension);
        }

        static boolean avoidDelegateForFdtTempFiles(String name, LuceneFilesExtensions extension) {
            return extension == LuceneFilesExtensions.TMP && name.contains("fdt");
        }

        MMapDirectory getDelegate() {
            return this.delegate;
        }
    }
}

