/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.net.InetAddress;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.IndexSettings;

public interface RoutingFields {
    public static RoutingFields fromIndexSettings(IndexSettings indexSettings) {
        return indexSettings.getMode().buildRoutingFields(indexSettings);
    }

    public RoutingFields addString(String var1, BytesRef var2);

    default public RoutingFields addString(String fieldName, String value) {
        return this.addString(fieldName, new BytesRef(value));
    }

    public RoutingFields addIp(String var1, InetAddress var2);

    public RoutingFields addLong(String var1, long var2);

    public RoutingFields addUnsignedLong(String var1, long var2);

    public RoutingFields addBoolean(String var1, boolean var2);

    public static enum Noop implements RoutingFields
    {
        INSTANCE;


        @Override
        public RoutingFields addString(String fieldName, BytesRef utf8Value) {
            return this;
        }

        @Override
        public RoutingFields addString(String fieldName, String value) {
            return this;
        }

        @Override
        public RoutingFields addIp(String fieldName, InetAddress value) {
            return this;
        }

        @Override
        public RoutingFields addLong(String fieldName, long value) {
            return this;
        }

        @Override
        public RoutingFields addUnsignedLong(String fieldName, long value) {
            return this;
        }

        @Override
        public RoutingFields addBoolean(String fieldName, boolean value) {
            return this;
        }
    }
}

