/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.util.Arrays;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.script.IpFieldScript;

public final class IpScriptDocValues
extends SortedBinaryDocValues {
    private final IpFieldScript script;
    private int cursor;

    IpScriptDocValues(IpFieldScript script) {
        this.script = script;
    }

    @Override
    public boolean advanceExact(int docId) {
        this.script.runForDoc(docId);
        if (this.script.count() == 0) {
            return false;
        }
        Arrays.sort(this.script.values(), 0, this.script.count());
        this.cursor = 0;
        return true;
    }

    @Override
    public BytesRef nextValue() {
        return this.script.values()[this.cursor++];
    }

    @Override
    public int docValueCount() {
        return this.script.count();
    }
}

