/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.codecs.KnnFieldVectorsWriter;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.codecs.hnsw.DefaultFlatVectorScorer;
import org.apache.lucene.codecs.hnsw.FlatVectorsFormat;
import org.apache.lucene.codecs.hnsw.FlatVectorsReader;
import org.apache.lucene.codecs.hnsw.FlatVectorsWriter;
import org.apache.lucene.codecs.lucene99.Lucene99FlatVectorsFormat;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.hnsw.OrdinalTranslatedKnnCollector;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.elasticsearch.index.codec.vectors.reflect.OffHeapByteSizeUtils;
import org.elasticsearch.index.codec.vectors.reflect.OffHeapStats;

public class ES813FlatVectorFormat
extends KnnVectorsFormat {
    static final String NAME = "ES813FlatVectorFormat";
    private static final FlatVectorsFormat format = new Lucene99FlatVectorsFormat(DefaultFlatVectorScorer.INSTANCE);

    public ES813FlatVectorFormat() {
        super(NAME);
    }

    @Override
    public KnnVectorsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        return new ES813FlatVectorWriter(format.fieldsWriter(state));
    }

    @Override
    public KnnVectorsReader fieldsReader(SegmentReadState state) throws IOException {
        return new ES813FlatVectorReader(format.fieldsReader(state));
    }

    @Override
    public int getMaxDimensions(String fieldName) {
        return 4096;
    }

    static class ES813FlatVectorWriter
    extends KnnVectorsWriter {
        private final FlatVectorsWriter writer;

        ES813FlatVectorWriter(FlatVectorsWriter writer) {
            this.writer = writer;
        }

        @Override
        public KnnFieldVectorsWriter<?> addField(FieldInfo fieldInfo) throws IOException {
            return this.writer.addField(fieldInfo);
        }

        @Override
        public void flush(int maxDoc, Sorter.DocMap sortMap) throws IOException {
            this.writer.flush(maxDoc, sortMap);
        }

        @Override
        public void finish() throws IOException {
            this.writer.finish();
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }

        @Override
        public long ramBytesUsed() {
            return this.writer.ramBytesUsed();
        }

        @Override
        public void mergeOneField(FieldInfo fieldInfo, MergeState mergeState) throws IOException {
            this.writer.mergeOneField(fieldInfo, mergeState);
        }
    }

    static class ES813FlatVectorReader
    extends KnnVectorsReader
    implements OffHeapStats {
        private final FlatVectorsReader reader;

        ES813FlatVectorReader(FlatVectorsReader reader) {
            this.reader = reader;
        }

        @Override
        public void checkIntegrity() throws IOException {
            this.reader.checkIntegrity();
        }

        @Override
        public FloatVectorValues getFloatVectorValues(String field) throws IOException {
            return this.reader.getFloatVectorValues(field);
        }

        @Override
        public ByteVectorValues getByteVectorValues(String field) throws IOException {
            return this.reader.getByteVectorValues(field);
        }

        @Override
        public void search(String field, float[] target, KnnCollector knnCollector, Bits acceptDocs) throws IOException {
            this.collectAllMatchingDocs(knnCollector, acceptDocs, this.reader.getRandomVectorScorer(field, target));
        }

        private void collectAllMatchingDocs(KnnCollector knnCollector, Bits acceptDocs, RandomVectorScorer scorer) throws IOException {
            OrdinalTranslatedKnnCollector collector = new OrdinalTranslatedKnnCollector(knnCollector, scorer::ordToDoc);
            Bits acceptedOrds = scorer.getAcceptOrds(acceptDocs);
            for (int i = 0; i < scorer.maxOrd(); ++i) {
                if (acceptedOrds != null && !acceptedOrds.get(i)) continue;
                collector.collect(i, scorer.score(i));
                collector.incVisitedCount(1);
            }
            assert (!collector.earlyTerminated());
        }

        @Override
        public void search(String field, byte[] target, KnnCollector knnCollector, Bits acceptDocs) throws IOException {
            this.collectAllMatchingDocs(knnCollector, acceptDocs, this.reader.getRandomVectorScorer(field, target));
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }

        @Override
        public Map<String, Long> getOffHeapByteSize(FieldInfo fieldInfo) {
            return OffHeapByteSizeUtils.getOffHeapByteSize(this.reader, fieldInfo);
        }
    }
}

