/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.grok;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.LongSupplier;
import org.elasticsearch.grok.shaded.org.joni.Matcher;

public interface MatcherWatchdog {
    public void register(Matcher var1);

    public long maxExecutionTimeInMillis();

    public void unregister(Matcher var1);

    public static MatcherWatchdog newInstance(long interval, long maxExecutionTime, LongSupplier relativeTimeSupplier, BiConsumer<Long, Runnable> scheduler) {
        return new Default(interval, maxExecutionTime, relativeTimeSupplier, scheduler);
    }

    public static MatcherWatchdog noop() {
        return Noop.INSTANCE;
    }

    public static class Default
    implements MatcherWatchdog {
        private final long interval;
        private final long maxExecutionTime;
        private final LongSupplier relativeTimeSupplier;
        private final BiConsumer<Long, Runnable> scheduler;
        private final AtomicInteger registered = new AtomicInteger(0);
        private final AtomicBoolean running = new AtomicBoolean(false);
        final ConcurrentHashMap<Matcher, Long> registry = new ConcurrentHashMap();

        private Default(long interval, long maxExecutionTime, LongSupplier relativeTimeSupplier, BiConsumer<Long, Runnable> scheduler) {
            this.interval = interval;
            this.maxExecutionTime = maxExecutionTime;
            this.relativeTimeSupplier = relativeTimeSupplier;
            this.scheduler = scheduler;
        }

        @Override
        public void register(Matcher matcher) {
            this.registered.getAndIncrement();
            Long previousValue = this.registry.put(matcher, this.relativeTimeSupplier.getAsLong());
            if (this.running.compareAndSet(false, true)) {
                this.scheduler.accept(this.interval, this::interruptLongRunningExecutions);
            }
            assert (previousValue == null);
        }

        @Override
        public long maxExecutionTimeInMillis() {
            return this.maxExecutionTime;
        }

        @Override
        public void unregister(Matcher matcher) {
            Long previousValue = this.registry.remove(matcher);
            this.registered.decrementAndGet();
            assert (previousValue != null);
        }

        private void interruptLongRunningExecutions() {
            long currentRelativeTime = this.relativeTimeSupplier.getAsLong();
            for (Map.Entry<Matcher, Long> entry : this.registry.entrySet()) {
                if (currentRelativeTime - entry.getValue() <= this.maxExecutionTime) continue;
                entry.getKey().interrupt();
            }
            if (this.registered.get() > 0) {
                this.scheduler.accept(this.interval, this::interruptLongRunningExecutions);
            } else {
                this.running.set(false);
            }
        }
    }

    public static class Noop
    implements MatcherWatchdog {
        private static final Noop INSTANCE = new Noop();

        private Noop() {
        }

        @Override
        public void register(Matcher matcher) {
        }

        @Override
        public long maxExecutionTimeInMillis() {
            return Long.MAX_VALUE;
        }

        @Override
        public void unregister(Matcher matcher) {
        }
    }
}

