/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.CountingStreamOutput;
import org.elasticsearch.common.io.stream.FilterStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.OutputStreamStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;

public abstract class DelayableWriteable<T extends Writeable>
implements Writeable,
Releasable {
    public static <T extends Writeable> DelayableWriteable<T> referencing(T reference) {
        return new Referencing<T>(reference);
    }

    public static <T extends Writeable> DelayableWriteable<T> delayed(Writeable.Reader<T> reader, StreamInput in) throws IOException {
        return new Serialized<T>(reader, in.getTransportVersion(), in.namedWriteableRegistry(), in.getTransportVersion().onOrAfter(TransportVersions.COMPRESS_DELAYABLE_WRITEABLE) ? in.readReleasableBytesReference(in.readInt()) : in.readReleasableBytesReference());
    }

    public static <T extends Writeable> DelayableWriteable<T> referencing(Writeable.Reader<T> reader, StreamInput in) throws IOException {
        try (ReleasableBytesReference serialized = in.getTransportVersion().onOrAfter(TransportVersions.COMPRESS_DELAYABLE_WRITEABLE) ? in.readReleasableBytesReference(in.readInt()) : in.readReleasableBytesReference();){
            Referencing<Writeable> referencing = new Referencing<Writeable>((Writeable)DelayableWriteable.deserialize(reader, in.getTransportVersion(), in.namedWriteableRegistry(), serialized));
            return referencing;
        }
    }

    private DelayableWriteable() {
    }

    public abstract Serialized<T> asSerialized(Writeable.Reader<T> var1, NamedWriteableRegistry var2);

    public abstract T expand();

    public abstract boolean isSerialized();

    public abstract long getSerializedSize();

    public static long getSerializedSize(Writeable ref) {
        CountingStreamOutput out = new CountingStreamOutput();
        try {
            out.setTransportVersion(TransportVersion.current());
            ref.writeTo(out);
            long l = out.size();
            out.close();
            return l;
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exc) {
                throw new UncheckedIOException(exc);
            }
        }
    }

    private static <T> T deserialize(Writeable.Reader<T> reader, TransportVersion serializedAtVersion, NamedWriteableRegistry registry, BytesReference serialized) throws IOException {
        try (StreamInput in = serializedAtVersion.onOrAfter(TransportVersions.COMPRESS_DELAYABLE_WRITEABLE) ? CompressorFactory.COMPRESSOR.threadLocalStreamInput(serialized.streamInput()) : serialized.streamInput();){
            T t = reader.read(DelayableWriteable.wrapWithDeduplicatorStreamInput(in, serializedAtVersion, registry));
            return t;
        }
    }

    public static StreamInput wrapWithDeduplicatorStreamInput(StreamInput in, TransportVersion serializedAtVersion, @Nullable NamedWriteableRegistry registry) {
        FilterStreamInput out = registry == null ? new DeduplicateStreamInput(in, new DeduplicatorCache()) : new DeduplicateNamedWriteableAwareStreamInput(in, registry, new DeduplicatorCache());
        ((StreamInput)out).setTransportVersion(serializedAtVersion);
        return out;
    }

    private static class Referencing<T extends Writeable>
    extends DelayableWriteable<T> {
        private final T reference;

        private Referencing(T reference) {
            this.reference = reference;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (out.getTransportVersion().onOrAfter(TransportVersions.COMPRESS_DELAYABLE_WRITEABLE)) {
                out.writeWithSizePrefix((Writeable)this.reference);
            } else {
                out.legacyWriteWithSizePrefix((Writeable)this.reference);
            }
        }

        @Override
        public T expand() {
            return this.reference;
        }

        @Override
        public Serialized<T> asSerialized(Writeable.Reader<T> reader, NamedWriteableRegistry registry) {
            BytesStreamOutput buffer = new BytesStreamOutput();
            try (OutputStreamStreamOutput out = new OutputStreamStreamOutput(CompressorFactory.COMPRESSOR.threadLocalOutputStream(buffer));){
                out.setTransportVersion(TransportVersion.current());
                this.reference.writeTo(out);
            }
            catch (IOException e) {
                throw new RuntimeException("unexpected error writing writeable to buffer", e);
            }
            return new Serialized<T>(reader, TransportVersion.current(), registry, ReleasableBytesReference.wrap(buffer.bytes()));
        }

        @Override
        public boolean isSerialized() {
            return false;
        }

        @Override
        public long getSerializedSize() {
            return DelayableWriteable.getSerializedSize(this.reference);
        }

        @Override
        public void close() {
        }
    }

    public static class Serialized<T extends Writeable>
    extends DelayableWriteable<T> {
        private final Writeable.Reader<T> reader;
        private final TransportVersion serializedAtVersion;
        private final NamedWriteableRegistry registry;
        private final ReleasableBytesReference serialized;

        private Serialized(Writeable.Reader<T> reader, TransportVersion serializedAtVersion, NamedWriteableRegistry registry, ReleasableBytesReference serialized) {
            this.reader = reader;
            this.serializedAtVersion = serializedAtVersion;
            this.registry = registry;
            this.serialized = serialized;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (out.getTransportVersion() == this.serializedAtVersion) {
                if (out.getTransportVersion().onOrAfter(TransportVersions.COMPRESS_DELAYABLE_WRITEABLE)) {
                    out.writeInt(this.serialized.length());
                    this.serialized.writeTo(out);
                } else {
                    out.writeBytesReference(this.serialized);
                }
            } else {
                Serialized.referencing(this.expand()).writeTo(out);
            }
        }

        @Override
        public T expand() {
            try {
                return (T)((Writeable)DelayableWriteable.deserialize(this.reader, this.serializedAtVersion, this.registry, this.serialized));
            }
            catch (IOException e) {
                throw new RuntimeException("unexpected error expanding serialized delayed writeable", e);
            }
        }

        @Override
        public Serialized<T> asSerialized(Writeable.Reader<T> reader, NamedWriteableRegistry registry) {
            return this;
        }

        @Override
        public boolean isSerialized() {
            return true;
        }

        @Override
        public long getSerializedSize() {
            return this.serialized.length();
        }

        @Override
        public void close() {
            this.serialized.close();
        }
    }

    private static class DeduplicateStreamInput
    extends FilterStreamInput
    implements Deduplicator {
        private final Deduplicator deduplicator;

        private DeduplicateStreamInput(StreamInput delegate, Deduplicator deduplicator) {
            super(delegate);
            this.deduplicator = deduplicator;
        }

        @Override
        public <T> T deduplicate(T object) {
            return this.deduplicator.deduplicate(object);
        }
    }

    private static class DeduplicatorCache
    implements Deduplicator {
        private static final int MAX_SIZE = 1024;
        private Map<Object, Object> cache = null;

        private DeduplicatorCache() {
        }

        @Override
        public <T> T deduplicate(T object) {
            if (this.cache == null) {
                this.cache = new HashMap<Object, Object>();
                this.cache.put(object, object);
            } else if (this.cache.size() < 1024) {
                object = this.cache.computeIfAbsent(object, o -> o);
            }
            return object;
        }
    }

    public static interface Deduplicator {
        public <T> T deduplicate(T var1);
    }

    private static class DeduplicateNamedWriteableAwareStreamInput
    extends NamedWriteableAwareStreamInput
    implements Deduplicator {
        private final Deduplicator deduplicator;

        private DeduplicateNamedWriteableAwareStreamInput(StreamInput delegate, NamedWriteableRegistry registry, Deduplicator deduplicator) {
            super(delegate, registry);
            this.deduplicator = deduplicator;
        }

        @Override
        public <T> T deduplicate(T object) {
            return this.deduplicator.deduplicate(object);
        }
    }
}

