/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.allocator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.IntroSorter;
import org.elasticsearch.cluster.ClusterInfo;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.metadata.SingleNodeShutdownMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ExpectedShardSizeEstimator;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.AllocateUnassignedDecision;
import org.elasticsearch.cluster.routing.allocation.AllocationDecision;
import org.elasticsearch.cluster.routing.allocation.MoveDecision;
import org.elasticsearch.cluster.routing.allocation.NodeAllocationResult;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.ShardAllocationDecision;
import org.elasticsearch.cluster.routing.allocation.WriteLoadForecaster;
import org.elasticsearch.cluster.routing.allocation.allocator.BalancerSettings;
import org.elasticsearch.cluster.routing.allocation.allocator.BalancingWeights;
import org.elasticsearch.cluster.routing.allocation.allocator.BalancingWeightsFactory;
import org.elasticsearch.cluster.routing.allocation.allocator.DesiredBalanceMetrics;
import org.elasticsearch.cluster.routing.allocation.allocator.GlobalBalancingWeightsFactory;
import org.elasticsearch.cluster.routing.allocation.allocator.NodeSorters;
import org.elasticsearch.cluster.routing.allocation.allocator.ShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.allocator.WeightFunction;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.gateway.PriorityComparator;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.injection.guice.Inject;

public class BalancedShardsAllocator
implements ShardsAllocator {
    private static final Logger logger = LogManager.getLogger(BalancedShardsAllocator.class);
    public static final Setting<Float> SHARD_BALANCE_FACTOR_SETTING = Setting.floatSetting("cluster.routing.allocation.balance.shard", 0.45f, 0.0f, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Float> INDEX_BALANCE_FACTOR_SETTING = Setting.floatSetting("cluster.routing.allocation.balance.index", 0.55f, 0.0f, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Float> WRITE_LOAD_BALANCE_FACTOR_SETTING = Setting.floatSetting("cluster.routing.allocation.balance.write_load", 10.0f, 0.0f, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Float> DISK_USAGE_BALANCE_FACTOR_SETTING = Setting.floatSetting("cluster.routing.allocation.balance.disk_usage", 2.0E-11f, 0.0f, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Float> THRESHOLD_SETTING = Setting.floatSetting("cluster.routing.allocation.balance.threshold", 1.0f, 1.0f, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private final BalancerSettings balancerSettings;
    private final WriteLoadForecaster writeLoadForecaster;
    private final BalancingWeightsFactory balancingWeightsFactory;

    public BalancedShardsAllocator() {
        this(Settings.EMPTY);
    }

    public BalancedShardsAllocator(Settings settings) {
        this(new BalancerSettings(settings), WriteLoadForecaster.DEFAULT);
    }

    public BalancedShardsAllocator(BalancerSettings balancerSettings, WriteLoadForecaster writeLoadForecaster) {
        this(balancerSettings, writeLoadForecaster, new GlobalBalancingWeightsFactory(balancerSettings));
    }

    @Inject
    public BalancedShardsAllocator(BalancerSettings balancerSettings, WriteLoadForecaster writeLoadForecaster, BalancingWeightsFactory balancingWeightsFactory) {
        this.balancerSettings = balancerSettings;
        this.writeLoadForecaster = writeLoadForecaster;
        this.balancingWeightsFactory = balancingWeightsFactory;
    }

    @Override
    public void allocate(RoutingAllocation allocation) {
        if (allocation.metadata().hasAnyIndices()) {
            this.writeLoadForecaster.refreshLicense();
        }
        assert (!allocation.ignoreDisable());
        if (allocation.routingNodes().size() == 0) {
            this.failAllocationOfNewPrimaries(allocation);
            return;
        }
        BalancingWeights balancingWeights = this.balancingWeightsFactory.create();
        Balancer balancer = new Balancer(this.writeLoadForecaster, allocation, this.balancerSettings.getThreshold(), balancingWeights);
        balancer.allocateUnassigned();
        balancer.moveShards();
        balancer.balance();
        this.collectAndRecordNodeWeightStats(balancer, balancingWeights, allocation);
    }

    private void collectAndRecordNodeWeightStats(Balancer balancer, BalancingWeights balancingWeights, RoutingAllocation allocation) {
        HashMap<DiscoveryNode, DesiredBalanceMetrics.NodeWeightStats> nodeLevelWeights = new HashMap<DiscoveryNode, DesiredBalanceMetrics.NodeWeightStats>();
        for (Map.Entry<String, ModelNode> entry : balancer.nodes.entrySet()) {
            ModelNode node = entry.getValue();
            WeightFunction weightFunction = balancingWeights.weightFunctionForNode(node.routingNode);
            float nodeWeight = weightFunction.calculateNodeWeight(node.numShards(), balancer.avgShardsPerNode(), node.writeLoad(), balancer.avgWriteLoadPerNode(), node.diskUsageInBytes(), balancer.avgDiskUsageInBytesPerNode());
            nodeLevelWeights.put(node.routingNode.node(), new DesiredBalanceMetrics.NodeWeightStats(node.numShards(), node.diskUsageInBytes(), node.writeLoad(), nodeWeight));
        }
        allocation.routingNodes().setBalanceWeightStatsPerNode(nodeLevelWeights);
    }

    @Override
    public ShardAllocationDecision decideShardAllocation(ShardRouting shard, RoutingAllocation allocation) {
        Balancer balancer = new Balancer(this.writeLoadForecaster, allocation, this.balancerSettings.getThreshold(), this.balancingWeightsFactory.create());
        AllocateUnassignedDecision allocateUnassignedDecision = AllocateUnassignedDecision.NOT_TAKEN;
        MoveDecision moveDecision = MoveDecision.NOT_TAKEN;
        ProjectIndex index = new ProjectIndex(allocation, shard);
        if (shard.unassigned()) {
            allocateUnassignedDecision = balancer.decideAllocateUnassigned(index, shard);
        } else {
            moveDecision = balancer.decideMove(index, shard);
            if (moveDecision.isDecisionTaken() && moveDecision.canRemain()) {
                moveDecision = balancer.decideRebalance(index, shard, moveDecision.getCanRemainDecision());
            }
        }
        return new ShardAllocationDecision(allocateUnassignedDecision, moveDecision);
    }

    private void failAllocationOfNewPrimaries(RoutingAllocation allocation) {
        RoutingNodes routingNodes = allocation.routingNodes();
        assert (routingNodes.size() == 0) : routingNodes;
        RoutingNodes.UnassignedShards.UnassignedIterator unassignedIterator = routingNodes.unassigned().iterator();
        while (unassignedIterator.hasNext()) {
            ShardRouting shardRouting = unassignedIterator.next();
            UnassignedInfo unassignedInfo = shardRouting.unassignedInfo();
            if (!shardRouting.primary() || unassignedInfo.lastAllocationStatus() != UnassignedInfo.AllocationStatus.NO_ATTEMPT) continue;
            unassignedIterator.updateUnassigned(new UnassignedInfo(unassignedInfo.reason(), unassignedInfo.message(), unassignedInfo.failure(), unassignedInfo.failedAllocations(), unassignedInfo.unassignedTimeNanos(), unassignedInfo.unassignedTimeMillis(), unassignedInfo.delayed(), UnassignedInfo.AllocationStatus.DECIDERS_NO, unassignedInfo.failedNodeIds(), unassignedInfo.lastAllocatedNodeId()), shardRouting.recoverySource(), allocation.changes());
        }
    }

    public static class Balancer {
        private final WriteLoadForecaster writeLoadForecaster;
        private final RoutingAllocation allocation;
        private final RoutingNodes routingNodes;
        private final Metadata metadata;
        private final float threshold;
        private final float avgShardsPerNode;
        private final double avgWriteLoadPerNode;
        private final double avgDiskUsageInBytesPerNode;
        private final Map<String, ModelNode> nodes;
        private final BalancingWeights balancingWeights;
        private final NodeSorters nodeSorters;
        private static final Comparator<ShardRouting> BY_DESCENDING_SHARD_ID = (s1, s2) -> Integer.compare(s2.id(), s1.id());
        private ShardRouting[] shardRoutingsOnMaxWeightNode;

        private Balancer(WriteLoadForecaster writeLoadForecaster, RoutingAllocation allocation, float threshold, BalancingWeights balancingWeights) {
            this.writeLoadForecaster = writeLoadForecaster;
            this.allocation = allocation;
            this.routingNodes = allocation.routingNodes();
            this.metadata = allocation.metadata();
            this.threshold = threshold;
            this.avgShardsPerNode = WeightFunction.avgShardPerNode(this.metadata, this.routingNodes);
            this.avgWriteLoadPerNode = WeightFunction.avgWriteLoadPerNode(writeLoadForecaster, this.metadata, this.routingNodes);
            this.avgDiskUsageInBytesPerNode = WeightFunction.avgDiskUsageInBytesPerNode(allocation.clusterInfo(), this.metadata, this.routingNodes);
            this.nodes = Collections.unmodifiableMap(this.buildModelFromAssigned());
            this.nodeSorters = balancingWeights.createNodeSorters(this.nodesArray(), this);
            this.balancingWeights = balancingWeights;
        }

        private static long getShardDiskUsageInBytes(ShardRouting shardRouting, IndexMetadata indexMetadata, ClusterInfo clusterInfo) {
            if (indexMetadata.ignoreDiskWatermarks()) {
                return 0L;
            }
            return Math.max(indexMetadata.getForecastedShardSizeInBytes().orElse(0L), clusterInfo.getShardSize(shardRouting, 0L));
        }

        private float getShardWriteLoad(ProjectIndex index) {
            ProjectMetadata projectMetadata = this.metadata.getProject(index.project);
            return (float)this.writeLoadForecaster.getForecastedWriteLoad(projectMetadata.index(index.indexName)).orElse(0.0);
        }

        private float maxShardSizeBytes(ProjectIndex index) {
            IndexMetadata indexMetadata = this.indexMetadata(index);
            if (indexMetadata.ignoreDiskWatermarks()) {
                return 0.0f;
            }
            long maxShardSizeBytes = indexMetadata.getForecastedShardSizeInBytes().orElse(0L);
            for (int shard = 0; shard < indexMetadata.getNumberOfShards(); ++shard) {
                ShardId shardId = new ShardId(indexMetadata.getIndex(), shard);
                maxShardSizeBytes = Balancer.maxWithNullable(maxShardSizeBytes, this.allocation.clusterInfo().getShardSize(shardId, true));
                maxShardSizeBytes = Balancer.maxWithNullable(maxShardSizeBytes, this.allocation.clusterInfo().getShardSize(shardId, false));
            }
            return maxShardSizeBytes;
        }

        private static long maxWithNullable(long accumulator, Long newValue) {
            return newValue == null ? accumulator : Math.max(accumulator, newValue);
        }

        private ModelNode[] nodesArray() {
            return (ModelNode[])this.nodes.values().toArray(ModelNode[]::new);
        }

        public float avgShardsPerNode(ProjectIndex index) {
            return (float)this.indexMetadata(index).getTotalNumberOfShards() / (float)this.nodes.size();
        }

        public float avgShardsPerNode() {
            return this.avgShardsPerNode;
        }

        public double avgWriteLoadPerNode() {
            return this.avgWriteLoadPerNode;
        }

        public double avgDiskUsageInBytesPerNode() {
            return this.avgDiskUsageInBytesPerNode;
        }

        private static float absDelta(float lower, float higher) {
            assert (higher >= lower) : higher + " lt " + lower + " but was expected to be gte";
            return Math.abs(higher - lower);
        }

        private static boolean lessThan(float delta, float threshold) {
            return delta <= threshold + 0.001f;
        }

        private IndexMetadata indexMetadata(ProjectIndex index) {
            return this.metadata.getProject(index.project).index(index.indexName);
        }

        private void balance() {
            if (logger.isTraceEnabled()) {
                logger.trace("Start balancing cluster");
            }
            if (this.allocation.hasPendingAsyncFetch()) {
                logger.debug("skipping rebalance due to in-flight shard/store fetches");
                return;
            }
            if (this.allocation.deciders().canRebalance(this.allocation).type() != Decision.Type.YES) {
                logger.trace("skipping rebalance as it is disabled");
                return;
            }
            for (NodeSorter nodeSorter : this.nodeSorters) {
                if (nodeSorter.modelNodes.length < 2) {
                    logger.trace("skipping rebalance as the partition has single node only");
                    continue;
                }
                this.balanceByWeights(nodeSorter);
            }
        }

        private MoveDecision decideRebalance(ProjectIndex index, ShardRouting shard, Decision canRemain) {
            NodeSorter sorter = this.nodeSorters.sorterForShard(shard);
            index.assertMatch(shard);
            if (!shard.started()) {
                return MoveDecision.NOT_TAKEN;
            }
            Decision canRebalance = this.allocation.deciders().canRebalance(shard, this.allocation);
            sorter.reset(index);
            ModelNode[] modelNodes = sorter.modelNodes;
            String currentNodeId = shard.currentNodeId();
            ModelNode currentNode = null;
            for (ModelNode node : modelNodes) {
                if (!node.getNodeId().equals(currentNodeId)) continue;
                currentNode = node;
                break;
            }
            assert (currentNode != null) : "currently assigned node could not be found";
            float currentWeight = sorter.getWeightFunction().calculateNodeWeightWithIndex(this, currentNode, index);
            AllocationDeciders deciders = this.allocation.deciders();
            Decision.Type rebalanceDecisionType = Decision.Type.NO;
            ModelNode targetNode = null;
            ArrayList<Tuple<ModelNode, Decision>> betterBalanceNodes = new ArrayList<Tuple<ModelNode, Decision>>();
            ArrayList<Tuple<ModelNode, Decision>> sameBalanceNodes = new ArrayList<Tuple<ModelNode, Decision>>();
            ArrayList<Tuple<ModelNode, Decision>> worseBalanceNodes = new ArrayList<Tuple<ModelNode, Decision>>();
            for (ModelNode modelNode : modelNodes) {
                if (modelNode == currentNode) continue;
                Decision decision = deciders.canAllocate(shard, modelNode.getRoutingNode(), this.allocation);
                float nodeWeight = sorter.getWeightFunction().calculateNodeWeightWithIndex(this, modelNode, index);
                boolean betterWeightThanCurrent = nodeWeight <= currentWeight;
                boolean rebalanceConditionsMet = false;
                if (betterWeightThanCurrent) {
                    float localThreshold;
                    float currentDelta = Balancer.absDelta(nodeWeight, currentWeight);
                    boolean deltaAboveThreshold = !Balancer.lessThan(currentDelta, localThreshold = sorter.minWeightDelta() * this.threshold);
                    boolean betterWeightWithShardAdded = nodeWeight + localThreshold < currentWeight;
                    boolean bl = rebalanceConditionsMet = deltaAboveThreshold && betterWeightWithShardAdded;
                    if (rebalanceConditionsMet && decision.type().higherThan(rebalanceDecisionType)) {
                        rebalanceDecisionType = decision.type();
                        targetNode = modelNode;
                    }
                }
                Tuple<ModelNode, Decision> nodeResult = Tuple.tuple(modelNode, decision);
                if (rebalanceConditionsMet) {
                    betterBalanceNodes.add(nodeResult);
                    continue;
                }
                if (betterWeightThanCurrent) {
                    sameBalanceNodes.add(nodeResult);
                    continue;
                }
                worseBalanceNodes.add(nodeResult);
            }
            int weightRanking = 0;
            ArrayList<NodeAllocationResult> nodeDecisions = new ArrayList<NodeAllocationResult>(modelNodes.length - 1);
            for (Tuple tuple : betterBalanceNodes) {
                nodeDecisions.add(new NodeAllocationResult(((ModelNode)tuple.v1()).routingNode.node(), AllocationDecision.fromDecisionType(((Decision)tuple.v2()).type()), (Decision)tuple.v2(), ++weightRanking));
            }
            int currentNodeWeightRanking = ++weightRanking;
            for (Tuple tuple : sameBalanceNodes) {
                AllocationDecision nodeDecision = ((Decision)tuple.v2()).type() == Decision.Type.NO ? AllocationDecision.NO : AllocationDecision.WORSE_BALANCE;
                nodeDecisions.add(new NodeAllocationResult(((ModelNode)tuple.v1()).routingNode.node(), nodeDecision, (Decision)tuple.v2(), currentNodeWeightRanking));
            }
            for (Tuple tuple : worseBalanceNodes) {
                AllocationDecision nodeDecision = ((Decision)tuple.v2()).type() == Decision.Type.NO ? AllocationDecision.NO : AllocationDecision.WORSE_BALANCE;
                nodeDecisions.add(new NodeAllocationResult(((ModelNode)tuple.v1()).routingNode.node(), nodeDecision, (Decision)tuple.v2(), ++weightRanking));
            }
            if (canRebalance.type() != Decision.Type.YES || this.allocation.hasPendingAsyncFetch()) {
                return MoveDecision.rebalance(canRemain, canRebalance, this.allocation.hasPendingAsyncFetch() ? AllocationDecision.AWAITING_INFO : AllocationDecision.fromDecisionType(canRebalance.type()), null, currentNodeWeightRanking, nodeDecisions);
            }
            return MoveDecision.rebalance(canRemain, canRebalance, AllocationDecision.fromDecisionType(rebalanceDecisionType), targetNode != null ? targetNode.routingNode.node() : null, currentNodeWeightRanking, nodeDecisions);
        }

        private void balanceByWeights(NodeSorter sorter) {
            AllocationDeciders deciders = this.allocation.deciders();
            ModelNode[] modelNodes = sorter.modelNodes;
            float[] weights = sorter.weights;
            block0: for (ProjectIndex index : this.buildWeightOrderedIndices(sorter)) {
                IndexMetadata indexMetadata = this.indexMetadata(index);
                int relevantNodes = 0;
                for (int i = 0; i < modelNodes.length; ++i) {
                    ModelNode modelNode = modelNodes[i];
                    if (modelNode.getIndex(index) == null && deciders.canAllocate(indexMetadata, modelNode.getRoutingNode(), this.allocation).type() == Decision.Type.NO) continue;
                    modelNodes[i] = modelNodes[relevantNodes];
                    modelNodes[relevantNodes] = modelNode;
                    ++relevantNodes;
                }
                if (relevantNodes < 2) continue;
                sorter.reset(index, 0, relevantNodes);
                int lowIdx = 0;
                int highIdx = relevantNodes - 1;
                float localThreshold = sorter.minWeightDelta() * this.threshold;
                while (true) {
                    ModelNode minNode = modelNodes[lowIdx];
                    ModelNode maxNode = modelNodes[highIdx];
                    if (maxNode.numShards(index) > 0) {
                        float delta = Balancer.absDelta(weights[lowIdx], weights[highIdx]);
                        if (Balancer.lessThan(delta, localThreshold)) {
                            if (lowIdx <= 0 || highIdx - 1 <= 0 || !(Balancer.absDelta(weights[0], weights[highIdx - 1]) > localThreshold)) {
                                if (!logger.isTraceEnabled()) continue block0;
                                logger.trace("Stop balancing index [{}]  min_node [{}] weight: [{}] max_node [{}] weight: [{}] delta: [{}]", (Object)index, (Object)maxNode.getNodeId(), (Object)Float.valueOf(weights[highIdx]), (Object)minNode.getNodeId(), (Object)Float.valueOf(weights[lowIdx]), (Object)Float.valueOf(delta));
                                continue block0;
                            }
                        } else {
                            if (logger.isTraceEnabled()) {
                                logger.trace("Balancing from node [{}] weight: [{}] to node [{}] weight: [{}] delta: [{}]", (Object)maxNode.getNodeId(), (Object)Float.valueOf(weights[highIdx]), (Object)minNode.getNodeId(), (Object)Float.valueOf(weights[lowIdx]), (Object)Float.valueOf(delta));
                            }
                            if (delta <= localThreshold) {
                                logger.trace("Couldn't find shard to relocate from node [{}] to node [{}]", (Object)maxNode.getNodeId(), (Object)minNode.getNodeId());
                            } else if (this.tryRelocateShard(minNode, maxNode, index)) {
                                weights[lowIdx] = sorter.weight(modelNodes[lowIdx]);
                                weights[highIdx] = sorter.weight(modelNodes[highIdx]);
                                sorter.sort(0, relevantNodes);
                                lowIdx = 0;
                                highIdx = relevantNodes - 1;
                                continue;
                            }
                        }
                    }
                    if (lowIdx < highIdx - 1) {
                        ++lowIdx;
                        continue;
                    }
                    if (lowIdx <= 0) continue block0;
                    lowIdx = 0;
                    --highIdx;
                }
            }
        }

        private ProjectIndex[] buildWeightOrderedIndices(NodeSorter sorter) {
            final ProjectIndex[] indices = (ProjectIndex[])this.allocation.globalRoutingTable().routingTables().entrySet().stream().flatMap(entry -> ((RoutingTable)entry.getValue()).indicesRouting().keySet().stream().map(index -> new ProjectIndex((ProjectId)entry.getKey(), (String)index))).toArray(ProjectIndex[]::new);
            final float[] deltas = new float[indices.length];
            for (int i = 0; i < deltas.length; ++i) {
                sorter.reset(indices[i]);
                deltas[i] = sorter.delta();
            }
            new IntroSorter(this){
                float pivotWeight;

                @Override
                protected void swap(int i, int j) {
                    ProjectIndex tmpIdx = indices[i];
                    indices[i] = indices[j];
                    indices[j] = tmpIdx;
                    float tmpDelta = deltas[i];
                    deltas[i] = deltas[j];
                    deltas[j] = tmpDelta;
                }

                @Override
                protected int compare(int i, int j) {
                    return Float.compare(deltas[j], deltas[i]);
                }

                @Override
                protected void setPivot(int i) {
                    this.pivotWeight = deltas[i];
                }

                @Override
                protected int comparePivot(int j) {
                    return Float.compare(deltas[j], this.pivotWeight);
                }
            }.sort(0, deltas.length);
            return indices;
        }

        public void moveShards() {
            Iterator<ShardRouting> it = this.allocation.routingNodes().nodeInterleavedShardIterator();
            while (it.hasNext()) {
                ShardRouting shardRouting = it.next();
                ProjectIndex index = this.projectIndex(shardRouting);
                MoveDecision moveDecision = this.decideMove(index, shardRouting);
                if (moveDecision.isDecisionTaken() && moveDecision.forceMove()) {
                    ModelNode sourceNode = this.nodes.get(shardRouting.currentNodeId());
                    ModelNode targetNode = this.nodes.get(moveDecision.getTargetNode().getId());
                    sourceNode.removeShard(index, shardRouting);
                    Tuple<ShardRouting, ShardRouting> relocatingShards = this.routingNodes.relocateShard(shardRouting, targetNode.getNodeId(), this.allocation.clusterInfo().getShardSize(shardRouting, -1L), "move", this.allocation.changes());
                    ShardRouting shard = relocatingShards.v2();
                    targetNode.addShard(this.projectIndex(shard), shard);
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("Moved shard [{}] to node [{}]", (Object)shardRouting, (Object)targetNode.getRoutingNode());
                    continue;
                }
                if (!moveDecision.isDecisionTaken() || moveDecision.canRemain()) continue;
                logger.trace("[{}][{}] can't move", (Object)shardRouting.index(), (Object)shardRouting.id());
            }
        }

        public MoveDecision decideMove(ProjectIndex index, ShardRouting shardRouting) {
            boolean shardsOnReplacedNode;
            NodeSorter sorter = this.nodeSorters.sorterForShard(shardRouting);
            index.assertMatch(shardRouting);
            if (!shardRouting.started()) {
                return MoveDecision.NOT_TAKEN;
            }
            ModelNode sourceNode = this.nodes.get(shardRouting.currentNodeId());
            assert (sourceNode != null && sourceNode.containsShard(index, shardRouting));
            RoutingNode routingNode = sourceNode.getRoutingNode();
            Decision canRemain = this.allocation.deciders().canRemain(shardRouting, routingNode, this.allocation);
            if (canRemain.type() != Decision.Type.NO) {
                return MoveDecision.remain(canRemain);
            }
            sorter.reset(index);
            MoveDecision moveDecision = this.decideMove(sorter, shardRouting, sourceNode, canRemain, this::decideCanAllocate);
            if (!moveDecision.canRemain() && !moveDecision.forceMove() && (shardsOnReplacedNode = this.allocation.metadata().nodeShutdowns().contains(shardRouting.currentNodeId(), SingleNodeShutdownMetadata.Type.REPLACE))) {
                return this.decideMove(sorter, shardRouting, sourceNode, canRemain, this::decideCanForceAllocateForVacate);
            }
            return moveDecision;
        }

        private MoveDecision decideMove(NodeSorter sorter, ShardRouting shardRouting, ModelNode sourceNode, Decision remainDecision, BiFunction<ShardRouting, RoutingNode, Decision> decider) {
            boolean explain = this.allocation.debugDecision();
            Decision.Type bestDecision = Decision.Type.NO;
            RoutingNode targetNode = null;
            ArrayList<NodeAllocationResult> nodeResults = explain ? new ArrayList<NodeAllocationResult>() : null;
            int weightRanking = 0;
            for (ModelNode currentNode : sorter.modelNodes) {
                if (currentNode == sourceNode) continue;
                RoutingNode target = currentNode.getRoutingNode();
                Decision allocationDecision = decider.apply(shardRouting, target);
                if (explain) {
                    nodeResults.add(new NodeAllocationResult(currentNode.getRoutingNode().node(), allocationDecision, ++weightRanking));
                }
                if (!allocationDecision.type().higherThan(bestDecision) || (bestDecision = allocationDecision.type()) != Decision.Type.YES) continue;
                targetNode = target;
                if (!explain) break;
            }
            return MoveDecision.move(remainDecision, AllocationDecision.fromDecisionType(bestDecision), targetNode != null ? targetNode.node() : null, nodeResults);
        }

        private Decision decideCanAllocate(ShardRouting shardRouting, RoutingNode target) {
            return this.allocation.deciders().canAllocate(shardRouting, target, this.allocation);
        }

        private Decision decideCanForceAllocateForVacate(ShardRouting shardRouting, RoutingNode target) {
            return this.allocation.deciders().canForceAllocateDuringReplace(shardRouting, target, this.allocation);
        }

        private Map<String, ModelNode> buildModelFromAssigned() {
            Map<String, ModelNode> nodes = Maps.newMapWithExpectedSize(this.routingNodes.size());
            for (RoutingNode rn : this.routingNodes) {
                ModelNode node = new ModelNode(this.writeLoadForecaster, this.metadata, this.allocation.clusterInfo(), rn);
                nodes.put(rn.nodeId(), node);
                for (ShardRouting shard : rn) {
                    assert (rn.nodeId().equals(shard.currentNodeId()));
                    if (shard.state() == ShardRoutingState.RELOCATING) continue;
                    node.addShard(this.projectIndex(shard), shard);
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("Assigned shard [{}] to node [{}]", (Object)shard, (Object)node.getNodeId());
                }
            }
            return nodes;
        }

        private void allocateUnassigned() {
            RoutingNodes.UnassignedShards unassigned = this.routingNodes.unassigned();
            assert (!this.nodes.isEmpty());
            if (logger.isTraceEnabled()) {
                logger.trace("Start allocating unassigned shards");
            }
            if (unassigned.isEmpty()) {
                return;
            }
            PriorityComparator secondaryComparator = PriorityComparator.getAllocationComparator(this.allocation);
            Comparator comparator = (o1, o2) -> {
                if (o1.primary() ^ o2.primary()) {
                    return o1.primary() ? -1 : 1;
                }
                if (o1.getIndexName().compareTo(o2.getIndexName()) == 0) {
                    return o1.getId() - o2.getId();
                }
                int secondary = secondaryComparator.compare((ShardRouting)o1, (ShardRouting)o2);
                assert (secondary != 0) : "Index names are equal, should be returned early.";
                return secondary;
            };
            ShardRouting[] primary = unassigned.drain();
            ShardRouting[] secondary = new ShardRouting[primary.length];
            int secondaryLength = 0;
            int primaryLength = primary.length;
            ArrayUtil.timSort(primary, comparator);
            do {
                for (int i = 0; i < primaryLength; ++i) {
                    long shardSize;
                    ModelNode minNode;
                    ShardRouting shard = primary[i];
                    ProjectIndex index = this.projectIndex(shard);
                    AllocateUnassignedDecision allocationDecision = this.decideAllocateUnassigned(index, shard);
                    String assignedNodeId = allocationDecision.getTargetNode() != null ? allocationDecision.getTargetNode().getId() : null;
                    ModelNode modelNode = minNode = assignedNodeId != null ? this.nodes.get(assignedNodeId) : null;
                    if (allocationDecision.getAllocationDecision() == AllocationDecision.YES) {
                        if (logger.isTraceEnabled()) {
                            logger.trace("Assigned shard [{}] to [{}]", (Object)shard, (Object)minNode.getNodeId());
                        }
                        shardSize = ExpectedShardSizeEstimator.getExpectedShardSize(shard, -1L, this.allocation);
                        shard = this.routingNodes.initializeShard(shard, minNode.getNodeId(), null, shardSize, this.allocation.changes());
                        minNode.addShard(index, shard);
                        if (shard.primary()) continue;
                        while (i < primaryLength - 1 && comparator.compare(primary[i], primary[i + 1]) == 0) {
                            secondary[secondaryLength++] = primary[++i];
                        }
                        continue;
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace("No eligible node found to assign shard [{}] allocation_status [{}]", (Object)shard, (Object)allocationDecision.getAllocationStatus());
                    }
                    if (minNode != null) {
                        assert (allocationDecision.getAllocationStatus() == UnassignedInfo.AllocationStatus.DECIDERS_THROTTLED);
                        shardSize = ExpectedShardSizeEstimator.getExpectedShardSize(shard, -1L, this.allocation);
                        minNode.addShard(this.projectIndex(shard), shard.initialize(minNode.getNodeId(), null, shardSize));
                    } else if (logger.isTraceEnabled()) {
                        logger.trace("No Node found to assign shard [{}]", (Object)shard);
                    }
                    unassigned.ignoreShard(shard, allocationDecision.getAllocationStatus(), this.allocation.changes());
                    if (shard.primary()) continue;
                    while (i < primaryLength - 1 && comparator.compare(primary[i], primary[i + 1]) == 0) {
                        unassigned.ignoreShard(primary[++i], allocationDecision.getAllocationStatus(), this.allocation.changes());
                    }
                }
                primaryLength = secondaryLength;
                ShardRouting[] tmp = primary;
                primary = secondary;
                secondary = tmp;
                secondaryLength = 0;
            } while (primaryLength > 0);
        }

        private ProjectIndex projectIndex(ShardRouting shardRouting) {
            return new ProjectIndex(this.allocation, shardRouting);
        }

        private AllocateUnassignedDecision decideAllocateUnassigned(ProjectIndex index, ShardRouting shard) {
            WeightFunction weightFunction = this.balancingWeights.weightFunctionForShard(shard);
            index.assertMatch(shard);
            if (shard.assignedToNode()) {
                return AllocateUnassignedDecision.NOT_TAKEN;
            }
            boolean explain = this.allocation.debugDecision();
            Decision shardLevelDecision = this.allocation.deciders().canAllocate(shard, this.allocation);
            if (shardLevelDecision.type() == Decision.Type.NO && !explain) {
                return AllocateUnassignedDecision.no(UnassignedInfo.AllocationStatus.DECIDERS_NO, null);
            }
            float minWeight = Float.POSITIVE_INFINITY;
            ModelNode minNode = null;
            Decision decision = null;
            HashMap<String, NodeAllocationResult> nodeExplanationMap = explain ? new HashMap<String, NodeAllocationResult>() : null;
            ArrayList<Tuple<String, Float>> nodeWeights = explain ? new ArrayList<Tuple<String, Float>>() : null;
            for (ModelNode node : this.nodes.values()) {
                boolean updateMinNode;
                float currentWeight;
                if (node.containsShard(index, shard) && !explain || (currentWeight = weightFunction.calculateNodeWeightWithIndex(this, node, index)) > minWeight && !explain) continue;
                Decision decision2 = this.allocation.deciders().canAllocate(shard, node.getRoutingNode(), this.allocation);
                if (explain) {
                    nodeExplanationMap.put(node.getNodeId(), new NodeAllocationResult(node.getRoutingNode().node(), decision2, 0));
                    nodeWeights.add(Tuple.tuple(node.getNodeId(), Float.valueOf(currentWeight)));
                }
                if (decision2.type() != Decision.Type.YES && decision2.type() != Decision.Type.THROTTLE) continue;
                if (currentWeight == minWeight) {
                    if (decision2.type() == decision.type()) {
                        int repId = shard.id();
                        int nodeHigh = node.highestPrimary(index);
                        int minNodeHigh = minNode.highestPrimary(index);
                        updateMinNode = (nodeHigh > repId && minNodeHigh > repId || nodeHigh < repId && minNodeHigh < repId) && nodeHigh < minNodeHigh || nodeHigh > repId && minNodeHigh < repId;
                    } else {
                        updateMinNode = decision2.type() == Decision.Type.YES;
                    }
                } else {
                    boolean bl = updateMinNode = currentWeight < minWeight;
                }
                if (!updateMinNode) continue;
                minNode = node;
                minWeight = currentWeight;
                decision = decision2;
            }
            if (decision == null) {
                decision = Decision.NO;
            }
            ArrayList<NodeAllocationResult> nodeDecisions = null;
            if (explain) {
                nodeDecisions = new ArrayList<NodeAllocationResult>();
                nodeWeights.sort((nodeWeight1, nodeWeight2) -> Float.compare(((Float)nodeWeight1.v2()).floatValue(), ((Float)nodeWeight2.v2()).floatValue()));
                int weightRanking = 0;
                for (Tuple tuple : nodeWeights) {
                    NodeAllocationResult current = (NodeAllocationResult)nodeExplanationMap.get(tuple.v1());
                    nodeDecisions.add(new NodeAllocationResult(current.getNode(), current.getCanAllocateDecision(), ++weightRanking));
                }
            }
            return AllocateUnassignedDecision.fromDecision(decision, minNode != null ? minNode.routingNode.node() : null, nodeDecisions);
        }

        private boolean tryRelocateShard(ModelNode minNode, ModelNode maxNode, ProjectIndex idx) {
            ModelIndex index = maxNode.getIndex(idx);
            if (index != null) {
                logger.trace("Try relocating shard of [{}] from [{}] to [{}]", (Object)idx, (Object)maxNode.getNodeId(), (Object)minNode.getNodeId());
                if (this.shardRoutingsOnMaxWeightNode == null || this.shardRoutingsOnMaxWeightNode.length < index.numShards()) {
                    this.shardRoutingsOnMaxWeightNode = new ShardRouting[index.numShards() * 2];
                }
                int startedShards = 0;
                for (ShardRouting shardRouting : index) {
                    if (!shardRouting.started()) continue;
                    this.shardRoutingsOnMaxWeightNode[startedShards] = shardRouting;
                    ++startedShards;
                }
                ArrayUtil.timSort(this.shardRoutingsOnMaxWeightNode, 0, startedShards, BY_DESCENDING_SHARD_ID);
                AllocationDeciders deciders = this.allocation.deciders();
                for (int shardIndex = 0; shardIndex < startedShards; ++shardIndex) {
                    Decision allocationDecision;
                    ShardRouting shard = this.shardRoutingsOnMaxWeightNode[shardIndex];
                    Decision rebalanceDecision = deciders.canRebalance(shard, this.allocation);
                    if (rebalanceDecision.type() == Decision.Type.NO || (allocationDecision = deciders.canAllocate(shard, minNode.getRoutingNode(), this.allocation)).type() == Decision.Type.NO) continue;
                    Decision.Multi decision = new Decision.Multi().add(allocationDecision).add(rebalanceDecision);
                    maxNode.removeShard(this.projectIndex(shard), shard);
                    long shardSize = this.allocation.clusterInfo().getShardSize(shard, -1L);
                    assert (((Decision)decision).type() == Decision.Type.YES || ((Decision)decision).type() == Decision.Type.THROTTLE) : ((Decision)decision).type();
                    logger.debug("decision [{}]: relocate [{}] from [{}] to [{}]", (Object)((Decision)decision).type(), (Object)shard, (Object)maxNode.getNodeId(), (Object)minNode.getNodeId());
                    minNode.addShard(this.projectIndex(shard), ((Decision)decision).type() == Decision.Type.YES ? this.routingNodes.relocateShard(shard, minNode.getNodeId(), shardSize, "rebalance", this.allocation.changes()).v1() : shard.relocate(minNode.getNodeId(), shardSize));
                    return true;
                }
            }
            logger.trace("No shards of [{}] can relocate from [{}] to [{}]", (Object)idx, (Object)maxNode.getNodeId(), (Object)minNode.getNodeId());
            return false;
        }
    }

    public static class ModelNode
    implements Iterable<ModelIndex> {
        private int numShards = 0;
        private double writeLoad = 0.0;
        private double diskUsageInBytes = 0.0;
        private final WriteLoadForecaster writeLoadForecaster;
        private final Metadata metadata;
        private final ClusterInfo clusterInfo;
        private final RoutingNode routingNode;
        private final Map<ProjectIndex, ModelIndex> indices;

        public ModelNode(WriteLoadForecaster writeLoadForecaster, Metadata metadata, ClusterInfo clusterInfo, RoutingNode routingNode) {
            this.writeLoadForecaster = writeLoadForecaster;
            this.metadata = metadata;
            this.clusterInfo = clusterInfo;
            this.routingNode = routingNode;
            this.indices = Maps.newMapWithExpectedSize(routingNode.size() + 10);
        }

        public ModelIndex getIndex(ProjectIndex index) {
            return this.indices.get(index);
        }

        public String getNodeId() {
            return this.routingNode.nodeId();
        }

        public RoutingNode getRoutingNode() {
            return this.routingNode;
        }

        public int numShards() {
            return this.numShards;
        }

        public int numShards(ProjectIndex idx) {
            ModelIndex index = this.indices.get(idx);
            return index == null ? 0 : index.numShards();
        }

        public double writeLoad() {
            return this.writeLoad;
        }

        public double diskUsageInBytes() {
            return this.diskUsageInBytes;
        }

        public int highestPrimary(ProjectIndex index) {
            ModelIndex idx = this.indices.get(index);
            if (idx != null) {
                return idx.highestPrimary();
            }
            return -1;
        }

        public void addShard(ProjectIndex index, ShardRouting shard) {
            index.assertMatch(shard);
            this.indices.computeIfAbsent(index, t -> new ModelIndex()).addShard(shard);
            IndexMetadata indexMetadata = this.metadata.getProject(index.project).index(shard.index());
            this.writeLoad += this.writeLoadForecaster.getForecastedWriteLoad(indexMetadata).orElse(0.0);
            this.diskUsageInBytes += (double)Balancer.getShardDiskUsageInBytes(shard, indexMetadata, this.clusterInfo);
            ++this.numShards;
        }

        public void removeShard(ProjectIndex projectIndex, ShardRouting shard) {
            ModelIndex index = this.indices.get(projectIndex);
            if (index != null) {
                index.removeShard(shard);
                if (index.numShards() == 0) {
                    this.indices.remove(projectIndex);
                }
            }
            IndexMetadata indexMetadata = this.metadata.getProject(projectIndex.project).index(shard.index());
            this.writeLoad -= this.writeLoadForecaster.getForecastedWriteLoad(indexMetadata).orElse(0.0);
            this.diskUsageInBytes -= (double)Balancer.getShardDiskUsageInBytes(shard, indexMetadata, this.clusterInfo);
            --this.numShards;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Node(").append(this.routingNode.nodeId()).append(")");
            return sb.toString();
        }

        @Override
        public Iterator<ModelIndex> iterator() {
            return this.indices.values().iterator();
        }

        public boolean containsShard(ProjectIndex projIndex, ShardRouting shard) {
            projIndex.assertMatch(shard);
            ModelIndex index = this.getIndex(projIndex);
            return index != null && index.containsShard(shard);
        }
    }

    record ProjectIndex(ProjectId project, String indexName) {
        ProjectIndex(RoutingAllocation allocation, ShardRouting shard) {
            this(allocation.metadata().projectFor(shard.index()).id(), shard.getIndexName());
        }

        public void assertMatch(ShardRouting shard) {
            assert (this.indexName.equals(shard.getIndexName())) : "Index name mismatch [" + String.valueOf(this) + "] vs [" + String.valueOf(shard) + "]";
        }
    }

    public static final class NodeSorter
    extends IntroSorter {
        final ModelNode[] modelNodes;
        final float[] weights;
        private final WeightFunction function;
        private ProjectIndex index;
        private final Balancer balancer;
        private float pivotWeight;

        public NodeSorter(ModelNode[] modelNodes, WeightFunction function, Balancer balancer) {
            this.function = function;
            this.balancer = balancer;
            this.modelNodes = modelNodes;
            this.weights = new float[modelNodes.length];
        }

        public void reset(ProjectIndex index, int from, int to) {
            this.index = index;
            for (int i = from; i < to; ++i) {
                this.weights[i] = this.weight(this.modelNodes[i]);
            }
            this.sort(from, to);
        }

        public void reset(ProjectIndex index) {
            this.reset(index, 0, this.modelNodes.length);
        }

        public float weight(ModelNode node) {
            return this.function.calculateNodeWeightWithIndex(this.balancer, node, this.index);
        }

        public float minWeightDelta() {
            return this.function.minWeightDelta(this.balancer.getShardWriteLoad(this.index), this.balancer.maxShardSizeBytes(this.index));
        }

        @Override
        protected void swap(int i, int j) {
            ModelNode tmpNode = this.modelNodes[i];
            this.modelNodes[i] = this.modelNodes[j];
            this.modelNodes[j] = tmpNode;
            float tmpWeight = this.weights[i];
            this.weights[i] = this.weights[j];
            this.weights[j] = tmpWeight;
        }

        @Override
        protected int compare(int i, int j) {
            return Float.compare(this.weights[i], this.weights[j]);
        }

        @Override
        protected void setPivot(int i) {
            this.pivotWeight = this.weights[i];
        }

        @Override
        protected int comparePivot(int j) {
            return Float.compare(this.pivotWeight, this.weights[j]);
        }

        public float delta() {
            return this.weights.length == 0 ? 0.0f : this.weights[this.weights.length - 1] - this.weights[0];
        }

        public WeightFunction getWeightFunction() {
            return this.function;
        }
    }

    static final class ModelIndex
    implements Iterable<ShardRouting> {
        private final Set<ShardRouting> shards = Sets.newHashSetWithExpectedSize(4);
        private int highestPrimary = -1;

        ModelIndex() {
        }

        public int highestPrimary() {
            if (this.highestPrimary == -1) {
                int maxId = -1;
                for (ShardRouting shard : this.shards) {
                    if (!shard.primary()) continue;
                    maxId = Math.max(maxId, shard.id());
                }
                this.highestPrimary = maxId;
                return this.highestPrimary;
            }
            return this.highestPrimary;
        }

        public int numShards() {
            return this.shards.size();
        }

        @Override
        public Iterator<ShardRouting> iterator() {
            return this.shards.iterator();
        }

        public void removeShard(ShardRouting shard) {
            this.highestPrimary = -1;
            assert (this.shards.contains(shard)) : "Shard not allocated on current node: " + String.valueOf(shard);
            this.shards.remove(shard);
        }

        public void addShard(ShardRouting shard) {
            this.highestPrimary = -1;
            assert (!this.shards.contains(shard)) : "Shard already allocated on current node: " + String.valueOf(shard);
            this.shards.add(shard);
        }

        public boolean containsShard(ShardRouting shard) {
            return this.shards.contains(shard);
        }
    }
}

