/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DataCounts
implements JsonpSerializable {
    private final long bucketCount;
    @Nullable
    private final Long earliestRecordTimestamp;
    private final long emptyBucketCount;
    private final long inputBytes;
    private final long inputFieldCount;
    private final long inputRecordCount;
    private final long invalidDateCount;
    private final String jobId;
    @Nullable
    private final Long lastDataTime;
    @Nullable
    private final Long latestEmptyBucketTimestamp;
    @Nullable
    private final Long latestRecordTimestamp;
    @Nullable
    private final Long latestSparseBucketTimestamp;
    @Nullable
    private final Long latestBucketTimestamp;
    @Nullable
    private final Long logTime;
    private final long missingFieldCount;
    private final long outOfOrderTimestampCount;
    private final long processedFieldCount;
    private final long processedRecordCount;
    private final long sparseBucketCount;
    public static final JsonpDeserializer<DataCounts> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataCounts::setupDataCountsDeserializer);

    private DataCounts(Builder builder) {
        this.bucketCount = ApiTypeHelper.requireNonNull(builder.bucketCount, (Object)this, "bucketCount", 0L);
        this.earliestRecordTimestamp = builder.earliestRecordTimestamp;
        this.emptyBucketCount = ApiTypeHelper.requireNonNull(builder.emptyBucketCount, (Object)this, "emptyBucketCount", 0L);
        this.inputBytes = ApiTypeHelper.requireNonNull(builder.inputBytes, (Object)this, "inputBytes", 0L);
        this.inputFieldCount = ApiTypeHelper.requireNonNull(builder.inputFieldCount, (Object)this, "inputFieldCount", 0L);
        this.inputRecordCount = ApiTypeHelper.requireNonNull(builder.inputRecordCount, (Object)this, "inputRecordCount", 0L);
        this.invalidDateCount = ApiTypeHelper.requireNonNull(builder.invalidDateCount, (Object)this, "invalidDateCount", 0L);
        this.jobId = ApiTypeHelper.requireNonNull(builder.jobId, this, "jobId");
        this.lastDataTime = builder.lastDataTime;
        this.latestEmptyBucketTimestamp = builder.latestEmptyBucketTimestamp;
        this.latestRecordTimestamp = builder.latestRecordTimestamp;
        this.latestSparseBucketTimestamp = builder.latestSparseBucketTimestamp;
        this.latestBucketTimestamp = builder.latestBucketTimestamp;
        this.logTime = builder.logTime;
        this.missingFieldCount = ApiTypeHelper.requireNonNull(builder.missingFieldCount, (Object)this, "missingFieldCount", 0L);
        this.outOfOrderTimestampCount = ApiTypeHelper.requireNonNull(builder.outOfOrderTimestampCount, (Object)this, "outOfOrderTimestampCount", 0L);
        this.processedFieldCount = ApiTypeHelper.requireNonNull(builder.processedFieldCount, (Object)this, "processedFieldCount", 0L);
        this.processedRecordCount = ApiTypeHelper.requireNonNull(builder.processedRecordCount, (Object)this, "processedRecordCount", 0L);
        this.sparseBucketCount = ApiTypeHelper.requireNonNull(builder.sparseBucketCount, (Object)this, "sparseBucketCount", 0L);
    }

    public static DataCounts of(Function<Builder, ObjectBuilder<DataCounts>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long bucketCount() {
        return this.bucketCount;
    }

    @Nullable
    public final Long earliestRecordTimestamp() {
        return this.earliestRecordTimestamp;
    }

    public final long emptyBucketCount() {
        return this.emptyBucketCount;
    }

    public final long inputBytes() {
        return this.inputBytes;
    }

    public final long inputFieldCount() {
        return this.inputFieldCount;
    }

    public final long inputRecordCount() {
        return this.inputRecordCount;
    }

    public final long invalidDateCount() {
        return this.invalidDateCount;
    }

    public final String jobId() {
        return this.jobId;
    }

    @Nullable
    public final Long lastDataTime() {
        return this.lastDataTime;
    }

    @Nullable
    public final Long latestEmptyBucketTimestamp() {
        return this.latestEmptyBucketTimestamp;
    }

    @Nullable
    public final Long latestRecordTimestamp() {
        return this.latestRecordTimestamp;
    }

    @Nullable
    public final Long latestSparseBucketTimestamp() {
        return this.latestSparseBucketTimestamp;
    }

    @Nullable
    public final Long latestBucketTimestamp() {
        return this.latestBucketTimestamp;
    }

    @Nullable
    public final Long logTime() {
        return this.logTime;
    }

    public final long missingFieldCount() {
        return this.missingFieldCount;
    }

    public final long outOfOrderTimestampCount() {
        return this.outOfOrderTimestampCount;
    }

    public final long processedFieldCount() {
        return this.processedFieldCount;
    }

    public final long processedRecordCount() {
        return this.processedRecordCount;
    }

    public final long sparseBucketCount() {
        return this.sparseBucketCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("bucket_count");
        generator.write(this.bucketCount);
        if (this.earliestRecordTimestamp != null) {
            generator.writeKey("earliest_record_timestamp");
            generator.write(this.earliestRecordTimestamp);
        }
        generator.writeKey("empty_bucket_count");
        generator.write(this.emptyBucketCount);
        generator.writeKey("input_bytes");
        generator.write(this.inputBytes);
        generator.writeKey("input_field_count");
        generator.write(this.inputFieldCount);
        generator.writeKey("input_record_count");
        generator.write(this.inputRecordCount);
        generator.writeKey("invalid_date_count");
        generator.write(this.invalidDateCount);
        generator.writeKey("job_id");
        generator.write(this.jobId);
        if (this.lastDataTime != null) {
            generator.writeKey("last_data_time");
            generator.write(this.lastDataTime);
        }
        if (this.latestEmptyBucketTimestamp != null) {
            generator.writeKey("latest_empty_bucket_timestamp");
            generator.write(this.latestEmptyBucketTimestamp);
        }
        if (this.latestRecordTimestamp != null) {
            generator.writeKey("latest_record_timestamp");
            generator.write(this.latestRecordTimestamp);
        }
        if (this.latestSparseBucketTimestamp != null) {
            generator.writeKey("latest_sparse_bucket_timestamp");
            generator.write(this.latestSparseBucketTimestamp);
        }
        if (this.latestBucketTimestamp != null) {
            generator.writeKey("latest_bucket_timestamp");
            generator.write(this.latestBucketTimestamp);
        }
        if (this.logTime != null) {
            generator.writeKey("log_time");
            generator.write(this.logTime);
        }
        generator.writeKey("missing_field_count");
        generator.write(this.missingFieldCount);
        generator.writeKey("out_of_order_timestamp_count");
        generator.write(this.outOfOrderTimestampCount);
        generator.writeKey("processed_field_count");
        generator.write(this.processedFieldCount);
        generator.writeKey("processed_record_count");
        generator.write(this.processedRecordCount);
        generator.writeKey("sparse_bucket_count");
        generator.write(this.sparseBucketCount);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupDataCountsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::bucketCount, JsonpDeserializer.longDeserializer(), "bucket_count");
        op.add(Builder::earliestRecordTimestamp, JsonpDeserializer.longDeserializer(), "earliest_record_timestamp");
        op.add(Builder::emptyBucketCount, JsonpDeserializer.longDeserializer(), "empty_bucket_count");
        op.add(Builder::inputBytes, JsonpDeserializer.longDeserializer(), "input_bytes");
        op.add(Builder::inputFieldCount, JsonpDeserializer.longDeserializer(), "input_field_count");
        op.add(Builder::inputRecordCount, JsonpDeserializer.longDeserializer(), "input_record_count");
        op.add(Builder::invalidDateCount, JsonpDeserializer.longDeserializer(), "invalid_date_count");
        op.add(Builder::jobId, JsonpDeserializer.stringDeserializer(), "job_id");
        op.add(Builder::lastDataTime, JsonpDeserializer.longDeserializer(), "last_data_time");
        op.add(Builder::latestEmptyBucketTimestamp, JsonpDeserializer.longDeserializer(), "latest_empty_bucket_timestamp");
        op.add(Builder::latestRecordTimestamp, JsonpDeserializer.longDeserializer(), "latest_record_timestamp");
        op.add(Builder::latestSparseBucketTimestamp, JsonpDeserializer.longDeserializer(), "latest_sparse_bucket_timestamp");
        op.add(Builder::latestBucketTimestamp, JsonpDeserializer.longDeserializer(), "latest_bucket_timestamp");
        op.add(Builder::logTime, JsonpDeserializer.longDeserializer(), "log_time");
        op.add(Builder::missingFieldCount, JsonpDeserializer.longDeserializer(), "missing_field_count");
        op.add(Builder::outOfOrderTimestampCount, JsonpDeserializer.longDeserializer(), "out_of_order_timestamp_count");
        op.add(Builder::processedFieldCount, JsonpDeserializer.longDeserializer(), "processed_field_count");
        op.add(Builder::processedRecordCount, JsonpDeserializer.longDeserializer(), "processed_record_count");
        op.add(Builder::sparseBucketCount, JsonpDeserializer.longDeserializer(), "sparse_bucket_count");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DataCounts> {
        private Long bucketCount;
        @Nullable
        private Long earliestRecordTimestamp;
        private Long emptyBucketCount;
        private Long inputBytes;
        private Long inputFieldCount;
        private Long inputRecordCount;
        private Long invalidDateCount;
        private String jobId;
        @Nullable
        private Long lastDataTime;
        @Nullable
        private Long latestEmptyBucketTimestamp;
        @Nullable
        private Long latestRecordTimestamp;
        @Nullable
        private Long latestSparseBucketTimestamp;
        @Nullable
        private Long latestBucketTimestamp;
        @Nullable
        private Long logTime;
        private Long missingFieldCount;
        private Long outOfOrderTimestampCount;
        private Long processedFieldCount;
        private Long processedRecordCount;
        private Long sparseBucketCount;

        public final Builder bucketCount(long value) {
            this.bucketCount = value;
            return this;
        }

        public final Builder earliestRecordTimestamp(@Nullable Long value) {
            this.earliestRecordTimestamp = value;
            return this;
        }

        public final Builder emptyBucketCount(long value) {
            this.emptyBucketCount = value;
            return this;
        }

        public final Builder inputBytes(long value) {
            this.inputBytes = value;
            return this;
        }

        public final Builder inputFieldCount(long value) {
            this.inputFieldCount = value;
            return this;
        }

        public final Builder inputRecordCount(long value) {
            this.inputRecordCount = value;
            return this;
        }

        public final Builder invalidDateCount(long value) {
            this.invalidDateCount = value;
            return this;
        }

        public final Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public final Builder lastDataTime(@Nullable Long value) {
            this.lastDataTime = value;
            return this;
        }

        public final Builder latestEmptyBucketTimestamp(@Nullable Long value) {
            this.latestEmptyBucketTimestamp = value;
            return this;
        }

        public final Builder latestRecordTimestamp(@Nullable Long value) {
            this.latestRecordTimestamp = value;
            return this;
        }

        public final Builder latestSparseBucketTimestamp(@Nullable Long value) {
            this.latestSparseBucketTimestamp = value;
            return this;
        }

        public final Builder latestBucketTimestamp(@Nullable Long value) {
            this.latestBucketTimestamp = value;
            return this;
        }

        public final Builder logTime(@Nullable Long value) {
            this.logTime = value;
            return this;
        }

        public final Builder missingFieldCount(long value) {
            this.missingFieldCount = value;
            return this;
        }

        public final Builder outOfOrderTimestampCount(long value) {
            this.outOfOrderTimestampCount = value;
            return this;
        }

        public final Builder processedFieldCount(long value) {
            this.processedFieldCount = value;
            return this;
        }

        public final Builder processedRecordCount(long value) {
            this.processedRecordCount = value;
            return this;
        }

        public final Builder sparseBucketCount(long value) {
            this.sparseBucketCount = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataCounts build() {
            this._checkSingleUse();
            return new DataCounts(this);
        }
    }
}

