/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.Processor;
import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class NetworkDirectionProcessor
extends ProcessorBase
implements ProcessorVariant {
    @Nullable
    private final String sourceIp;
    @Nullable
    private final String destinationIp;
    @Nullable
    private final String targetField;
    private final List<String> internalNetworks;
    @Nullable
    private final String internalNetworksField;
    @Nullable
    private final Boolean ignoreMissing;
    public static final JsonpDeserializer<NetworkDirectionProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NetworkDirectionProcessor::setupNetworkDirectionProcessorDeserializer);

    private NetworkDirectionProcessor(Builder builder) {
        super(builder);
        this.sourceIp = builder.sourceIp;
        this.destinationIp = builder.destinationIp;
        this.targetField = builder.targetField;
        this.internalNetworks = ApiTypeHelper.unmodifiable(builder.internalNetworks);
        this.internalNetworksField = builder.internalNetworksField;
        this.ignoreMissing = builder.ignoreMissing;
    }

    public static NetworkDirectionProcessor of(Function<Builder, ObjectBuilder<NetworkDirectionProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.NetworkDirection;
    }

    @Nullable
    public final String sourceIp() {
        return this.sourceIp;
    }

    @Nullable
    public final String destinationIp() {
        return this.destinationIp;
    }

    @Nullable
    public final String targetField() {
        return this.targetField;
    }

    public final List<String> internalNetworks() {
        return this.internalNetworks;
    }

    @Nullable
    public final String internalNetworksField() {
        return this.internalNetworksField;
    }

    @Nullable
    public final Boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.sourceIp != null) {
            generator.writeKey("source_ip");
            generator.write(this.sourceIp);
        }
        if (this.destinationIp != null) {
            generator.writeKey("destination_ip");
            generator.write(this.destinationIp);
        }
        if (this.targetField != null) {
            generator.writeKey("target_field");
            generator.write(this.targetField);
        }
        if (ApiTypeHelper.isDefined(this.internalNetworks)) {
            generator.writeKey("internal_networks");
            generator.writeStartArray();
            for (String item0 : this.internalNetworks) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.internalNetworksField != null) {
            generator.writeKey("internal_networks_field");
            generator.write(this.internalNetworksField);
        }
        if (this.ignoreMissing != null) {
            generator.writeKey("ignore_missing");
            generator.write(this.ignoreMissing);
        }
    }

    protected static void setupNetworkDirectionProcessorDeserializer(ObjectDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::sourceIp, JsonpDeserializer.stringDeserializer(), "source_ip");
        op.add(Builder::destinationIp, JsonpDeserializer.stringDeserializer(), "destination_ip");
        op.add(Builder::targetField, JsonpDeserializer.stringDeserializer(), "target_field");
        op.add(Builder::internalNetworks, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "internal_networks");
        op.add(Builder::internalNetworksField, JsonpDeserializer.stringDeserializer(), "internal_networks_field");
        op.add(Builder::ignoreMissing, JsonpDeserializer.booleanDeserializer(), "ignore_missing");
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<NetworkDirectionProcessor> {
        @Nullable
        private String sourceIp;
        @Nullable
        private String destinationIp;
        @Nullable
        private String targetField;
        @Nullable
        private List<String> internalNetworks;
        @Nullable
        private String internalNetworksField;
        @Nullable
        private Boolean ignoreMissing;

        public final Builder sourceIp(@Nullable String value) {
            this.sourceIp = value;
            return this;
        }

        public final Builder destinationIp(@Nullable String value) {
            this.destinationIp = value;
            return this;
        }

        public final Builder targetField(@Nullable String value) {
            this.targetField = value;
            return this;
        }

        public final Builder internalNetworks(List<String> list) {
            this.internalNetworks = Builder._listAddAll(this.internalNetworks, list);
            return this;
        }

        public final Builder internalNetworks(String value, String ... values) {
            this.internalNetworks = Builder._listAdd(this.internalNetworks, value, values);
            return this;
        }

        public final Builder internalNetworksField(@Nullable String value) {
            this.internalNetworksField = value;
            return this;
        }

        public final Builder ignoreMissing(@Nullable Boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NetworkDirectionProcessor build() {
            this._checkSingleUse();
            return new NetworkDirectionProcessor(this);
        }
    }
}

