/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.GeoLocation;
import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.mapping.DocValuesPropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.OnScriptError;
import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GeoPointProperty
extends DocValuesPropertyBase
implements PropertyVariant {
    @Nullable
    private final Boolean ignoreMalformed;
    @Nullable
    private final Boolean ignoreZValue;
    @Nullable
    private final GeoLocation nullValue;
    @Nullable
    private final Boolean index;
    @Nullable
    private final OnScriptError onScriptError;
    @Nullable
    private final Script script;
    public static final JsonpDeserializer<GeoPointProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoPointProperty::setupGeoPointPropertyDeserializer);

    private GeoPointProperty(Builder builder) {
        super(builder);
        this.ignoreMalformed = builder.ignoreMalformed;
        this.ignoreZValue = builder.ignoreZValue;
        this.nullValue = builder.nullValue;
        this.index = builder.index;
        this.onScriptError = builder.onScriptError;
        this.script = builder.script;
    }

    public static GeoPointProperty of(Function<Builder, ObjectBuilder<GeoPointProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.GeoPoint;
    }

    @Nullable
    public final Boolean ignoreMalformed() {
        return this.ignoreMalformed;
    }

    @Nullable
    public final Boolean ignoreZValue() {
        return this.ignoreZValue;
    }

    @Nullable
    public final GeoLocation nullValue() {
        return this.nullValue;
    }

    @Nullable
    public final Boolean index() {
        return this.index;
    }

    @Nullable
    public final OnScriptError onScriptError() {
        return this.onScriptError;
    }

    @Nullable
    public final Script script() {
        return this.script;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "geo_point");
        super.serializeInternal(generator, mapper);
        if (this.ignoreMalformed != null) {
            generator.writeKey("ignore_malformed");
            generator.write(this.ignoreMalformed);
        }
        if (this.ignoreZValue != null) {
            generator.writeKey("ignore_z_value");
            generator.write(this.ignoreZValue);
        }
        if (this.nullValue != null) {
            generator.writeKey("null_value");
            this.nullValue.serialize(generator, mapper);
        }
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index);
        }
        if (this.onScriptError != null) {
            generator.writeKey("on_script_error");
            this.onScriptError.serialize(generator, mapper);
        }
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
    }

    protected static void setupGeoPointPropertyDeserializer(ObjectDeserializer<Builder> op) {
        DocValuesPropertyBase.setupDocValuesPropertyBaseDeserializer(op);
        op.add(Builder::ignoreMalformed, JsonpDeserializer.booleanDeserializer(), "ignore_malformed");
        op.add(Builder::ignoreZValue, JsonpDeserializer.booleanDeserializer(), "ignore_z_value");
        op.add(Builder::nullValue, GeoLocation._DESERIALIZER, "null_value");
        op.add(Builder::index, JsonpDeserializer.booleanDeserializer(), "index");
        op.add(Builder::onScriptError, OnScriptError._DESERIALIZER, "on_script_error");
        op.add(Builder::script, Script._DESERIALIZER, "script");
        op.ignore("type");
    }

    public static class Builder
    extends DocValuesPropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GeoPointProperty> {
        @Nullable
        private Boolean ignoreMalformed;
        @Nullable
        private Boolean ignoreZValue;
        @Nullable
        private GeoLocation nullValue;
        @Nullable
        private Boolean index;
        @Nullable
        private OnScriptError onScriptError;
        @Nullable
        private Script script;

        public final Builder ignoreMalformed(@Nullable Boolean value) {
            this.ignoreMalformed = value;
            return this;
        }

        public final Builder ignoreZValue(@Nullable Boolean value) {
            this.ignoreZValue = value;
            return this;
        }

        public final Builder nullValue(@Nullable GeoLocation value) {
            this.nullValue = value;
            return this;
        }

        public final Builder nullValue(Function<GeoLocation.Builder, ObjectBuilder<GeoLocation>> fn) {
            return this.nullValue(fn.apply(new GeoLocation.Builder()).build());
        }

        public final Builder index(@Nullable Boolean value) {
            this.index = value;
            return this;
        }

        public final Builder onScriptError(@Nullable OnScriptError value) {
            this.onScriptError = value;
            return this;
        }

        public final Builder script(@Nullable Script value) {
            this.script = value;
            return this;
        }

        public final Builder script(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.script(fn.apply(new Script.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GeoPointProperty build() {
            this._checkSingleUse();
            return new GeoPointProperty(this);
        }
    }
}

