/*
 * Decompiled with CFR 0.152.
 */
package murmurhash3;

import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyFixnum;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

class MurmurBase {
    protected static final byte[] hex = new byte[]{48, 48, 48, 49, 48, 50, 48, 51, 48, 52, 48, 53, 48, 54, 48, 55, 48, 56, 48, 57, 48, 97, 48, 98, 48, 99, 48, 100, 48, 101, 48, 102, 49, 48, 49, 49, 49, 50, 49, 51, 49, 52, 49, 53, 49, 54, 49, 55, 49, 56, 49, 57, 49, 97, 49, 98, 49, 99, 49, 100, 49, 101, 49, 102, 50, 48, 50, 49, 50, 50, 50, 51, 50, 52, 50, 53, 50, 54, 50, 55, 50, 56, 50, 57, 50, 97, 50, 98, 50, 99, 50, 100, 50, 101, 50, 102, 51, 48, 51, 49, 51, 50, 51, 51, 51, 52, 51, 53, 51, 54, 51, 55, 51, 56, 51, 57, 51, 97, 51, 98, 51, 99, 51, 100, 51, 101, 51, 102, 52, 48, 52, 49, 52, 50, 52, 51, 52, 52, 52, 53, 52, 54, 52, 55, 52, 56, 52, 57, 52, 97, 52, 98, 52, 99, 52, 100, 52, 101, 52, 102, 53, 48, 53, 49, 53, 50, 53, 51, 53, 52, 53, 53, 53, 54, 53, 55, 53, 56, 53, 57, 53, 97, 53, 98, 53, 99, 53, 100, 53, 101, 53, 102, 54, 48, 54, 49, 54, 50, 54, 51, 54, 52, 54, 53, 54, 54, 54, 55, 54, 56, 54, 57, 54, 97, 54, 98, 54, 99, 54, 100, 54, 101, 54, 102, 55, 48, 55, 49, 55, 50, 55, 51, 55, 52, 55, 53, 55, 54, 55, 55, 55, 56, 55, 57, 55, 97, 55, 98, 55, 99, 55, 100, 55, 101, 55, 102, 56, 48, 56, 49, 56, 50, 56, 51, 56, 52, 56, 53, 56, 54, 56, 55, 56, 56, 56, 57, 56, 97, 56, 98, 56, 99, 56, 100, 56, 101, 56, 102, 57, 48, 57, 49, 57, 50, 57, 51, 57, 52, 57, 53, 57, 54, 57, 55, 57, 56, 57, 57, 57, 97, 57, 98, 57, 99, 57, 100, 57, 101, 57, 102, 97, 48, 97, 49, 97, 50, 97, 51, 97, 52, 97, 53, 97, 54, 97, 55, 97, 56, 97, 57, 97, 97, 97, 98, 97, 99, 97, 100, 97, 101, 97, 102, 98, 48, 98, 49, 98, 50, 98, 51, 98, 52, 98, 53, 98, 54, 98, 55, 98, 56, 98, 57, 98, 97, 98, 98, 98, 99, 98, 100, 98, 101, 98, 102, 99, 48, 99, 49, 99, 50, 99, 51, 99, 52, 99, 53, 99, 54, 99, 55, 99, 56, 99, 57, 99, 97, 99, 98, 99, 99, 99, 100, 99, 101, 99, 102, 100, 48, 100, 49, 100, 50, 100, 51, 100, 52, 100, 53, 100, 54, 100, 55, 100, 56, 100, 57, 100, 97, 100, 98, 100, 99, 100, 100, 100, 101, 100, 102, 101, 48, 101, 49, 101, 50, 101, 51, 101, 52, 101, 53, 101, 54, 101, 55, 101, 56, 101, 57, 101, 97, 101, 98, 101, 99, 101, 100, 101, 101, 101, 102, 102, 48, 102, 49, 102, 50, 102, 51, 102, 52, 102, 53, 102, 54, 102, 55, 102, 56, 102, 57, 102, 97, 102, 98, 102, 99, 102, 100, 102, 101, 102, 102};
    protected static final byte[] base64 = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};

    MurmurBase() {
    }

    protected static IRubyObject hexdigest(ThreadContext threadContext, byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length * 2];
        for (int i = 0; i < byArray.length; ++i) {
            int n = 0xFF & byArray[i];
            byArray2[i * 2] = hex[n * 2];
            byArray2[i * 2 + 1] = hex[n * 2 + 1];
        }
        return RubyString.newStringNoCopy((Ruby)threadContext.runtime, (byte[])byArray2);
    }

    protected static IRubyObject base64digest(ThreadContext threadContext, byte[] byArray) {
        int n = (byArray.length + 2) / 3;
        byte[] byArray2 = new byte[n * 4];
        for (int i = 0; i < n; ++i) {
            int n2 = (0xFF & byArray[i * 3]) << 16;
            if (i * 3 + 1 < byArray.length) {
                n2 |= (0xFF & byArray[i * 3 + 1]) << 8;
            }
            if (i * 3 + 2 < byArray.length) {
                n2 |= (0xFF & byArray[i * 3 + 2]) << 0;
            }
            byArray2[i * 4 + 0] = base64[n2 >> 18 & 0x3F];
            byArray2[i * 4 + 1] = base64[n2 >> 12 & 0x3F];
            byArray2[i * 4 + 2] = base64[n2 >> 6 & 0x3F];
            byArray2[i * 4 + 3] = base64[n2 >> 0 & 0x3F];
        }
        switch (byArray.length % 3) {
            case 2: {
                byArray2[n * 4 - 1] = 61;
                break;
            }
            case 1: {
                byArray2[n * 4 - 1] = 61;
                byArray2[n * 4 - 2] = 61;
            }
        }
        return RubyString.newStringNoCopy((Ruby)threadContext.runtime, (byte[])byArray2);
    }

    protected static final int read32(byte[] byArray, int n) {
        return 0xFF & byArray[n] | (0xFF & byArray[n + 1]) << 8 | (0xFF & byArray[n + 2]) << 16 | (0xFF & byArray[n + 3]) << 24;
    }

    protected static final int read24(byte[] byArray, int n, int n2) {
        switch (n2) {
            case 3: {
                return 0xFF & byArray[n] | (0xFF & byArray[n + 1]) << 8 | (0xFF & byArray[n + 2]) << 16;
            }
            case 2: {
                return 0xFF & byArray[n] | (0xFF & byArray[n + 1]) << 8;
            }
            case 1: {
                return 0xFF & byArray[n];
            }
        }
        return 0;
    }

    protected static final long read64(byte[] byArray, int n) {
        return (long)(0xFF & byArray[n]) | (long)(0xFF & byArray[n + 1]) << 8 | (long)(0xFF & byArray[n + 2]) << 16 | (long)(0xFF & byArray[n + 3]) << 24 | (long)(0xFF & byArray[n + 4]) << 32 | (long)(0xFF & byArray[n + 5]) << 40 | (long)(0xFF & byArray[n + 6]) << 48 | (long)(0xFF & byArray[n + 7]) << 56;
    }

    protected static final long read56(byte[] byArray, int n, int n2) {
        long l = 0L;
        if ((n2 & 3) != 0) {
            l = MurmurBase.read24(byArray, n, n2 & 3);
        }
        if ((n2 & 4) != 0) {
            l |= ((long)MurmurBase.read32(byArray, n + (n2 & 3)) & 0xFFFFFFFFL) << (n2 & 3) * 8;
        }
        return l;
    }

    protected static final byte[] digest32(int n) {
        byte[] byArray = new byte[]{(byte)n, (byte)(n >>> 8), (byte)(n >>> 16), (byte)(n >>> 24)};
        return byArray;
    }

    protected static final byte[] digest64(long l) {
        byte[] byArray = new byte[]{(byte)l, (byte)(l >>> 8), (byte)(l >>> 16), (byte)(l >>> 24), (byte)(l >>> 32), (byte)(l >>> 40), (byte)(l >>> 48), (byte)(l >>> 56)};
        return byArray;
    }

    protected static final byte[] digest128(long l, long l2) {
        byte[] byArray = new byte[]{(byte)l, (byte)(l >>> 8), (byte)(l >>> 16), (byte)(l >>> 24), (byte)(l >>> 32), (byte)(l >>> 40), (byte)(l >>> 48), (byte)(l >>> 56), (byte)l2, (byte)(l2 >>> 8), (byte)(l2 >>> 16), (byte)(l2 >>> 24), (byte)(l2 >>> 32), (byte)(l2 >>> 40), (byte)(l2 >>> 48), (byte)(l2 >>> 56)};
        return byArray;
    }

    protected static final long num2ulong(IRubyObject iRubyObject) {
        long l = iRubyObject instanceof RubyBignum ? RubyBignum.big2ulong((RubyBignum)((RubyBignum)iRubyObject)) : RubyNumeric.num2long((IRubyObject)iRubyObject);
        return l;
    }

    protected static final IRubyObject ulong2num(ThreadContext threadContext, long l) {
        if (l < 0L) {
            RubyBignum rubyBignum = RubyBignum.newBignum((Ruby)threadContext.runtime, (long)(l >>> 32));
            rubyBignum = (RubyBignum)rubyBignum.op_lshift((IRubyObject)RubyFixnum.newFixnum((Ruby)threadContext.runtime, (long)32L));
            return rubyBignum.op_plus(threadContext, l & 0xFFFFFFFFL);
        }
        return RubyFixnum.newFixnum((Ruby)threadContext.runtime, (long)l);
    }
}

