/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.instrument.metrics;

import java.util.Map;
import java.util.function.Supplier;
import org.logstash.instrument.metrics.ExtendedFlowMetric;
import org.logstash.instrument.metrics.LazyInstantiatedFlowMetric;
import org.logstash.instrument.metrics.Metric;
import org.logstash.instrument.metrics.SimpleFlowMetric;

public interface FlowMetric
extends Metric<Map<String, Double>> {
    public void capture();

    public static FlowMetric create(String name, Metric<? extends Number> numerator, Metric<? extends Number> denominator) {
        switch (System.getProperty("logstash.flowMetric", "extended")) {
            case "extended": {
                return new ExtendedFlowMetric(name, numerator, denominator);
            }
        }
        return new SimpleFlowMetric(name, numerator, denominator);
    }

    public static FlowMetric create(String name, Supplier<? extends Metric<? extends Number>> numeratorSupplier, Supplier<? extends Metric<? extends Number>> denominatorSupplier) {
        return new LazyInstantiatedFlowMetric(name, numeratorSupplier, denominatorSupplier);
    }
}

